/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.jackson.nullable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class JsonNullable<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final JsonNullable<?> UNDEFINED = new JsonNullable<Object>(null, false);
    private T value;
    private boolean isPresent;

    private JsonNullable(T value, boolean isPresent) {
        this.value = value;
        this.isPresent = isPresent;
    }

    public static <T> JsonNullable<T> undefined() {
        JsonNullable<?> t = UNDEFINED;
        return t;
    }

    public static <T> JsonNullable<T> of(T value) {
        return new JsonNullable<T>(value, true);
    }

    public T get() {
        if (!this.isPresent) {
            throw new NoSuchElementException("Value is undefined");
        }
        return this.value;
    }

    public T orElse(T other) {
        return this.isPresent ? this.value : other;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonNullable)) {
            return false;
        }
        JsonNullable other = (JsonNullable)obj;
        return JsonNullable.equals(this.value, other.value) && JsonNullable.equals(this.isPresent, other.isPresent);
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public int hashCode() {
        int result = 31 + (this.value == null ? 0 : this.value.hashCode());
        Boolean bool1 = Boolean.TRUE;
        bool1.hashCode();
        result = 31 * result + (this.isPresent ? 1231 : 1237);
        return result;
    }

    public String toString() {
        return this.isPresent ? String.format("JsonNullable[%s]", this.value) : "JsonNullable.undefined";
    }
}

