/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.annotations.VisibleForTesting;
import org.opendaylight.mdsal.binding.java.api.generator.BuilderTemplate;
import org.opendaylight.mdsal.binding.model.api.CodeGenerator;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.CodegenGeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.CodegenGeneratedTypeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.YangData;

public final class BuilderGenerator
implements CodeGenerator {
    private static final JavaTypeName AUGMENTABLE = JavaTypeName.create(Augmentable.class);
    private static final JavaTypeName AUGMENTATION = JavaTypeName.create(Augmentation.class);
    private static final JavaTypeName YANG_DATA = JavaTypeName.create(YangData.class);

    public boolean isAcceptable(Type type) {
        if (type instanceof GeneratedType) {
            GeneratedType generated = (GeneratedType)type;
            if (!(type instanceof GeneratedTransferObject)) {
                for (Type t : generated.getImplements()) {
                    JavaTypeName name = (JavaTypeName)t.getIdentifier();
                    if (!name.equals((Object)AUGMENTABLE) && !name.equals((Object)AUGMENTATION) && !name.equals((Object)YANG_DATA)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String generate(Type type) {
        if (type instanceof GeneratedType) {
            GeneratedType generated = (GeneratedType)type;
            if (!(type instanceof GeneratedTransferObject)) {
                return BuilderGenerator.templateForType(generated).generate();
            }
        }
        return "";
    }

    public String getUnitName(Type type) {
        return type.getName() + "Builder";
    }

    @VisibleForTesting
    static BuilderTemplate templateForType(GeneratedType type) {
        JavaTypeName origName = (JavaTypeName)type.getIdentifier();
        JavaTypeName builderName = origName.createSibling(origName.simpleName() + "Builder");
        return new BuilderTemplate(((GeneratedTypeBuilder)new CodegenGeneratedTypeBuilder(builderName).addEnclosingTransferObject(((GeneratedTOBuilder)new CodegenGeneratedTOBuilder(builderName.createEnclosed(origName.simpleName() + "Impl")).addImplementsType((Type)type)).build())).build(), type, BuilderGenerator.getKey(type));
    }

    private static Type getKey(GeneratedType type) {
        for (MethodSignature m : type.getMethodDefinitions()) {
            if (!"key".equals(m.getName())) continue;
            return m.getReturnType();
        }
        return null;
    }
}

