/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractBaseTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractBuilderTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.BaseTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.BuilderGeneratedProperty;
import org.opendaylight.mdsal.binding.java.api.generator.BuilderImplTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.GeneratorUtil;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.binding.contract.Naming;

public class BuilderTemplate
extends AbstractBuilderTemplate {
    private final BuilderImplTemplate implTemplate;

    public BuilderTemplate(GeneratedType genType, GeneratedType targetType, Type keyType) {
        super(genType, targetType, keyType);
        BuilderImplTemplate _builderImplTemplate;
        GeneratedType _get = (GeneratedType)this.type().getEnclosedTypes().get(0);
        this.implTemplate = _builderImplTemplate = new BuilderImplTemplate(this, _get);
    }

    @Override
    public boolean isLocalInnerClass(JavaTypeName name) {
        return false;
    }

    @Override
    public CharSequence body() {
        StringConcatenation _builder = new StringConcatenation();
        String _wrapToDocumentation = BaseTemplate.wrapToDocumentation(this.formatDataForJavaDoc(this.targetType));
        _builder.append(_wrapToDocumentation);
        _builder.newLineIfNotEmpty();
        CharSequence _generateDeprecatedAnnotation = this.generateDeprecatedAnnotation(this.targetType.getAnnotations());
        _builder.append((Object)_generateDeprecatedAnnotation);
        _builder.newLineIfNotEmpty();
        String _generatedAnnotation = this.generatedAnnotation();
        _builder.append(_generatedAnnotation);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateFields = this.generateFields(false);
        _builder.append((Object)_generateFields, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _constantsDeclarations = this.constantsDeclarations();
        _builder.append((Object)_constantsDeclarations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (this.augmentType != null) {
            _builder.append("    ");
            String augmentTypeRef = this.importedName(this.augmentType);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            String mapTypeRef = this.importedName(JavaFileTemplate.JU_MAP);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append(mapTypeRef, "    ");
            _builder.append("<");
            String _importedName = this.importedName(JavaFileTemplate.CLASS);
            _builder.append(_importedName, "    ");
            _builder.append("<? extends ");
            _builder.append(augmentTypeRef, "    ");
            _builder.append(">, ");
            _builder.append(augmentTypeRef, "    ");
            _builder.append("> ");
            _builder.append("augmentation", "    ");
            _builder.append(" = ");
            _builder.append(mapTypeRef, "    ");
            _builder.append(".of();");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Construct an empty builder.");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public ");
        String _name_1 = this.type().getName();
        _builder.append(_name_1, "    ");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("// No-op");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateConstructorsFromIfcs = this.generateConstructorsFromIfcs();
        _builder.append((Object)_generateConstructorsFromIfcs, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        String targetTypeName = this.importedName((Type)this.targetType);
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Construct a builder initialized with state from specified {@link ");
        _builder.append(targetTypeName, "     ");
        _builder.append("}.");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @param base ");
        _builder.append(targetTypeName, "     ");
        _builder.append(" from which the builder should be initialized");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public ");
        CharSequence _generateCopyConstructor = this.generateCopyConstructor((Type)this.targetType, (Type)this.type().getEnclosedTypes().get(0));
        _builder.append((Object)_generateCopyConstructor, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateMethodFieldsFrom = this.generateMethodFieldsFrom();
        _builder.append((Object)_generateMethodFieldsFrom, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isNonPresenceContainer = GeneratorUtil.isNonPresenceContainer(this.targetType);
        if (_isNonPresenceContainer) {
            _builder.append("    ");
            CharSequence _generateEmptyInstance = this.generateEmptyInstance();
            _builder.append((Object)_generateEmptyInstance, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateGetters = this.generateGetters(false);
        _builder.append((Object)_generateGetters, "    ");
        _builder.newLineIfNotEmpty();
        if (this.augmentType != null) {
            _builder.newLine();
            _builder.append("    ");
            CharSequence _generateAugmentation = this.generateAugmentation();
            _builder.append((Object)_generateAugmentation, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateSetters = this.generateSetters();
        _builder.append((Object)_generateSetters, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* A new {@link ");
        _builder.append(targetTypeName, "     ");
        _builder.append("} instance.");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @return A new {@link ");
        _builder.append(targetTypeName, "     ");
        _builder.append("} instance.");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public ");
        String _importedNonNull = this.importedNonNull((Type)this.targetType);
        _builder.append(_importedNonNull, "    ");
        _builder.append(" build() {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("return new ");
        String _importedName_1 = this.importedName((Type)this.type().getEnclosedTypes().get(0));
        _builder.append(_importedName_1, "        ");
        _builder.append("(this);");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _body = this.implTemplate.body();
        _builder.append((Object)_body, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @Override
    public CharSequence generateDeprecatedAnnotation(AnnotationType ann) {
        AnnotationType.Parameter forRemoval = ann.getParameter("forRemoval");
        if (forRemoval != null) {
            String _importedName = this.importedName(JavaFileTemplate.DEPRECATED);
            String _plus = "@" + _importedName;
            String _plus_1 = _plus + "(forRemoval = ";
            String _value = forRemoval.getValue();
            String _plus_2 = _plus_1 + _value;
            return _plus_2 + ")";
        }
        String _importedName_1 = this.importedName(JavaFileTemplate.SUPPRESS_WARNINGS);
        String _plus_3 = "@" + _importedName_1;
        return _plus_3 + "(\"deprecation\")";
    }

    private CharSequence generateConstructorsFromIfcs() {
        StringConcatenation _builder = new StringConcatenation();
        if (!(this.targetType instanceof GeneratedTransferObject)) {
            List _implements = this.targetType.getImplements();
            boolean _hasElements = false;
            for (Type impl : _implements) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                Object _generateConstructorFromIfc = this.generateConstructorFromIfc(impl);
                _builder.append(_generateConstructorFromIfc);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private Object generateConstructorFromIfc(Type impl) {
        StringConcatenation _builder = new StringConcatenation();
        if (impl instanceof GeneratedType) {
            boolean _hasNonDefaultMethods = AbstractBuilderTemplate.hasNonDefaultMethods((GeneratedType)impl);
            if (_hasNonDefaultMethods) {
                String typeName = this.importedName(impl);
                _builder.newLineIfNotEmpty();
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Construct a new builder initialized from specified {@link ");
                _builder.append(typeName, " ");
                _builder.append("}.");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param arg ");
                _builder.append(typeName, " ");
                _builder.append(" from which the builder should be initialized");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("public ");
                String _name = this.type().getName();
                _builder.append(_name);
                _builder.append("(");
                _builder.append(typeName);
                _builder.append(" arg) {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                Object _printConstructorPropertySetter = this.printConstructorPropertySetter(impl);
                _builder.append(_printConstructorPropertySetter, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
            }
            List _implements = ((GeneratedType)impl).getImplements();
            for (Type implTypeImplement : _implements) {
                Object _generateConstructorFromIfc = this.generateConstructorFromIfc(implTypeImplement);
                _builder.append(_generateConstructorFromIfc);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private Object printConstructorPropertySetter(Type implementedIfc) {
        StringConcatenation _builder = new StringConcatenation();
        if (implementedIfc instanceof GeneratedType && !(implementedIfc instanceof GeneratedTransferObject)) {
            GeneratedType ifc = (GeneratedType)implementedIfc;
            _builder.newLineIfNotEmpty();
            Iterable<MethodSignature> _nonDefaultMethods = AbstractBuilderTemplate.nonDefaultMethods(ifc);
            for (MethodSignature getter : _nonDefaultMethods) {
                boolean _isGetterMethodName = Naming.isGetterMethodName((String)getter.getName());
                if (!_isGetterMethodName) continue;
                String propertyName = JavaFileTemplate.propertyNameFromGetter(getter);
                _builder.newLineIfNotEmpty();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("arg.");
                String _name = getter.getName();
                _builder_1.append(_name);
                _builder_1.append("()");
                CharSequence _printPropertySetter = this.printPropertySetter(getter, _builder_1.toString(), propertyName);
                _builder.append((Object)_printPropertySetter);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            List _implements = ifc.getImplements();
            for (Type impl : _implements) {
                Object _printConstructorPropertySetter = this.printConstructorPropertySetter(impl, BuilderTemplate.getSpecifiedGetters(ifc));
                _builder.append(_printConstructorPropertySetter);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private Object printConstructorPropertySetter(Type implementedIfc, Set<MethodSignature> alreadySetProperties) {
        StringConcatenation _builder = new StringConcatenation();
        if (implementedIfc instanceof GeneratedType && !(implementedIfc instanceof GeneratedTransferObject)) {
            GeneratedType ifc = (GeneratedType)implementedIfc;
            _builder.newLineIfNotEmpty();
            Iterable<MethodSignature> _nonDefaultMethods = AbstractBuilderTemplate.nonDefaultMethods(ifc);
            for (MethodSignature getter : _nonDefaultMethods) {
                if (!Naming.isGetterMethodName((String)getter.getName()) || !JavaFileTemplate.getterByName(alreadySetProperties, getter.getName()).isEmpty()) continue;
                String propertyName = JavaFileTemplate.propertyNameFromGetter(getter);
                _builder.newLineIfNotEmpty();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("arg.");
                String _name = getter.getName();
                _builder_1.append(_name);
                _builder_1.append("()");
                CharSequence _printPropertySetter = this.printPropertySetter(getter, _builder_1.toString(), propertyName);
                _builder.append((Object)_printPropertySetter);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            List _implements = ifc.getImplements();
            for (Type descendant : _implements) {
                Object _printConstructorPropertySetter = this.printConstructorPropertySetter(descendant, (Set<MethodSignature>)Sets.union(alreadySetProperties, BuilderTemplate.getSpecifiedGetters(ifc)));
                _builder.append(_printConstructorPropertySetter);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static Set<MethodSignature> getSpecifiedGetters(GeneratedType type) {
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        List _methodDefinitions = type.getMethodDefinitions();
        for (MethodSignature method : _methodDefinitions) {
            boolean _hasOverrideAnnotation = JavaFileTemplate.hasOverrideAnnotation(method);
            if (!_hasOverrideAnnotation) continue;
            setBuilder.add((Object)method);
        }
        return setBuilder.build();
    }

    private CharSequence generateMethodFieldsFrom() {
        boolean _hasImplementsFromUses;
        StringConcatenation _builder = new StringConcatenation();
        if (!(this.targetType instanceof GeneratedTransferObject) && (_hasImplementsFromUses = this.hasImplementsFromUses(this.targetType))) {
            List<Type> done = this.getBaseIfcs(this.targetType);
            _builder.newLineIfNotEmpty();
            CharSequence _generateMethodFieldsFromComment = this.generateMethodFieldsFromComment(this.targetType);
            _builder.append((Object)_generateMethodFieldsFromComment);
            _builder.newLineIfNotEmpty();
            _builder.append("public void fieldsFrom(");
            String _importedName = this.importedName((Type)BindingTypes.DATA_OBJECT);
            _builder.append(_importedName);
            _builder.append(" arg) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("boolean isValidArg = false;");
            _builder.newLine();
            Set<Type> _allIfcs = this.getAllIfcs((Type)this.targetType);
            for (Type impl : _allIfcs) {
                _builder.append("    ");
                CharSequence _generateIfCheck = this.generateIfCheck(impl, done);
                _builder.append((Object)_generateIfCheck, "    ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            String _importedName_1 = this.importedName(JavaFileTemplate.CODEHELPERS);
            _builder.append(_importedName_1, "    ");
            _builder.append(".validValue(isValidArg, arg, \"");
            List<String> _listOfNames = this.toListOfNames(this.getAllIfcs((Type)this.targetType));
            _builder.append(_listOfNames, "    ");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateEmptyInstance() {
        StringConcatenation _builder = new StringConcatenation();
        String nonnullTarget = this.importedNonNull((Type)this.targetType);
        _builder.newLineIfNotEmpty();
        _builder.append("private static final class LazyEmpty {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("static final ");
        _builder.append(nonnullTarget, "    ");
        _builder.append(" INSTANCE = new ");
        String _name = this.type().getName();
        _builder.append(_name, "    ");
        _builder.append("().build();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("private LazyEmpty() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Hidden on purpose");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Get empty instance of ");
        String _name_1 = this.targetType.getName();
        _builder.append(_name_1, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return An empty {@link ");
        String _name_2 = this.targetType.getName();
        _builder.append(_name_2, " ");
        _builder.append("}");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public static ");
        _builder.append(nonnullTarget);
        _builder.append(" empty() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return LazyEmpty.INSTANCE;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateMethodFieldsFromComment(GeneratedType type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Set fields from given grouping argument. Valid argument is instance of one of following types:");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* <ul>");
        _builder.newLine();
        Set<Type> _allIfcs = this.getAllIfcs((Type)type);
        for (Type impl : _allIfcs) {
            _builder.append(" ");
            _builder.append("*   <li>{@link ");
            String _importedName = this.importedName(impl);
            _builder.append(_importedName, " ");
            _builder.append("}</li>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(" ");
        _builder.append("* </ul>");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param arg grouping object");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws ");
        String _importedName_1 = this.importedName(JavaFileTemplate.IAE);
        _builder.append(_importedName_1, " ");
        _builder.append(" if given argument is none of valid types or has property with incompatible value");
        _builder.newLineIfNotEmpty();
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public boolean hasImplementsFromUses(GeneratedType type) {
        int i = 0;
        Set<Type> _allIfcs = this.getAllIfcs((Type)type);
        for (Type impl : _allIfcs) {
            if (!(impl instanceof GeneratedType) || !AbstractBuilderTemplate.hasNonDefaultMethods((GeneratedType)impl)) continue;
            ++i;
        }
        return i > 0;
    }

    private CharSequence generateIfCheck(Type impl, List<Type> done) {
        StringConcatenation _builder = new StringConcatenation();
        if (impl instanceof GeneratedType && AbstractBuilderTemplate.hasNonDefaultMethods((GeneratedType)impl)) {
            GeneratedType implType = (GeneratedType)impl;
            _builder.newLineIfNotEmpty();
            _builder.append("if (arg instanceof ");
            String _importedName = this.importedName((Type)implType);
            _builder.append(_importedName);
            _builder.append(" castArg) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            CharSequence _printPropertySetter = this.printPropertySetter((Type)implType);
            _builder.append((Object)_printPropertySetter, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("isValidArg = true;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence printPropertySetter(Type implementedIfc) {
        StringConcatenation _builder = new StringConcatenation();
        if (implementedIfc instanceof GeneratedType && !(implementedIfc instanceof GeneratedTransferObject)) {
            GeneratedType ifc = (GeneratedType)implementedIfc;
            _builder.newLineIfNotEmpty();
            Iterable<MethodSignature> _nonDefaultMethods = AbstractBuilderTemplate.nonDefaultMethods(ifc);
            for (MethodSignature getter : _nonDefaultMethods) {
                if (!Naming.isGetterMethodName((String)getter.getName()) || JavaFileTemplate.hasOverrideAnnotation(getter)) continue;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("castArg.");
                String _name = getter.getName();
                _builder_1.append(_name);
                _builder_1.append("()");
                CharSequence _printPropertySetter = this.printPropertySetter(getter, _builder_1.toString(), JavaFileTemplate.propertyNameFromGetter(getter));
                _builder.append((Object)_printPropertySetter);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence printPropertySetter(MethodSignature getter, String retrieveProperty, String propertyName) {
        MethodSignature ownGetter = this.implTemplate.findGetter(getter.getName());
        Type ownGetterType = ownGetter.getReturnType();
        boolean _strictTypeEquals = Types.strictTypeEquals((Type)getter.getReturnType(), (Type)ownGetterType);
        if (_strictTypeEquals) {
            return "this._" + propertyName + " = " + retrieveProperty;
        }
        if (ownGetterType instanceof ParameterizedType) {
            Type itemType = ((ParameterizedType)ownGetterType).getActualTypeArguments()[0];
            boolean _isListType = Types.isListType((ParameterizedType)((ParameterizedType)ownGetterType));
            if (_isListType) {
                return this.printPropertySetter(retrieveProperty, propertyName, "checkListFieldCast", this.importedName(itemType));
            }
            boolean _isSetType = Types.isSetType((ParameterizedType)((ParameterizedType)ownGetterType));
            if (_isSetType) {
                return this.printPropertySetter(retrieveProperty, propertyName, "checkSetFieldCast", this.importedName(itemType));
            }
        }
        return this.printPropertySetter(retrieveProperty, propertyName, "checkFieldCast", this.importedName(ownGetterType));
    }

    private CharSequence printPropertySetter(String retrieveProperty, String propertyName, String checkerName, String className) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("this._");
        _builder.append(propertyName);
        _builder.append(" = ");
        String _importedName = this.importedName(JavaFileTemplate.CODEHELPERS);
        _builder.append(_importedName);
        _builder.append(".");
        _builder.append(checkerName);
        _builder.append("(");
        _builder.append(className);
        _builder.append(".class, \"");
        _builder.append(propertyName);
        _builder.append("\", ");
        _builder.append(retrieveProperty);
        _builder.append(")");
        return _builder;
    }

    private List<Type> getBaseIfcs(GeneratedType type) {
        ArrayList<Type> baseIfcs = new ArrayList<Type>();
        List _implements = type.getImplements();
        for (Type ifc : _implements) {
            if (!(ifc instanceof GeneratedType) || !AbstractBuilderTemplate.hasNonDefaultMethods((GeneratedType)ifc)) continue;
            baseIfcs.add(ifc);
        }
        return baseIfcs;
    }

    private Set<Type> getAllIfcs(Type type) {
        HashSet<Type> baseIfcs = new HashSet<Type>();
        if (type instanceof GeneratedType && !(type instanceof GeneratedTransferObject)) {
            GeneratedType ifc = (GeneratedType)type;
            List _implements = ifc.getImplements();
            for (Type impl : _implements) {
                if (impl instanceof GeneratedType && AbstractBuilderTemplate.hasNonDefaultMethods((GeneratedType)impl)) {
                    baseIfcs.add(impl);
                }
                baseIfcs.addAll(this.getAllIfcs(impl));
            }
        }
        return baseIfcs;
    }

    private List<String> toListOfNames(Collection<Type> types) {
        ArrayList<String> names = new ArrayList<String>();
        for (Type type : types) {
            names.add(this.importedName(type));
        }
        return names;
    }

    private CharSequence constantsDeclarations() {
        StringConcatenation _builder = new StringConcatenation();
        List _constantDefinitions = this.type().getConstantDefinitions();
        for (Constant c : _constantDefinitions) {
            boolean _startsWith = c.getName().startsWith("PATTERN_CONSTANTS");
            if (_startsWith) {
                boolean _equals;
                Object _value = c.getValue();
                Map cValue = (Map)_value;
                _builder.newLineIfNotEmpty();
                String fieldSuffix = c.getName().substring("PATTERN_CONSTANTS".length());
                _builder.newLineIfNotEmpty();
                String jurPatternRef = this.importedName(JavaFileTemplate.JUR_PATTERN);
                _builder.newLineIfNotEmpty();
                int _size = cValue.size();
                boolean bl = _equals = _size == 1;
                if (_equals) {
                    Map.Entry firstEntry = cValue.entrySet().iterator().next();
                    _builder.newLineIfNotEmpty();
                    _builder.append("private static final ");
                    _builder.append(jurPatternRef);
                    _builder.append(" ");
                    _builder.append("patterns");
                    _builder.append(fieldSuffix);
                    _builder.append(" = ");
                    _builder.append(jurPatternRef);
                    _builder.append(".compile(\"");
                    String _escapeJava = StringEscapeUtils.escapeJava((String)((String)firstEntry.getKey()));
                    _builder.append(_escapeJava);
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("private static final String ");
                    _builder.append("regexes");
                    _builder.append(fieldSuffix);
                    _builder.append(" = \"");
                    String _escapeJava_1 = StringEscapeUtils.escapeJava((String)((String)firstEntry.getValue()));
                    _builder.append(_escapeJava_1);
                    _builder.append("\";");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("private static final ");
                _builder.append(jurPatternRef);
                _builder.append("[] ");
                _builder.append("patterns");
                _builder.append(fieldSuffix);
                _builder.append(" = ");
                String _importedName = this.importedName(JavaFileTemplate.CODEHELPERS);
                _builder.append(_importedName);
                _builder.append(".compilePatterns(");
                String _importedName_1 = this.importedName(ImmutableList.class);
                _builder.append(_importedName_1);
                _builder.append(".of(");
                _builder.newLineIfNotEmpty();
                Set _keySet = cValue.keySet();
                boolean _hasElements = false;
                for (String v : _keySet) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append("\"");
                    String _escapeJava_2 = StringEscapeUtils.escapeJava((String)v);
                    _builder.append(_escapeJava_2);
                    _builder.append("\"");
                }
                _builder.append("));");
                _builder.newLineIfNotEmpty();
                _builder.append("private static final String[] ");
                _builder.append("regexes");
                _builder.append(fieldSuffix);
                _builder.append(" = { ");
                Collection _values = cValue.values();
                boolean _hasElements_1 = false;
                for (String v_1 : _values) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append("\"");
                    String _escapeJava_3 = StringEscapeUtils.escapeJava((String)v_1);
                    _builder.append(_escapeJava_3);
                    _builder.append("\"");
                }
                _builder.append(" };");
                _builder.newLineIfNotEmpty();
                continue;
            }
            CharSequence _emitConstant = this.emitConstant(c);
            _builder.append((Object)_emitConstant);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateSetter(BuilderGeneratedProperty field) {
        Type returnType = field.getReturnType();
        if (returnType instanceof ParameterizedType) {
            if (Types.isListType((ParameterizedType)((ParameterizedType)returnType)) || Types.isSetType((ParameterizedType)((ParameterizedType)returnType))) {
                Type[] arguments = ((ParameterizedType)returnType).getActualTypeArguments();
                boolean _isEmpty = ((List)Conversions.doWrapArray((Object)arguments)).isEmpty();
                if (_isEmpty) {
                    return this.generateListSetter(field, (Type)Types.objectType());
                }
                return this.generateListSetter(field, arguments[0]);
            }
            boolean _isMapType = Types.isMapType((ParameterizedType)((ParameterizedType)returnType));
            if (_isMapType) {
                return this.generateMapSetter(field, ((ParameterizedType)returnType).getActualTypeArguments()[1]);
            }
        }
        return this.generateSimpleSetter(field, returnType);
    }

    private CharSequence generateListSetter(BuilderGeneratedProperty field, Type actualType) {
        StringConcatenation _builder = new StringConcatenation();
        Restrictions restrictions = JavaFileTemplate.restrictionsForSetter(actualType);
        _builder.newLineIfNotEmpty();
        if (restrictions != null) {
            CharSequence _generateCheckers = this.generateCheckers(field, restrictions, actualType);
            _builder.append((Object)_generateCheckers);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Set the property corresponding to {@link ");
        String _importedName = this.importedName((Type)this.targetType);
        _builder.append(_importedName, " ");
        _builder.append("#");
        String _getterName = field.getGetterName();
        _builder.append(_getterName, " ");
        _builder.append("()} to the specified");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* value.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param values desired value");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return this builder");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append(" set");
        String _firstUpper = StringExtensions.toFirstUpper((String)field.getName());
        _builder.append(_firstUpper);
        _builder.append("(final ");
        String _importedName_1 = this.importedName(field.getReturnType());
        _builder.append(_importedName_1);
        _builder.append(" values) {");
        _builder.newLineIfNotEmpty();
        if (restrictions != null) {
            _builder.append("if (values != null) {");
            _builder.newLine();
            _builder.append("   ");
            _builder.append("for (");
            String _importedName_2 = this.importedName(actualType);
            _builder.append(_importedName_2, "   ");
            _builder.append(" value : values) {");
            _builder.newLineIfNotEmpty();
            _builder.append("       ");
            CharSequence _checkArgument = this.checkArgument(field, restrictions, actualType, "value");
            _builder.append((Object)_checkArgument, "       ");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("    ");
        _builder.append("this.");
        String _fieldName = AbstractBaseTemplate.fieldName(field);
        _builder.append(_fieldName, "    ");
        _builder.append(" = values;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateMapSetter(BuilderGeneratedProperty field, Type actualType) {
        StringConcatenation _builder = new StringConcatenation();
        Restrictions restrictions = JavaFileTemplate.restrictionsForSetter(actualType);
        _builder.newLineIfNotEmpty();
        if (restrictions != null) {
            CharSequence _generateCheckers = this.generateCheckers(field, restrictions, actualType);
            _builder.append((Object)_generateCheckers);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Set the property corresponding to {@link ");
        String _importedName = this.importedName((Type)this.targetType);
        _builder.append(_importedName, " ");
        _builder.append("#");
        String _getterName = field.getGetterName();
        _builder.append(_getterName, " ");
        _builder.append("()} to the specified");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* value.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param values desired value");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return this builder");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append(" set");
        String _firstUpper = StringExtensions.toFirstUpper((String)field.getName());
        _builder.append(_firstUpper);
        _builder.append("(final ");
        String _importedName_1 = this.importedName(field.getReturnType());
        _builder.append(_importedName_1);
        _builder.append(" values) {");
        _builder.newLineIfNotEmpty();
        if (restrictions != null) {
            _builder.append("if (values != null) {");
            _builder.newLine();
            _builder.append("   ");
            _builder.append("for (");
            String _importedName_2 = this.importedName(actualType);
            _builder.append(_importedName_2, "   ");
            _builder.append(" value : values.values()) {");
            _builder.newLineIfNotEmpty();
            _builder.append("       ");
            CharSequence _checkArgument = this.checkArgument(field, restrictions, actualType, "value");
            _builder.append((Object)_checkArgument, "       ");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("    ");
        _builder.append("this.");
        String _fieldName = AbstractBaseTemplate.fieldName(field);
        _builder.append(_fieldName, "    ");
        _builder.append(" = values;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateSimpleSetter(BuilderGeneratedProperty field, Type actualType) {
        StringConcatenation _builder = new StringConcatenation();
        Restrictions restrictions = JavaFileTemplate.restrictionsForSetter(actualType);
        _builder.newLineIfNotEmpty();
        if (restrictions != null) {
            _builder.newLine();
            CharSequence _generateCheckers = this.generateCheckers(field, restrictions, actualType);
            _builder.append((Object)_generateCheckers);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Set the property corresponding to {@link ");
        String _importedName = this.importedName((Type)this.targetType);
        _builder.append(_importedName, " ");
        _builder.append("#");
        String _getterName = field.getGetterName();
        _builder.append(_getterName, " ");
        _builder.append("()} to the specified");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* value.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param value desired value");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return this builder");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        String _firstUpper = StringExtensions.toFirstUpper((String)field.getName());
        String setterName = "set" + _firstUpper;
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append(" ");
        _builder.append(setterName);
        _builder.append("(final ");
        String _importedName_1 = this.importedName(field.getReturnType());
        _builder.append(_importedName_1);
        _builder.append(" value) {");
        _builder.newLineIfNotEmpty();
        if (restrictions != null) {
            _builder.append("    ");
            _builder.append("if (value != null) {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("    ");
            CharSequence _checkArgument = this.checkArgument(field, restrictions, actualType, "value");
            _builder.append((Object)_checkArgument, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("    ");
        _builder.append("this.");
        String _fieldName = AbstractBaseTemplate.fieldName(field);
        _builder.append(_fieldName, "    ");
        _builder.append(" = value;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateSetters() {
        StringConcatenation _builder = new StringConcatenation();
        if (this.keyType != null) {
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Set the key value corresponding to {@link ");
            String _importedName = this.importedName((Type)this.targetType);
            _builder.append(_importedName, " ");
            _builder.append("#");
            _builder.append("key", " ");
            _builder.append("()} to the specified");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* value.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param key desired value");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @return this builder");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("public ");
            String _name = this.type().getName();
            _builder.append(_name);
            _builder.append(" withKey(final ");
            String _importedName_1 = this.importedName(this.keyType);
            _builder.append(_importedName_1);
            _builder.append(" key) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("this.key = key;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        for (BuilderGeneratedProperty property : this.properties) {
            CharSequence _generateSetter = this.generateSetter(property);
            _builder.append((Object)_generateSetter);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (this.augmentType != null) {
            String augmentTypeRef = this.importedName(this.augmentType);
            _builder.newLineIfNotEmpty();
            String hashMapRef = this.importedName(JavaFileTemplate.JU_HASHMAP);
            _builder.newLineIfNotEmpty();
            _builder.append("/**");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("* Add an augmentation to this builder's product.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("*");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("* @param augmentation augmentation to be added");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("* @return this builder");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("* @throws ");
            String _importedName_2 = this.importedName(JavaFileTemplate.NPE);
            _builder.append(_importedName_2, "  ");
            _builder.append(" if {@code augmentation} is null");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("public ");
            String _name_1 = this.type().getName();
            _builder.append(_name_1);
            _builder.append(" addAugmentation(");
            _builder.append(augmentTypeRef);
            _builder.append(" augmentation) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("if (!(this.");
            _builder.append("augmentation", "    ");
            _builder.append(" instanceof ");
            _builder.append(hashMapRef, "    ");
            _builder.append(")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("this.");
            _builder.append("augmentation", "        ");
            _builder.append(" = new ");
            _builder.append(hashMapRef, "        ");
            _builder.append("<>();");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("this.");
            _builder.append("augmentation", "    ");
            _builder.append(".put(augmentation.");
            _builder.append("implementedInterface", "    ");
            _builder.append("(), augmentation);");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/**");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("* Remove an augmentation from this builder's product. If this builder does not track such an augmentation");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("* type, this method does nothing.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("*");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("* @param augmentationType augmentation type to be removed");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("* @return this builder");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("public ");
            String _name_2 = this.type().getName();
            _builder.append(_name_2);
            _builder.append(" removeAugmentation(");
            String _importedName_3 = this.importedName(JavaFileTemplate.CLASS);
            _builder.append(_importedName_3);
            _builder.append("<? extends ");
            _builder.append(augmentTypeRef);
            _builder.append("> augmentationType) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("if (this.");
            _builder.append("augmentation", "    ");
            _builder.append(" instanceof ");
            _builder.append(hashMapRef, "    ");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("this.");
            _builder.append("augmentation", "        ");
            _builder.append(".remove(augmentationType);");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    private String createDescription(GeneratedType targetType) {
        String target = this.importedName((Type)targetType);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Class that builds {@link ");
        _builder.append(target);
        _builder.append("} instances. Overall design of the class is that of a");
        _builder.newLineIfNotEmpty();
        _builder.append("<a href=\"https://en.wikipedia.org/wiki/Fluent_interface\">fluent interface</a>, where method chaining is used.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("<p>");
        _builder.newLine();
        _builder.append("In general, this class is supposed to be used like this template:");
        _builder.newLine();
        _builder.append("<pre>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<code>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append(target, "    ");
        _builder.append(" create");
        _builder.append(target, "    ");
        _builder.append("(int fooXyzzy, int barBaz) {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("return new ");
        _builder.append(target, "        ");
        _builder.append("Builder()");
        _builder.newLineIfNotEmpty();
        _builder.append("            ");
        _builder.append(".setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())");
        _builder.newLine();
        _builder.append("            ");
        _builder.append(".setBar(new BarBuilder().setBaz(barBaz).build())");
        _builder.newLine();
        _builder.append("            ");
        _builder.append(".build();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("</code>");
        _builder.newLine();
        _builder.append("</pre>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("<p>");
        _builder.newLine();
        _builder.append("This pattern is supported by the immutable nature of ");
        _builder.append(target);
        _builder.append(", as instances can be freely passed around without");
        _builder.newLineIfNotEmpty();
        _builder.append("worrying about synchronization issues.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("<p>");
        _builder.newLine();
        _builder.append("As a side note: method chaining results in:");
        _builder.newLine();
        _builder.append("<ul>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("on the stack, so further method invocations just need to fill method arguments for the next method");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("invocation, which is terminated by {@link #build()}, which is then returned from the method</li>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("very localized</li>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("method) stack, making <a href=\"https://en.wikipedia.org/wiki/Escape_analysis\">escape analysis</a> a lot");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("eliminated</li>");
        _builder.newLine();
        _builder.append("</ul>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@see ");
        _builder.append(target);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    @Override
    protected String formatDataForJavaDoc(GeneratedType type) {
        boolean _not;
        String typeDescription = this.createDescription(type);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)typeDescription);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(typeDescription);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    private CharSequence generateAugmentation() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Return the specified augmentation, if it is present in this builder.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param <E$$> augmentation type");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param augmentationType augmentation type class");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return Augmentation object from this builder, or {@code null} if not present");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws ");
        String _importedName = this.importedName(JavaFileTemplate.NPE);
        _builder.append(_importedName, " ");
        _builder.append(" if {@code augmentType} is {@code null}");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@");
        String _importedName_1 = this.importedName(JavaFileTemplate.SUPPRESS_WARNINGS);
        _builder.append(_importedName_1);
        _builder.append("({ \"unchecked\", \"checkstyle:methodTypeParameterName\"})");
        _builder.newLineIfNotEmpty();
        _builder.append("public <E$$ extends ");
        String _importedName_2 = this.importedName(this.augmentType);
        _builder.append(_importedName_2);
        _builder.append("> E$$ ");
        _builder.append("augmentation");
        _builder.append("(");
        String _importedName_3 = this.importedName(JavaFileTemplate.CLASS);
        _builder.append(_importedName_3);
        _builder.append("<E$$> augmentationType) {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return (E$$) ");
        _builder.append("augmentation", "    ");
        _builder.append(".get(");
        String _importedName_4 = this.importedName(JavaFileTemplate.JU_OBJECTS);
        _builder.append(_importedName_4, "    ");
        _builder.append(".requireNonNull(augmentationType));");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @Override
    protected CharSequence generateCopyKeys(List<GeneratedProperty> keyProps) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("this.key = base.");
        _builder.append("key");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        for (GeneratedProperty field : keyProps) {
            _builder.append("this.");
            String _fieldName = AbstractBaseTemplate.fieldName(field);
            _builder.append(_fieldName);
            _builder.append(" = base.");
            String _terMethodName = AbstractBaseTemplate.getterMethodName(field);
            _builder.append(_terMethodName);
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Override
    protected CharSequence generateCopyNonKeys(Collection<BuilderGeneratedProperty> props) {
        StringConcatenation _builder = new StringConcatenation();
        for (BuilderGeneratedProperty field : props) {
            _builder.append("this.");
            String _fieldName = AbstractBaseTemplate.fieldName(field);
            _builder.append(_fieldName);
            _builder.append(" = base.");
            String _getterName = field.getGetterName();
            _builder.append(_getterName);
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Override
    protected CharSequence generateCopyAugmentation(Type implType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("final var aug = base.augmentations();");
        _builder.newLine();
        _builder.append("if (!aug.isEmpty()) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("this.");
        _builder.append("augmentation", "    ");
        _builder.append(" = new ");
        String _importedName = this.importedName(JavaFileTemplate.JU_HASHMAP);
        _builder.append(_importedName, "    ");
        _builder.append("<>(aug);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

