/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.ConstructorParameters;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractBaseTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractJavaGeneratedType;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractRangeGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.BaseTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.EnumTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.GeneratorUtil;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.LengthGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.NestedJavaGeneratedType;
import org.opendaylight.mdsal.binding.java.api.generator.TopLevelJavaGeneratedType;
import org.opendaylight.mdsal.binding.java.api.generator.TypeUtils;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.BaseYangTypes;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.binding.contract.Naming;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;

public class ClassTemplate
extends BaseTemplate {
    private static final Comparator<GeneratedProperty> PROP_COMPARATOR = Comparator.comparing(prop -> prop.getName());
    private static final Set<Type> VALUEOF_TYPES = Set.of(BaseYangTypes.BOOLEAN_TYPE, BaseYangTypes.DECIMAL64_TYPE, BaseYangTypes.INT8_TYPE, BaseYangTypes.INT16_TYPE, BaseYangTypes.INT32_TYPE, BaseYangTypes.INT64_TYPE, BaseYangTypes.UINT8_TYPE, BaseYangTypes.UINT16_TYPE, BaseYangTypes.UINT32_TYPE, BaseYangTypes.UINT64_TYPE);
    private static final JavaTypeName BOOLEAN = JavaTypeName.create(Boolean.class);
    private static final JavaTypeName IMMUTABLE_SET = JavaTypeName.create(ImmutableSet.class);
    protected final List<GeneratedProperty> properties;
    protected final List<GeneratedProperty> finalProperties;
    protected final List<GeneratedProperty> parentProperties;
    protected final List<GeneratedProperty> allProperties;
    protected final Restrictions restrictions;
    protected final List<Enumeration> enums;
    protected final List<Constant> consts;
    protected final GeneratedTransferObject genTO;
    private final AbstractRangeGenerator<?> rangeGenerator;

    public ClassTemplate(GeneratedTransferObject genType) {
        this((AbstractJavaGeneratedType)new TopLevelJavaGeneratedType((GeneratedType)genType), genType);
    }

    public ClassTemplate(AbstractJavaGeneratedType javaType, GeneratedTransferObject genType) {
        super(javaType, (GeneratedType)genType);
        this.genTO = genType;
        this.properties = genType.getProperties();
        this.finalProperties = GeneratorUtil.resolveReadOnlyPropertiesFromTO(this.genTO.getProperties());
        this.parentProperties = GeneratorUtil.getPropertiesOfAllParents(this.genTO);
        this.restrictions = genType.getRestrictions();
        ArrayList<GeneratedProperty> sorted = new ArrayList<GeneratedProperty>();
        sorted.addAll(this.properties);
        sorted.addAll(this.parentProperties);
        sorted.sort(PROP_COMPARATOR);
        this.allProperties = sorted;
        this.enums = genType.getEnumerations();
        this.consts = genType.getConstantDefinitions();
        this.rangeGenerator = this.restrictions != null && this.restrictions.getRangeConstraint().isPresent() ? Objects.requireNonNull(AbstractRangeGenerator.forType(TypeUtils.encapsulatedValueType(genType))) : null;
    }

    public CharSequence generateAsInnerClass() {
        return this.generateBody(true);
    }

    @Override
    protected CharSequence body() {
        return this.generateBody(false);
    }

    protected CharSequence generateBody(boolean isInnerClass) {
        StringConcatenation _builder = new StringConcatenation();
        String _wrapToDocumentation = BaseTemplate.wrapToDocumentation(this.formatDataForJavaDoc(this.type()));
        _builder.append(_wrapToDocumentation);
        _builder.newLineIfNotEmpty();
        CharSequence _annotationDeclaration = this.annotationDeclaration();
        _builder.append((Object)_annotationDeclaration);
        _builder.newLineIfNotEmpty();
        if (!isInnerClass) {
            String _generatedAnnotation = this.generatedAnnotation();
            _builder.append(_generatedAnnotation);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _generateClassDeclaration = this.generateClassDeclaration(isInnerClass);
        _builder.append((Object)_generateClassDeclaration);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _suidDeclaration = this.suidDeclaration();
        _builder.append((Object)_suidDeclaration, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _innerClassesDeclarations = this.innerClassesDeclarations();
        _builder.append((Object)_innerClassesDeclarations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _enumDeclarations = this.enumDeclarations();
        _builder.append((Object)_enumDeclarations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _constantsDeclarations = this.constantsDeclarations();
        _builder.append((Object)_constantsDeclarations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _generateFields = this.generateFields();
        _builder.append((Object)_generateFields, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (this.restrictions != null) {
            boolean _isPresent_1;
            boolean _isPresent = this.restrictions.getLengthConstraint().isPresent();
            if (_isPresent) {
                _builder.append("    ");
                String _generateLengthChecker = LengthGenerator.generateLengthChecker("_value", TypeUtils.encapsulatedValueType(this.genTO), (LengthConstraint)this.restrictions.getLengthConstraint().orElseThrow(), this);
                _builder.append(_generateLengthChecker, "    ");
                _builder.newLineIfNotEmpty();
            }
            if (_isPresent_1 = this.restrictions.getRangeConstraint().isPresent()) {
                _builder.append("    ");
                String _generateRangeChecker = this.rangeGenerator.generateRangeChecker("_value", (RangeConstraint)this.restrictions.getRangeConstraint().orElseThrow(), this);
                _builder.append(_generateRangeChecker, "    ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("    ");
        CharSequence _constructors = this.constructors();
        _builder.append((Object)_constructors, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _defaultInstance = this.defaultInstance();
        _builder.append((Object)_defaultInstance, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _propertyMethods = this.propertyMethods();
        _builder.append((Object)_propertyMethods, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isBitsTypeObject = this.isBitsTypeObject();
        if (_isBitsTypeObject) {
            _builder.append("    ");
            CharSequence _validNamesAndValues = this.validNamesAndValues();
            _builder.append((Object)_validNamesAndValues, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("    ");
        String _generateHashCode = this.generateHashCode();
        _builder.append(_generateHashCode, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateEquals = this.generateEquals();
        _builder.append((Object)_generateEquals, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateToString = this.generateToString(this.genTO.getToStringIdentifiers());
        _builder.append((Object)_generateToString, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence propertyMethods() {
        CharSequence _xblockexpression = null;
        boolean _isEmpty = this.properties.isEmpty();
        if (_isEmpty) {
            return "";
        }
        CharSequence _xifexpression = null;
        boolean _isScalarTypeObject = this.isScalarTypeObject();
        _xifexpression = _isScalarTypeObject ? this.scalarTypeObjectValue(this.properties.get(0)) : this.defaultProperties();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean isScalarTypeObject() {
        List _implements = this.genTO.getImplements();
        for (Type impl : _implements) {
            boolean _equals = ((JavaTypeName)BindingTypes.SCALAR_TYPE_OBJECT.getIdentifier()).equals(impl.getIdentifier());
            if (!_equals) continue;
            return true;
        }
        return false;
    }

    private boolean isBitsTypeObject() {
        for (GeneratedTransferObject wlk = this.genTO; wlk != null; wlk = wlk.getSuperType()) {
            List _implements = wlk.getImplements();
            for (Type impl : _implements) {
                boolean _equals = ((JavaTypeName)BindingTypes.BITS_TYPE_OBJECT.getIdentifier()).equals(impl.getIdentifier());
                if (!_equals) continue;
                return true;
            }
        }
        return false;
    }

    private CharSequence defaultProperties() {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (GeneratedProperty field : this.properties) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            CharSequence _terMethod = this.getterMethod(field);
            _builder.append((Object)_terMethod);
            _builder.newLineIfNotEmpty();
            boolean _isReadOnly = field.isReadOnly();
            boolean _not = !_isReadOnly;
            if (!_not) continue;
            CharSequence _setterMethod = this.setterMethod(field);
            _builder.append((Object)_setterMethod);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence scalarTypeObjectValue(GeneratedProperty field) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@");
        String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _importedName_1 = this.importedName(field.getReturnType());
        _builder.append(_importedName_1);
        _builder.append(" ");
        _builder.append("getValue");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        String _fieldName = AbstractBaseTemplate.fieldName(field);
        _builder.append(_fieldName, "    ");
        String _cloneCall = JavaFileTemplate.cloneCall(field);
        _builder.append(_cloneCall, "    ");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence validNamesAndValues() {
        for (Constant c : this.consts) {
            boolean _equals = "VALID_NAMES".equals(c.getName());
            if (!_equals) continue;
            Object _value = c.getValue();
            return this.validNamesAndValues((BitsTypeDefinition)_value);
        }
        return "";
    }

    private CharSequence validNamesAndValues(BitsTypeDefinition typedef) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("@");
        String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _importedName_1 = this.importedName(IMMUTABLE_SET);
        _builder.append(_importedName_1);
        _builder.append("<");
        String _importedName_2 = this.importedName((Type)Types.STRING);
        _builder.append(_importedName_2);
        _builder.append("> validNames() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        _builder.append("VALID_NAMES", "    ");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@");
        String _importedName_3 = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName_3);
        _builder.newLineIfNotEmpty();
        _builder.append("public boolean[] values() {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return new boolean[] {");
        _builder.newLine();
        Collection _bits = typedef.getBits();
        boolean _hasElements = false;
        for (BitsTypeDefinition.Bit bit : _bits) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "            ");
            }
            _builder.append("            ");
            String _terMethodName = AbstractBaseTemplate.getterMethodName(Naming.getPropertyName((String)bit.getName()));
            _builder.append(_terMethodName, "            ");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("        ");
        _builder.append("};");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence innerClassesDeclarations() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.type().getEnclosedTypes().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            List _enclosedTypes = this.type().getEnclosedTypes();
            boolean _hasElements = false;
            for (GeneratedType innerClass : _enclosedTypes) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                CharSequence _generateInnerClass = this.generateInnerClass(innerClass);
                _builder.append((Object)_generateInnerClass);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence constructors() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isUnionType = this.genTO.isUnionType();
        if (_isUnionType) {
            CharSequence _genUnionConstructor = this.genUnionConstructor();
            _builder.append((Object)_genUnionConstructor);
            _builder.newLineIfNotEmpty();
        } else if (this.genTO.isTypedef() && this.allProperties.size() == 1 && this.allProperties.get(0).getName().equals("value")) {
            CharSequence _typedefConstructor = this.typedefConstructor();
            _builder.append((Object)_typedefConstructor);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _allValuesConstructor = this.allValuesConstructor();
            _builder.append((Object)_allValuesConstructor);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isEmpty = this.allProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _copyConstructor = this.copyConstructor();
            _builder.append((Object)_copyConstructor);
            _builder.newLineIfNotEmpty();
        }
        if (this.properties.isEmpty() && !this.parentProperties.isEmpty()) {
            CharSequence _parentConstructor = this.parentConstructor();
            _builder.append((Object)_parentConstructor);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence allValuesConstructor() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _asArgumentsDeclaration = this.asArgumentsDeclaration(this.allProperties);
        _builder.append((Object)_asArgumentsDeclaration);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this.parentProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.append("super(");
            CharSequence _asArguments = this.asArguments(this.parentProperties);
            _builder.append((Object)_asArguments, "    ");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        for (GeneratedProperty p : this.allProperties) {
            _builder.append("    ");
            CharSequence _generateRestrictions = this.generateRestrictions((Type)this.type(), AbstractBaseTemplate.fieldName(p), p.getReturnType());
            _builder.append((Object)_generateRestrictions, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        for (GeneratedProperty p_1 : this.properties) {
            _builder.append("    ");
            String fieldName = AbstractBaseTemplate.fieldName(p_1);
            _builder.newLineIfNotEmpty();
            boolean _endsWith = p_1.getReturnType().getName().endsWith("[]");
            if (_endsWith) {
                _builder.append("    ");
                _builder.append("this.");
                _builder.append(fieldName, "    ");
                _builder.append(" = ");
                _builder.append(fieldName, "    ");
                _builder.append(" == null ? null : ");
                _builder.append(fieldName, "    ");
                _builder.append(".clone();");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("    ");
            _builder.append("this.");
            _builder.append(fieldName, "    ");
            _builder.append(" = ");
            _builder.append(fieldName, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence typedefConstructor() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@");
        String _importedName = this.importedName(ConstructorParameters.class);
        _builder.append(_importedName);
        _builder.append("(\"");
        _builder.append("value");
        _builder.append("\")");
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _asArgumentsDeclaration = this.asArgumentsDeclaration(this.allProperties);
        _builder.append((Object)_asArgumentsDeclaration);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this.parentProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.append("super(");
            CharSequence _asArguments = this.asArguments(this.parentProperties);
            _builder.append((Object)_asArguments, "    ");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        for (GeneratedProperty p : this.allProperties) {
            _builder.append("    ");
            CharSequence _generateRestrictions = this.generateRestrictions((Type)this.type(), AbstractBaseTemplate.fieldName(p), p.getReturnType());
            _builder.append((Object)_generateRestrictions, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        String _importedName_1 = this.importedName(JavaFileTemplate.CODEHELPERS);
        _builder.append(_importedName_1, "    ");
        _builder.append(".requireValue(_value);");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _genPatternEnforcer = this.genPatternEnforcer("_value");
        _builder.append((Object)_genPatternEnforcer, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (GeneratedProperty p_1 : this.properties) {
            _builder.append("    ");
            String fieldName = AbstractBaseTemplate.fieldName(p_1);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("this.");
            _builder.append(fieldName, "    ");
            _builder.append(" = ");
            _builder.append(fieldName, "    ");
            String _cloneCall = JavaFileTemplate.cloneCall(p_1);
            _builder.append(_cloneCall, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence genUnionConstructor() {
        StringConcatenation _builder = new StringConcatenation();
        for (GeneratedProperty p : this.allProperties) {
            ArrayList<GeneratedProperty> other = new ArrayList<GeneratedProperty>(this.properties);
            _builder.newLineIfNotEmpty();
            boolean _remove = other.remove(p);
            if (!_remove) continue;
            CharSequence _genConstructor = this.genConstructor(p, other);
            _builder.append((Object)_genConstructor);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence genConstructor(GeneratedProperty property, Iterable<GeneratedProperty> other) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append("(");
        String _importedName = this.importedName(property.getReturnType());
        String _plus = _importedName + " ";
        String _name_1 = property.getName();
        String _plus_1 = _plus + _name_1;
        _builder.append(_plus_1);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this.parentProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.append("super(");
            CharSequence _asArguments = this.asArguments(this.parentProperties);
            _builder.append((Object)_asArguments, "    ");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("    ");
        String fieldName = AbstractBaseTemplate.fieldName(property);
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _generateRestrictions = this.generateRestrictions((Type)this.type(), fieldName, property.getReturnType());
        _builder.append((Object)_generateRestrictions, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("this.");
        _builder.append(fieldName, "    ");
        _builder.append(" = ");
        String _name_2 = property.getName();
        _builder.append(_name_2, "    ");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        for (GeneratedProperty p : other) {
            _builder.append("    ");
            _builder.append("this.");
            String _fieldName = AbstractBaseTemplate.fieldName(p);
            _builder.append(_fieldName, "    ");
            _builder.append(" = null;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence genPatternEnforcer(String ref) {
        StringConcatenation _builder = new StringConcatenation();
        for (Constant c : this.consts) {
            boolean _equals = "PATTERN_CONSTANTS".equals(c.getName());
            if (!_equals) continue;
            String _importedName = this.importedName(JavaFileTemplate.CODEHELPERS);
            _builder.append(_importedName);
            _builder.append(".checkPattern(");
            _builder.append(ref);
            _builder.append(", ");
            _builder.append("patterns");
            _builder.append(", ");
            _builder.append("regexes");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private static String paramValue(Type returnType, String paramName) {
        if (returnType instanceof ConcreteType) {
            return paramName;
        }
        return paramName + ".getValue()";
    }

    public CharSequence generateRestrictions(Type type, String paramName, Type returnType) {
        StringConcatenation _builder = new StringConcatenation();
        Restrictions restrictions = JavaFileTemplate.getRestrictions(type);
        _builder.newLineIfNotEmpty();
        if (restrictions != null && (restrictions.getLengthConstraint().isPresent() || restrictions.getRangeConstraint().isPresent())) {
            boolean _isPresent_1;
            _builder.append("if (");
            _builder.append(paramName);
            _builder.append(" != null) {");
            _builder.newLineIfNotEmpty();
            boolean _isPresent = restrictions.getLengthConstraint().isPresent();
            if (_isPresent) {
                _builder.append("    ");
                String _generateLengthCheckerCall = LengthGenerator.generateLengthCheckerCall(paramName, ClassTemplate.paramValue(returnType, paramName));
                _builder.append(_generateLengthCheckerCall, "    ");
                _builder.newLineIfNotEmpty();
            }
            if (_isPresent_1 = restrictions.getRangeConstraint().isPresent()) {
                _builder.append("    ");
                String _generateRangeCheckerCall = this.rangeGenerator.generateRangeCheckerCall(paramName, ClassTemplate.paramValue(returnType, paramName));
                _builder.append(_generateRangeCheckerCall, "    ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence copyConstructor() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Creates a copy from Source Object.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param source Source object");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append("(");
        String _name_1 = this.type().getName();
        _builder.append(_name_1);
        _builder.append(" source) {");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this.parentProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.append("super(source);");
            _builder.newLine();
        }
        for (GeneratedProperty p : this.properties) {
            _builder.append("    ");
            String fieldName = AbstractBaseTemplate.fieldName(p);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("this.");
            _builder.append(fieldName, "    ");
            _builder.append(" = source.");
            _builder.append(fieldName, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence parentConstructor() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Creates a new instance from ");
        String _importedName = this.importedName((Type)this.genTO.getSuperType());
        _builder.append(_importedName, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param source Source object");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append("(");
        String _importedName_1 = this.importedName((Type)this.genTO.getSuperType());
        _builder.append(_importedName_1);
        _builder.append(" source) {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("super(source);");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _genPatternEnforcer = this.genPatternEnforcer("getValue()");
        _builder.append((Object)_genPatternEnforcer, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence defaultInstance() {
        StringConcatenation _builder = new StringConcatenation();
        if (this.genTO.isTypedef() && !this.allProperties.isEmpty() && !this.genTO.isUnionType()) {
            boolean _not;
            GeneratedProperty prop = this.allProperties.get(0);
            _builder.newLineIfNotEmpty();
            Type propType = prop.getReturnType();
            _builder.newLineIfNotEmpty();
            boolean _equals = ((JavaTypeName)BaseYangTypes.INSTANCE_IDENTIFIER.getIdentifier()).equals(propType.getIdentifier());
            boolean bl = _not = !_equals;
            if (_not) {
                _builder.append("public static ");
                String _name = this.genTO.getName();
                _builder.append(_name);
                _builder.append(" getDefaultInstance(final String defaultValue) {");
                _builder.newLineIfNotEmpty();
                boolean _equals_1 = propType.equals(Types.primitiveBooleanType());
                if (_equals_1) {
                    _builder.append("    ");
                    CharSequence _bitsArgs = this.bitsArgs();
                    _builder.append((Object)_bitsArgs, "    ");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _contains = VALUEOF_TYPES.contains(propType);
                    if (_contains) {
                        _builder.append("    ");
                        _builder.append("return new ");
                        String _name_1 = this.genTO.getName();
                        _builder.append(_name_1, "    ");
                        _builder.append("(");
                        String _importedName = this.importedName(propType);
                        _builder.append(_importedName, "    ");
                        _builder.append(".valueOf(defaultValue));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _equals_2 = BaseYangTypes.STRING_TYPE.equals(propType);
                        if (_equals_2) {
                            _builder.append("    ");
                            _builder.append("return new ");
                            String _name_2 = this.genTO.getName();
                            _builder.append(_name_2, "    ");
                            _builder.append("(defaultValue);");
                            _builder.newLineIfNotEmpty();
                        } else {
                            boolean _equals_3 = BaseYangTypes.BINARY_TYPE.equals(propType);
                            if (_equals_3) {
                                _builder.append("    ");
                                _builder.append("return new ");
                                String _name_3 = this.genTO.getName();
                                _builder.append(_name_3, "    ");
                                _builder.append("(");
                                String _importedName_1 = this.importedName(Base64.class);
                                _builder.append(_importedName_1, "    ");
                                _builder.append(".getDecoder().decode(defaultValue));");
                                _builder.newLineIfNotEmpty();
                            } else {
                                boolean _equals_4 = BaseYangTypes.EMPTY_TYPE.equals(propType);
                                if (_equals_4) {
                                    _builder.append("    ");
                                    String _importedName_2 = this.importedName(Preconditions.class);
                                    _builder.append(_importedName_2, "    ");
                                    _builder.append(".checkArgument(defaultValue.isEmpty(), \"Invalid value %s\", defaultValue);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("    ");
                                    _builder.append("return new ");
                                    String _name_4 = this.genTO.getName();
                                    _builder.append(_name_4, "    ");
                                    _builder.append("(");
                                    String _importedName_3 = this.importedName(Empty.class);
                                    _builder.append(_importedName_3, "    ");
                                    _builder.append(".value());");
                                    _builder.newLineIfNotEmpty();
                                } else {
                                    _builder.append("    ");
                                    _builder.append("return new ");
                                    String _name_5 = this.genTO.getName();
                                    _builder.append(_name_5, "    ");
                                    _builder.append("(new ");
                                    String _importedName_4 = this.importedName(propType);
                                    _builder.append(_importedName_4, "    ");
                                    _builder.append("(defaultValue));");
                                    _builder.newLineIfNotEmpty();
                                }
                            }
                        }
                    }
                }
                _builder.append("}");
                _builder.newLine();
            }
        }
        return _builder;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="FOR with SEPARATOR, not needing for value")
    protected CharSequence bitsArgs() {
        StringConcatenation _builder = new StringConcatenation();
        String _importedName = this.importedName(JavaFileTemplate.JU_LIST);
        _builder.append(_importedName);
        _builder.append("<");
        String _importedName_1 = this.importedName((Type)Types.STRING);
        _builder.append(_importedName_1);
        _builder.append("> properties = ");
        String _importedName_2 = this.importedName(Lists.class);
        _builder.append(_importedName_2);
        _builder.append(".newArrayList(");
        CharSequence _propsAsArgs = this.propsAsArgs(this.allProperties);
        _builder.append((Object)_propsAsArgs);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("if (!properties.contains(defaultValue)) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("throw new ");
        String _importedName_3 = this.importedName(JavaFileTemplate.IAE);
        _builder.append(_importedName_3, "    ");
        _builder.append("(\"invalid default parameter\");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("int i = 0;");
        _builder.newLine();
        _builder.append("return new ");
        String _name = this.genTO.getName();
        _builder.append(_name);
        _builder.append("(");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (GeneratedProperty prop : this.allProperties) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            _builder.append("properties.get(i++).equals(defaultValue) ? true : false");
            _builder.newLine();
        }
        _builder.append(");");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence propsAsArgs(Iterable<GeneratedProperty> properties) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (GeneratedProperty prop : properties) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            _builder.append("\"");
            String _name = prop.getName();
            _builder.append(_name);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateClassDeclaration(boolean isInnerClass) {
        boolean _not;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public");
        if (isInnerClass) {
            _builder.append(" static final ");
        } else {
            boolean _isAbstract = this.type().isAbstract();
            if (_isAbstract) {
                _builder.append(" abstract ");
            } else {
                _builder.append(" ");
            }
        }
        _builder.append("class ");
        String _name = this.type().getName();
        _builder.append(_name);
        GeneratedTransferObject _superType = this.genTO.getSuperType();
        boolean bl = _tripleNotEquals = _superType != null;
        if (_tripleNotEquals) {
            _builder.append(" extends ");
            String _importedName = this.importedName((Type)this.genTO.getSuperType());
            _builder.append(_importedName);
        }
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this.type().getImplements().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append(" implements ");
            List _implements = this.type().getImplements();
            boolean _hasElements = false;
            for (Type type : _implements) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _importedName_1 = this.importedName(type);
                _builder.append(_importedName_1);
            }
        }
        return _builder;
    }

    protected CharSequence enumDeclarations() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.enums.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (Enumeration e : this.enums) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                NestedJavaGeneratedType _enclosedType = this.javaType().getEnclosedType((JavaTypeName)e.getIdentifier());
                CharSequence _generateAsInnerClass = new EnumTemplate((AbstractJavaGeneratedType)_enclosedType, e).generateAsInnerClass();
                _builder.append((Object)_generateAsInnerClass);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence suidDeclaration() {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        GeneratedProperty _sUID = this.genTO.getSUID();
        boolean bl = _tripleNotEquals = _sUID != null;
        if (_tripleNotEquals) {
            _builder.append("@java.io.Serial");
            _builder.newLine();
            _builder.append("private static final long serialVersionUID = ");
            String _value = this.genTO.getSUID().getValue();
            _builder.append(_value);
            _builder.append("L;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence annotationDeclaration() {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        List _annotations = this.genTO.getAnnotations();
        boolean bl = _tripleNotEquals = _annotations != null;
        if (_tripleNotEquals) {
            List _annotations_1 = this.genTO.getAnnotations();
            for (AnnotationType e : _annotations_1) {
                _builder.append("@");
                String _name = e.getName();
                _builder.append(_name);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence constantsDeclarations() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.consts.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            for (Constant c : this.consts) {
                boolean _equals = "PATTERN_CONSTANTS".equals(c.getName());
                if (_equals) {
                    boolean _equals_1;
                    Object _value = c.getValue();
                    Map cValue = (Map)_value;
                    _builder.newLineIfNotEmpty();
                    String jurPatternRef = this.importedName(JavaFileTemplate.JUR_PATTERN);
                    _builder.newLineIfNotEmpty();
                    _builder.append("public static final ");
                    String _importedName = this.importedName(JavaFileTemplate.JU_LIST);
                    _builder.append(_importedName);
                    _builder.append("<String> ");
                    _builder.append("PATTERN_CONSTANTS");
                    _builder.append(" = ");
                    String _importedName_1 = this.importedName(ImmutableList.class);
                    _builder.append(_importedName_1);
                    _builder.append(".of(");
                    Set _keySet = cValue.keySet();
                    boolean _hasElements = false;
                    for (String v : _keySet) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        _builder.append("\"");
                        String _escapeJava = StringEscapeUtils.escapeJava((String)v);
                        _builder.append(_escapeJava);
                        _builder.append("\"");
                    }
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    int _size = cValue.size();
                    boolean bl2 = _equals_1 = _size == 1;
                    if (_equals_1) {
                        _builder.append("private static final ");
                        _builder.append(jurPatternRef);
                        _builder.append(" ");
                        _builder.append("patterns");
                        _builder.append(" = ");
                        _builder.append(jurPatternRef);
                        _builder.append(".compile(");
                        _builder.append("PATTERN_CONSTANTS");
                        _builder.append(".get(0));");
                        _builder.newLineIfNotEmpty();
                        _builder.append("private static final String ");
                        _builder.append("regexes");
                        _builder.append(" = \"");
                        String _escapeJava_1 = StringEscapeUtils.escapeJava((String)((String)cValue.values().iterator().next()));
                        _builder.append(_escapeJava_1);
                        _builder.append("\";");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("private static final ");
                    _builder.append(jurPatternRef);
                    _builder.append("[] ");
                    _builder.append("patterns");
                    _builder.append(" = ");
                    String _importedName_2 = this.importedName(JavaFileTemplate.CODEHELPERS);
                    _builder.append(_importedName_2);
                    _builder.append(".compilePatterns(");
                    _builder.append("PATTERN_CONSTANTS");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("private static final String[] ");
                    _builder.append("regexes");
                    _builder.append(" = { ");
                    Collection _values = cValue.values();
                    boolean _hasElements_1 = false;
                    for (String v_1 : _values) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        _builder.append("\"");
                        String _escapeJava_2 = StringEscapeUtils.escapeJava((String)v_1);
                        _builder.append(_escapeJava_2);
                        _builder.append("\"");
                    }
                    _builder.append(" };");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                boolean _equals_2 = "VALID_NAMES".equals(c.getName());
                if (_equals_2) {
                    Object _value_1 = c.getValue();
                    BitsTypeDefinition cValue_1 = (BitsTypeDefinition)_value_1;
                    _builder.newLineIfNotEmpty();
                    String immutableSet = this.importedName(IMMUTABLE_SET);
                    _builder.newLineIfNotEmpty();
                    _builder.append("protected static final ");
                    _builder.append(immutableSet);
                    _builder.append("<");
                    String _importedName_3 = this.importedName((Type)Types.STRING);
                    _builder.append(_importedName_3);
                    _builder.append("> ");
                    _builder.append("VALID_NAMES");
                    _builder.append(" = ");
                    _builder.append(immutableSet);
                    _builder.append(".of(");
                    Collection _bits = cValue_1.getBits();
                    boolean _hasElements_2 = false;
                    for (BitsTypeDefinition.Bit bit : _bits) {
                        if (!_hasElements_2) {
                            _hasElements_2 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        _builder.append("\"");
                        String _name = bit.getName();
                        _builder.append(_name);
                        _builder.append("\"");
                    }
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                CharSequence _emitConstant = this.emitConstant(c);
                _builder.append((Object)_emitConstant);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence generateFields() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.properties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            for (GeneratedProperty f : this.properties) {
                _builder.append("private");
                boolean _isReadOnly = this.isReadOnly(f);
                if (_isReadOnly) {
                    _builder.append(" final");
                }
                _builder.append(" ");
                String _importedName = this.importedName(f.getReturnType());
                _builder.append(_importedName);
                _builder.append(" ");
                String _fieldName = AbstractBaseTemplate.fieldName(f);
                _builder.append(_fieldName);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected boolean isReadOnly(GeneratedProperty field) {
        return field.isReadOnly();
    }

    protected String generateHashCode() {
        List props = this.genTO.getHashCodeIdentifiers();
        int size = props.size();
        if (size == 0) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@");
        String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName);
        _builder.newLineIfNotEmpty();
        _builder.append("public int hashCode() {");
        _builder.newLine();
        if (size != 1) {
            _builder.append("    ");
            _builder.append("final int prime = 31;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("int result = 1;");
            _builder.newLine();
            for (GeneratedProperty property : props) {
                _builder.append("    ");
                _builder.append("result = prime * result + ");
                String _importedHashCodeUtilClass = this.importedHashCodeUtilClass(property);
                _builder.append(_importedHashCodeUtilClass, "    ");
                _builder.append(".hashCode(");
                String _fieldName = AbstractBaseTemplate.fieldName(property);
                _builder.append(_fieldName, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.append("return result;");
            _builder.newLine();
        } else {
            _builder.append("    ");
            GeneratedProperty prop = (GeneratedProperty)props.get(0);
            _builder.newLineIfNotEmpty();
            boolean _equals = prop.getReturnType().equals(Types.primitiveBooleanType());
            if (_equals) {
                _builder.append("    ");
                _builder.append("return ");
                String _importedName_1 = this.importedName(BOOLEAN);
                _builder.append(_importedName_1, "    ");
                _builder.append(".hashCode(");
                String _fieldName_1 = AbstractBaseTemplate.fieldName(prop);
                _builder.append(_fieldName_1, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("    ");
                _builder.append("return ");
                String _importedName_2 = this.importedName(JavaFileTemplate.CODEHELPERS);
                _builder.append(_importedName_2, "    ");
                _builder.append(".wrapperHashCode(");
                String _fieldName_2 = AbstractBaseTemplate.fieldName(prop);
                _builder.append(_fieldName_2, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private String importedHashCodeUtilClass(GeneratedProperty prop) {
        Type propType = prop.getReturnType();
        boolean _equals = propType.equals(Types.primitiveBooleanType());
        if (_equals) {
            return this.importedName(BOOLEAN);
        }
        return this.importedUtilClass(propType);
    }

    private CharSequence generateEquals() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.genTO.getEqualsIdentifiers().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("@");
            String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
            _builder.append(_importedName);
            _builder.newLineIfNotEmpty();
            _builder.append("public final boolean equals(");
            String _importedName_1 = this.importedName(JavaFileTemplate.OBJECT);
            _builder.append(_importedName_1);
            _builder.append(" obj) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return this == obj || obj instanceof ");
            String _name = this.type().getName();
            _builder.append(_name, "    ");
            _builder.append(" other");
            _builder.newLineIfNotEmpty();
            List _equalsIdentifiers = this.genTO.getEqualsIdentifiers();
            for (GeneratedProperty property : _equalsIdentifiers) {
                _builder.append("        ");
                String fieldName = AbstractBaseTemplate.fieldName(property);
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                Type type = property.getReturnType();
                _builder.newLineIfNotEmpty();
                boolean _equals = type.equals(Types.primitiveBooleanType());
                if (_equals) {
                    _builder.append("        ");
                    _builder.append("&& ");
                    _builder.append(fieldName, "        ");
                    _builder.append(" == other.");
                    _builder.append(fieldName, "        ");
                    continue;
                }
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("&& ");
                String _importedUtilClass = this.importedUtilClass(type);
                _builder.append(_importedUtilClass, "        ");
                _builder.append(".equals(");
                _builder.append(fieldName, "        ");
                _builder.append(", other.");
                _builder.append(fieldName, "        ");
                _builder.append(")");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateToString(Collection<GeneratedProperty> properties) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = properties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("@");
            String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
            _builder.append(_importedName);
            _builder.newLineIfNotEmpty();
            _builder.append("public ");
            String _importedName_1 = this.importedName((Type)Types.STRING);
            _builder.append(_importedName_1);
            _builder.append(" toString() {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("final var helper = ");
            String _importedName_2 = this.importedName(JavaFileTemplate.MOREOBJECTS);
            _builder.append(_importedName_2, "    ");
            _builder.append(".toStringHelper(");
            String _importedName_3 = this.importedName((Type)this.type());
            _builder.append(_importedName_3, "    ");
            _builder.append(".class);");
            _builder.newLineIfNotEmpty();
            for (GeneratedProperty property : properties) {
                _builder.append("    ");
                String _importedName_4 = this.importedName(JavaFileTemplate.CODEHELPERS);
                _builder.append(_importedName_4, "    ");
                _builder.append(".");
                String _valueAppender = this.valueAppender(property);
                _builder.append(_valueAppender, "    ");
                _builder.append("(helper, \"");
                String _name = property.getName();
                _builder.append(_name, "    ");
                _builder.append("\", ");
                String _fieldName = AbstractBaseTemplate.fieldName(property);
                _builder.append(_fieldName, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.append("return helper.toString();");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    private String valueAppender(GeneratedProperty prop) {
        boolean _equals = prop.getReturnType().equals(Types.primitiveBooleanType());
        if (_equals) {
            return "appendBit";
        }
        return "appendValue";
    }

    public GeneratedProperty getPropByName(String name) {
        for (GeneratedProperty prop : this.allProperties) {
            boolean _equals = prop.getName().equals(name);
            if (!_equals) continue;
            return prop;
        }
        return null;
    }
}

