/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.WildcardType;
import org.opendaylight.mdsal.binding.model.api.YangSourceDefinition;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;

public final class GeneratorUtil {
    private static final ConcreteType PATTERN = Types.typeForClass(Pattern.class);

    private GeneratorUtil() {
    }

    static Map<String, JavaTypeName> createImports(GeneratedType genType) {
        GeneratedTransferObject gto;
        List properties;
        List methods;
        GeneratedTransferObject gto2;
        if (genType == null) {
            throw new IllegalArgumentException("Generated Type cannot be NULL!");
        }
        LinkedHashMap<String, JavaTypeName> imports = new LinkedHashMap<String, JavaTypeName>();
        List childGeneratedTypes = genType.getEnclosedTypes();
        if (!childGeneratedTypes.isEmpty()) {
            for (Object genTypeChild : childGeneratedTypes) {
                imports.putAll(GeneratorUtil.createImports((GeneratedType)genTypeChild));
            }
        }
        if (genType instanceof GeneratedTransferObject && GeneratorUtil.isConstantInTO("PATTERN_CONSTANTS", gto2 = (GeneratedTransferObject)genType)) {
            GeneratorUtil.putTypeIntoImports(genType, (Type)PATTERN, imports);
        }
        if ((methods = genType.getMethodDefinitions()) != null) {
            for (MethodSignature method : methods) {
                Type methodReturnType = method.getReturnType();
                GeneratorUtil.putTypeIntoImports(genType, methodReturnType, imports);
                for (MethodSignature.Parameter methodParam : method.getParameters()) {
                    GeneratorUtil.putTypeIntoImports(genType, methodParam.getType(), imports);
                }
                for (AnnotationType at : method.getAnnotations()) {
                    GeneratorUtil.putTypeIntoImports(genType, (Type)at, imports);
                }
            }
        }
        if (genType instanceof GeneratedTransferObject && (properties = (gto = (GeneratedTransferObject)genType).getProperties()) != null) {
            for (GeneratedProperty property : properties) {
                Type propertyType = property.getReturnType();
                GeneratorUtil.putTypeIntoImports(genType, propertyType, imports);
            }
        }
        return imports;
    }

    static void putTypeIntoImports(GeneratedType parentGenType, Type type, Map<String, JavaTypeName> imports) {
        ParameterizedType paramType;
        Type[] params;
        Preconditions.checkArgument((parentGenType != null ? 1 : 0) != 0, (Object)"Parent Generated Type parameter MUST be specified and cannot be NULL!");
        Preconditions.checkArgument((parentGenType.getName() != null ? 1 : 0) != 0, (Object)"Parent Generated Type name cannot be NULL!");
        Preconditions.checkArgument((parentGenType.getPackageName() != null ? 1 : 0) != 0, (Object)"Parent Generated Type cannot have Package Name referenced as NULL!");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type parameter MUST be specified and cannot be NULL!");
        Preconditions.checkArgument((type.getName() != null ? 1 : 0) != 0, (Object)"Type name cannot be NULL!");
        Preconditions.checkArgument((type.getPackageName() != null ? 1 : 0) != 0, (Object)"Type cannot have Package Name referenced as NULL!");
        String typeName = type.getName();
        String typePackageName = type.getPackageName();
        String parentTypeName = parentGenType.getName();
        if (typeName.equals(parentTypeName) || typePackageName.startsWith("java.lang") || typePackageName.isEmpty()) {
            return;
        }
        if (!imports.containsKey(typeName)) {
            imports.put(typeName, (JavaTypeName)type.getIdentifier());
        }
        if (type instanceof ParameterizedType && (params = (paramType = (ParameterizedType)type).getActualTypeArguments()) != null) {
            for (Type param : params) {
                GeneratorUtil.putTypeIntoImports(parentGenType, param, imports);
            }
        }
    }

    static boolean isConstantInTO(String constName, GeneratedTransferObject genTO) {
        if (constName == null || genTO == null) {
            throw new IllegalArgumentException();
        }
        List consts = genTO.getConstantDefinitions();
        for (Constant cons : consts) {
            if (!cons.getName().equals(constName)) continue;
            return true;
        }
        return false;
    }

    static Map<String, String> createChildImports(GeneratedType genType) {
        LinkedHashMap<String, String> childImports = new LinkedHashMap<String, String>();
        for (GeneratedType genTypeChild : genType.getEnclosedTypes()) {
            GeneratorUtil.createChildImports(genTypeChild);
            childImports.put(genTypeChild.getName(), genTypeChild.getPackageName());
        }
        return childImports;
    }

    static String getExplicitType(GeneratedType parentGenType, Type type, Map<String, JavaTypeName> imports) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type parameter MUST be specified and cannot be NULL!");
        Preconditions.checkArgument((imports != null ? 1 : 0) != 0, (Object)"Imports Map cannot be NULL!");
        JavaTypeName importedType = imports.get(type.getName());
        StringBuilder builder = new StringBuilder();
        if (((JavaTypeName)type.getIdentifier()).equals((Object)importedType)) {
            builder.append(type.getName());
            GeneratorUtil.addActualTypeParameters(builder, type, parentGenType, imports);
            if (builder.toString().equals("Void")) {
                return "void";
            }
        } else {
            if (type.equals(Types.voidType())) {
                return "void";
            }
            builder.append(type.getFullyQualifiedName());
            GeneratorUtil.addActualTypeParameters(builder, type, parentGenType, imports);
        }
        return builder.toString();
    }

    private static StringBuilder addActualTypeParameters(StringBuilder builder, Type type, GeneratedType parentGenType, Map<String, JavaTypeName> imports) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] pTypes = pType.getActualTypeArguments();
            builder.append('<').append(GeneratorUtil.getParameters(parentGenType, pTypes, imports)).append('>');
        }
        return builder;
    }

    private static String getParameters(GeneratedType parentGenType, Type[] paramTypes, Map<String, JavaTypeName> availableImports) {
        if (paramTypes == null || paramTypes.length == 0) {
            return "?";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < paramTypes.length; ++i) {
            Type t = paramTypes[i];
            if (Types.voidType().equals(t)) {
                builder.append("java.lang.Void");
            } else {
                if (t instanceof WildcardType) {
                    builder.append("? extends ");
                }
                builder.append(GeneratorUtil.getExplicitType(parentGenType, t, availableImports));
            }
            if (i == paramTypes.length - 1) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    static List<GeneratedProperty> resolveReadOnlyPropertiesFromTO(List<GeneratedProperty> properties) {
        ArrayList<GeneratedProperty> readOnlyProperties = new ArrayList<GeneratedProperty>();
        if (properties != null) {
            for (GeneratedProperty property : properties) {
                if (!property.isReadOnly()) continue;
                readOnlyProperties.add(property);
            }
        }
        return readOnlyProperties;
    }

    static List<GeneratedProperty> getPropertiesOfAllParents(GeneratedTransferObject genTO) {
        ArrayList<GeneratedProperty> propertiesOfAllParents = new ArrayList<GeneratedProperty>();
        if (genTO.getSuperType() != null) {
            List allPropertiesOfTO = genTO.getSuperType().getProperties();
            List<GeneratedProperty> readOnlyPropertiesOfTO = GeneratorUtil.resolveReadOnlyPropertiesFromTO(allPropertiesOfTO);
            propertiesOfAllParents.addAll(readOnlyPropertiesOfTO);
            propertiesOfAllParents.addAll(GeneratorUtil.getPropertiesOfAllParents(genTO.getSuperType()));
        }
        return propertiesOfAllParents;
    }

    static boolean isNonPresenceContainer(GeneratedType type) {
        ContainerSchemaNode container;
        YangSourceDefinition.Single single;
        Object object;
        Optional definition = type.getYangSourceDefinition();
        return definition.isPresent() && (object = definition.orElseThrow()) instanceof YangSourceDefinition.Single && (object = (single = (YangSourceDefinition.Single)object).getNode()) instanceof ContainerSchemaNode && !(container = (ContainerSchemaNode)object).isPresenceContainer();
    }
}

