/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.TypeUtils;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LengthGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(LengthGenerator.class);

    private LengthGenerator() {
    }

    private static String lengthCheckerName(String member) {
        return "check" + member + "Length";
    }

    private static Collection<String> createExpressions(LengthConstraint constraint) {
        Set constraints = constraint.getAllowedRanges().asRanges();
        ArrayList<String> ret = new ArrayList<String>(constraints.size());
        for (Range l : constraints) {
            String expr = LengthGenerator.createExpression((Integer)l.lowerEndpoint(), (Integer)l.upperEndpoint());
            if (expr == null) {
                LOG.debug("Constraint {} implied by int type value domain, skipping", (Object)l);
                continue;
            }
            ret.add(expr);
        }
        return ret;
    }

    private static @Nullable String createExpression(int min, int max) {
        if (min == max) {
            return min < Integer.MAX_VALUE ? "length == " + min : null;
        }
        if (min > 0) {
            StringBuilder sb = new StringBuilder("length >= ").append(min);
            if (max < Integer.MAX_VALUE) {
                sb.append(" && length <= ").append(max);
            }
            return sb.toString();
        }
        return max < Integer.MAX_VALUE ? "length <= " + max : null;
    }

    private static String createLengthString(LengthConstraint constraint) {
        return new ArrayList(constraint.getAllowedRanges().asRanges()).toString();
    }

    private static String generateArrayLengthChecker(String member, LengthConstraint constraint, JavaFileTemplate template) {
        StringBuilder sb = new StringBuilder();
        Collection<String> expressions = LengthGenerator.createExpressions(constraint);
        sb.append("private static void ").append(LengthGenerator.lengthCheckerName(member)).append("(final byte[] value) {\n");
        if (!expressions.isEmpty()) {
            sb.append("    final int length = value.length;\n");
            for (String exp : expressions) {
                sb.append("    if (").append(exp).append(") {\n");
                sb.append("        return;\n");
                sb.append("    }\n");
            }
            sb.append("    ").append(template.importedName(JavaFileTemplate.CODEHELPERS)).append(".throwInvalidLength(\"").append(LengthGenerator.createLengthString(constraint)).append("\", value);\n");
        }
        return sb.append("}\n").toString();
    }

    private static String generateStringLengthChecker(String member, LengthConstraint constraint, JavaFileTemplate template) {
        StringBuilder sb = new StringBuilder();
        Collection<String> expressions = LengthGenerator.createExpressions(constraint);
        sb.append("private static void ").append(LengthGenerator.lengthCheckerName(member)).append("(final ").append(template.importedName((Type)Types.STRING)).append(" value) {\n");
        if (!expressions.isEmpty()) {
            sb.append("    final int length = value.codePointCount(0, value.length());\n");
            for (String exp : expressions) {
                sb.append("    if (").append(exp).append(") {\n");
                sb.append("        return;\n");
                sb.append("    }\n");
            }
            sb.append("    ").append(template.importedName(JavaFileTemplate.CODEHELPERS)).append(".throwInvalidLength(\"").append(LengthGenerator.createLengthString(constraint)).append("\", value);\n");
        }
        return sb.append("}\n").toString();
    }

    static String generateLengthChecker(String member, @NonNull Type type, LengthConstraint constraint, JavaFileTemplate template) {
        return TypeUtils.getBaseYangType(type).getName().indexOf(91) != -1 ? LengthGenerator.generateArrayLengthChecker(member, constraint, template) : LengthGenerator.generateStringLengthChecker(member, constraint, template);
    }

    static String generateLengthCheckerCall(@Nullable String member, @NonNull String valueReference) {
        return LengthGenerator.lengthCheckerName(member) + "(" + valueReference + ");\n";
    }
}

