/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractBaseTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.ClassTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;

public final class ListKeyTemplate
extends ClassTemplate {
    public ListKeyTemplate(GeneratedTransferObject genType) {
        super(genType);
    }

    @Override
    public CharSequence allValuesConstructor() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Constructs an instance.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        for (GeneratedProperty p : this.allProperties) {
            _builder.append(" ");
            _builder.append("* @param ");
            String _fieldName = AbstractBaseTemplate.fieldName(p);
            _builder.append(_fieldName, " ");
            _builder.append(" the entity ");
            String _name = p.getName();
            _builder.append(_name, " ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(" ");
        _builder.append("* @throws NullPointerException if any of the arguments are null");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _name_1 = this.type().getName();
        _builder.append(_name_1);
        _builder.append("(");
        CharSequence _asNonNullArgumentsDeclaration = this.asNonNullArgumentsDeclaration(this.allProperties);
        _builder.append((Object)_asNonNullArgumentsDeclaration);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        for (GeneratedProperty p_1 : this.allProperties) {
            _builder.append("    ");
            String fieldName = AbstractBaseTemplate.fieldName(p_1);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("this.");
            _builder.append(fieldName, "    ");
            _builder.append(" = ");
            String _importedName = this.importedName(JavaFileTemplate.CODEHELPERS);
            _builder.append(_importedName, "    ");
            _builder.append(".requireKeyProp(");
            _builder.append(fieldName, "    ");
            _builder.append(", \"");
            String _name_2 = p_1.getName();
            _builder.append(_name_2, "    ");
            _builder.append("\")");
            String _cloneCall = JavaFileTemplate.cloneCall(p_1);
            _builder.append(_cloneCall, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        for (GeneratedProperty p_2 : this.properties) {
            _builder.append("    ");
            CharSequence _generateRestrictions = this.generateRestrictions((Type)this.type(), AbstractBaseTemplate.fieldName(p_2), p_2.getReturnType());
            _builder.append((Object)_generateRestrictions, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @Override
    public CharSequence getterMethod(GeneratedProperty field) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Return ");
        String _name = field.getName();
        _builder.append(_name, " ");
        _builder.append(", guaranteed to be non-null.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return {@code ");
        String _importedName = this.importedName(field.getReturnType());
        _builder.append(_importedName, " ");
        _builder.append("} ");
        String _name_1 = field.getName();
        _builder.append(_name_1, " ");
        _builder.append(", guaranteed to be non-null.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _importedNonNull = this.importedNonNull(field.getReturnType());
        _builder.append(_importedNonNull);
        _builder.append(" ");
        String _terMethodName = AbstractBaseTemplate.getterMethodName(field);
        _builder.append(_terMethodName);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        String _fieldName = AbstractBaseTemplate.fieldName(field);
        _builder.append(_fieldName, "    ");
        String _cloneCall = JavaFileTemplate.cloneCall(field);
        _builder.append(_cloneCall, "    ");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @Override
    protected String formatDataForJavaDoc(GeneratedType type) {
        Type listType = ListKeyTemplate.findListType(type);
        if (listType == null) {
            return "";
        }
        String importedName = this.importedName(listType);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This class represents the key of {@link ");
        _builder.append(importedName);
        _builder.append("} class.");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("@see ");
        _builder.append(importedName);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private static Type findListType(GeneratedType type) {
        List _implements = type.getImplements();
        for (Type implType : _implements) {
            Type identifiable;
            if (!(implType instanceof ParameterizedType) || (identifiable = BindingTypes.extractKeyType((ParameterizedType)((ParameterizedType)implType))) == null) continue;
            return identifiable;
        }
        return null;
    }
}

