/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import org.opendaylight.mdsal.binding.java.api.generator.ClassTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.FeatureTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.ListKeyTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.UnionTemplate;
import org.opendaylight.mdsal.binding.model.api.CodeGenerator;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;

public final class TOGenerator
implements CodeGenerator {
    public String generate(Type type) {
        if (type instanceof GeneratedTransferObject) {
            GeneratedTransferObject genTO = (GeneratedTransferObject)type;
            if (genTO.isUnionType()) {
                return new UnionTemplate(genTO).generate();
            }
            if (genTO.isTypedef()) {
                return new ClassTemplate(genTO).generate();
            }
            Type featureDataRoot = BindingTypes.extractYangFeatureDataRoot((GeneratedTransferObject)genTO);
            return featureDataRoot == null ? new ListKeyTemplate(genTO).generate() : new FeatureTemplate(genTO, featureDataRoot).generate();
        }
        return "";
    }

    public boolean isAcceptable(Type type) {
        return type instanceof GeneratedTransferObject;
    }

    public String getUnitName(Type type) {
        return type.getName();
    }
}

