/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.collect.Iterables;
import java.util.Base64;
import java.util.Collections;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractBaseTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractJavaGeneratedType;
import org.opendaylight.mdsal.binding.java.api.generator.ClassTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.NestedJavaGeneratedType;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.BaseYangTypes;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;

public class UnionTemplate
extends ClassTemplate {
    public UnionTemplate(NestedJavaGeneratedType javaType, GeneratedTransferObject genType) {
        super((AbstractJavaGeneratedType)javaType, genType);
    }

    public UnionTemplate(GeneratedTransferObject genType) {
        super(genType);
    }

    @Override
    public CharSequence constructors() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _unionConstructorsParentProperties = this.unionConstructorsParentProperties();
        _builder.append((Object)_unionConstructorsParentProperties);
        _builder.newLineIfNotEmpty();
        CharSequence _unionConstructors = this.unionConstructors();
        _builder.append((Object)_unionConstructors);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this.allProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _copyConstructor = this.copyConstructor();
            _builder.append((Object)_copyConstructor);
            _builder.newLineIfNotEmpty();
        }
        if (this.properties.isEmpty() && !this.parentProperties.isEmpty()) {
            CharSequence _parentConstructor = this.parentConstructor();
            _builder.append((Object)_parentConstructor);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _generateStringValue = this.generateStringValue();
        _builder.append((Object)_generateStringValue);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence unionConstructors() {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (GeneratedProperty property : this.finalProperties) {
            boolean _not;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            Type actualType = property.getReturnType();
            _builder.newLineIfNotEmpty();
            Restrictions restrictions = JavaFileTemplate.restrictionsForSetter(actualType);
            _builder.newLineIfNotEmpty();
            if (restrictions != null) {
                CharSequence _generateCheckers = this.generateCheckers(property, restrictions, actualType);
                _builder.append((Object)_generateCheckers);
                _builder.newLineIfNotEmpty();
            }
            Iterable propertyAndTopParentProperties = Iterables.concat((Iterable)this.parentProperties, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new GeneratedProperty[]{property})));
            _builder.newLineIfNotEmpty();
            String propFieldName = AbstractBaseTemplate.fieldName(property);
            _builder.newLineIfNotEmpty();
            _builder.append("public ");
            String _name = this.type().getName();
            _builder.append(_name);
            _builder.append("(");
            CharSequence _asArgumentsDeclaration = this.asArgumentsDeclaration(propertyAndTopParentProperties);
            _builder.append((Object)_asArgumentsDeclaration);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            boolean _isEmpty = this.parentProperties.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append("    ");
                _builder.append("super(");
                CharSequence _asArguments = this.asArguments(this.parentProperties);
                _builder.append((Object)_asArguments, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            if (restrictions != null) {
                _builder.append("    ");
                CharSequence _checkArgument = this.checkArgument(property, restrictions, actualType, propFieldName);
                _builder.append((Object)_checkArgument, "    ");
                _builder.newLineIfNotEmpty();
            }
            for (GeneratedProperty other : this.finalProperties) {
                boolean _equals = property.equals(other);
                if (_equals) {
                    _builder.append("    ");
                    _builder.append("this.");
                    _builder.append(propFieldName, "    ");
                    _builder.append(" = ");
                    String _importedName = this.importedName(JavaFileTemplate.JU_OBJECTS);
                    _builder.append(_importedName, "    ");
                    _builder.append(".requireNonNull(");
                    _builder.append(propFieldName, "    ");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("    ");
                _builder.append("this.");
                String _fieldName = AbstractBaseTemplate.fieldName(other);
                _builder.append(_fieldName, "    ");
                _builder.append(" = null;");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public String typeBuilder() {
        String outerCls = Types.getOuterClassName((Type)this.type());
        if (outerCls != null) {
            String _name = this.type().getName();
            String _plus = outerCls + _name;
            return _plus + "Builder";
        }
        String _name_1 = this.type().getName();
        return _name_1 + "Builder";
    }

    private CharSequence unionConstructorsParentProperties() {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (GeneratedProperty property : this.parentProperties) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            _builder.append("public ");
            String _name = this.type().getName();
            _builder.append(_name);
            _builder.append("(");
            String _importedName = this.importedName(property.getReturnType());
            _builder.append(_importedName);
            _builder.append(" ");
            String _fieldName = AbstractBaseTemplate.fieldName(property);
            _builder.append(_fieldName);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("super(");
            String _fieldName_1 = AbstractBaseTemplate.fieldName(property);
            _builder.append(_fieldName_1, "    ");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateStringValue() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Return a String representing the value of this union.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return String representation of this union's value.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _importedName = this.importedName((Type)Types.STRING);
        _builder.append(_importedName);
        _builder.append(" stringValue() {");
        _builder.newLineIfNotEmpty();
        for (GeneratedProperty property : this.finalProperties) {
            _builder.append("    ");
            _builder.append("    ");
            String field = AbstractBaseTemplate.fieldName(property);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("if (");
            _builder.append(field, "    ");
            _builder.append(" != null) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            Type propRet = property.getReturnType();
            _builder.newLineIfNotEmpty();
            boolean _equals = BaseYangTypes.STRING_TYPE.equals(propRet);
            if (_equals) {
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("return ");
                _builder.append(field, "        ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _equals_1 = "org.opendaylight.yangtools.yang.binding.InstanceIdentifier".equals(propRet.getFullyQualifiedName());
                if (_equals_1) {
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("return ");
                    _builder.append(field, "        ");
                    _builder.append(".toString();");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _equals_2 = BaseYangTypes.BINARY_TYPE.equals(propRet);
                    if (_equals_2) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("return new ");
                        String _importedName_1 = this.importedName((Type)Types.STRING);
                        _builder.append(_importedName_1, "        ");
                        _builder.append("(");
                        _builder.append(field, "        ");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                    } else if (propRet.getFullyQualifiedName().startsWith("java.lang") || propRet instanceof Enumeration) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("return ");
                        _builder.append(field, "        ");
                        _builder.append(".toString();");
                        _builder.newLineIfNotEmpty();
                    } else if ("org.opendaylight.yangtools.yang.common".equals(propRet.getPackageName()) && (propRet.getName().startsWith("Uint") || "Decimal64".equals(propRet.getName()))) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("return ");
                        _builder.append(field, "        ");
                        _builder.append(".toCanonicalString();");
                        _builder.newLineIfNotEmpty();
                    } else if (propRet instanceof GeneratedTransferObject && ((GeneratedTransferObject)propRet).isUnionType()) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("return ");
                        _builder.append(field, "        ");
                        _builder.append(".stringValue();");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _equals_3 = BaseYangTypes.BOOLEAN_TYPE.equals(UnionTemplate.typedefReturnType(propRet));
                        if (_equals_3) {
                            _builder.append("    ");
                            _builder.append("    ");
                            _builder.append("return ");
                            _builder.append(field, "        ");
                            _builder.append(".isValue().toString();");
                            _builder.newLineIfNotEmpty();
                        } else {
                            boolean _equals_4 = BaseYangTypes.BINARY_TYPE.equals(UnionTemplate.typedefReturnType(propRet));
                            if (_equals_4) {
                                _builder.append("    ");
                                _builder.append("    ");
                                _builder.append("return ");
                                String _importedName_2 = this.importedName(Base64.class);
                                _builder.append(_importedName_2, "        ");
                                _builder.append(".getEncoder().encodeToString(");
                                _builder.append(field, "        ");
                                _builder.append(".getValue());");
                                _builder.newLineIfNotEmpty();
                            } else if (BaseYangTypes.EMPTY_TYPE.equals(propRet) || BaseYangTypes.EMPTY_TYPE.equals(UnionTemplate.typedefReturnType(propRet))) {
                                _builder.append("    ");
                                _builder.append("    ");
                                _builder.append("return \"\";");
                                _builder.newLine();
                            } else {
                                boolean _isBitsType = BindingTypes.isBitsType((Type)propRet);
                                if (_isBitsType) {
                                    _builder.append("    ");
                                    _builder.append("    ");
                                    _builder.append("return ");
                                    String _importedName_3 = this.importedName(JavaFileTemplate.JU_ARRAYS);
                                    _builder.append(_importedName_3, "        ");
                                    _builder.append(".toString(");
                                    _builder.append(field, "        ");
                                    _builder.append(".values());");
                                    _builder.newLineIfNotEmpty();
                                } else {
                                    boolean _isIdentityType = BindingTypes.isIdentityType((Type)propRet);
                                    if (_isIdentityType) {
                                        _builder.append("    ");
                                        _builder.append("    ");
                                        _builder.append("return ");
                                        _builder.append(field, "        ");
                                        _builder.append(".");
                                        _builder.append("implementedInterface", "        ");
                                        _builder.append("().toString();");
                                        _builder.newLineIfNotEmpty();
                                    } else {
                                        _builder.append("    ");
                                        _builder.append("    ");
                                        _builder.append("return ");
                                        _builder.append(field, "        ");
                                        _builder.append(".getValue().toString();");
                                        _builder.newLineIfNotEmpty();
                                    }
                                }
                            }
                        }
                    }
                }
            }
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("    ");
        _builder.append("throw new IllegalStateException(\"No value assigned\");");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private static Type typedefReturnType(Type type) {
        if (!(type instanceof GeneratedTransferObject)) {
            return null;
        }
        GeneratedTransferObject gto = (GeneratedTransferObject)type;
        if (!gto.isTypedef() || gto.getProperties() == null || gto.getProperties().size() != 1) {
            return null;
        }
        GeneratedProperty prop = (GeneratedProperty)gto.getProperties().get(0);
        boolean _equals = prop.getName().equals("value");
        if (_equals) {
            return prop.getReturnType();
        }
        return null;
    }

    @Override
    protected CharSequence copyConstructor() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Creates a copy from Source Object.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param source Source object");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append("(");
        String _name_1 = this.type().getName();
        _builder.append(_name_1);
        _builder.append(" source) {");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this.parentProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.append("super(source);");
            _builder.newLine();
        }
        for (GeneratedProperty p : this.properties) {
            _builder.append("    ");
            String fieldName = AbstractBaseTemplate.fieldName(p);
            _builder.newLineIfNotEmpty();
            boolean _endsWith = p.getReturnType().getName().endsWith("[]");
            if (_endsWith) {
                _builder.append("    ");
                _builder.append("this.");
                _builder.append(fieldName, "    ");
                _builder.append(" = source.");
                _builder.append(fieldName, "    ");
                _builder.append(" == null ? null : source.");
                _builder.append(fieldName, "    ");
                _builder.append(".clone();");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("    ");
            _builder.append("this.");
            _builder.append(fieldName, "    ");
            _builder.append(" = source.");
            _builder.append(fieldName, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

