/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataSchemaNode;
import org.opendaylight.yangtools.yang.binding.contract.Naming;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public final class YangModuleInfoTemplate {
    private static final Comparator<Optional<Revision>> REVISION_COMPARATOR = (first, second) -> Revision.compare((Optional)first, (Optional)second);
    private static final String CORE_IMPORT_STR = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("import com.google.common.collect.ImmutableSet;");
            _builder.newLine();
            _builder.append("import java.lang.Override;");
            _builder.newLine();
            _builder.append("import java.lang.String;");
            _builder.newLine();
            _builder.append("import org.eclipse.jdt.annotation.NonNull;");
            _builder.newLine();
            _builder.append("import org.opendaylight.yangtools.yang.binding.ResourceYangModuleInfo;");
            _builder.newLine();
            _builder.append("import org.opendaylight.yangtools.yang.binding.YangModuleInfo;");
            _builder.newLine();
            _builder.append("import org.opendaylight.yangtools.yang.common.QName;");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    private static final String EXT_IMPORT_STR = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("import com.google.common.collect.ImmutableSet;");
            _builder.newLine();
            _builder.append("import java.lang.Override;");
            _builder.newLine();
            _builder.append("import java.lang.String;");
            _builder.newLine();
            _builder.append("import java.util.HashSet;");
            _builder.newLine();
            _builder.append("import java.util.Set;");
            _builder.newLine();
            _builder.append("import org.eclipse.jdt.annotation.NonNull;");
            _builder.newLine();
            _builder.append("import org.opendaylight.yangtools.yang.binding.ResourceYangModuleInfo;");
            _builder.newLine();
            _builder.append("import org.opendaylight.yangtools.yang.binding.YangModuleInfo;");
            _builder.newLine();
            _builder.append("import org.opendaylight.yangtools.yang.common.QName;");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    private final Module module;
    private final EffectiveModelContext ctx;
    private final Function<ModuleLike, Optional<String>> moduleFilePathResolver;
    private final boolean hasYangData;
    private String importedTypes = CORE_IMPORT_STR;
    @Accessors
    private final String packageName;
    @Accessors
    private final String modelBindingProviderName;

    public YangModuleInfoTemplate(Module module, EffectiveModelContext ctx, Function<ModuleLike, Optional<String>> moduleFilePathResolver) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module must not be null.");
        this.module = module;
        this.ctx = ctx;
        this.moduleFilePathResolver = moduleFilePathResolver;
        this.packageName = Naming.getServicePackageName((QNameModule)module.getQNameModule());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.packageName);
        _builder.append(".");
        _builder.append("YangModelBindingProviderImpl");
        this.modelBindingProviderName = _builder.toString();
        Predicate<UnknownSchemaNode> _function = s -> s instanceof YangDataSchemaNode;
        this.hasYangData = module.getUnknownSchemaNodes().stream().anyMatch(_function);
    }

    public String generate() {
        HashSet<Submodule> submodules = new HashSet<Submodule>();
        YangModuleInfoTemplate.collectSubmodules(submodules, (ModuleLike)this.module);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The {@link ResourceYangModuleInfo} for {@code ");
        String _name = this.module.getName();
        _builder.append(_name, " ");
        _builder.append("} module.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@");
        _builder.append((Object)JavaFileTemplate.GENERATED);
        _builder.append("(\"mdsal-binding-generator\")");
        _builder.newLineIfNotEmpty();
        _builder.append("public final class ");
        _builder.append("YangModuleInfoImpl");
        _builder.append(" extends ResourceYangModuleInfo {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        Optional rev = this.module.getRevision();
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("private static final @NonNull QName NAME = QName.create(\"");
        String _string = this.module.getQNameModule().namespace().toString();
        _builder.append(_string, "    ");
        _builder.append("\", ");
        boolean _isPresent = rev.isPresent();
        if (_isPresent) {
            _builder.append("\"");
            String _string_1 = ((Revision)rev.orElseThrow()).toString();
            _builder.append(_string_1, "    ");
            _builder.append("\", ");
        }
        _builder.append("\"");
        String _name_1 = this.module.getName();
        _builder.append(_name_1, "    ");
        _builder.append("\").intern();");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("private static final @NonNull YangModuleInfo INSTANCE = new ");
        _builder.append("YangModuleInfoImpl", "    ");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("private final @NonNull ImmutableSet<YangModuleInfo> importedModules;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Return the singleton instance of this class.");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @return The singleton instance");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public static @NonNull YangModuleInfo getInstance() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return INSTANCE;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Create an interned {@link QName} with specified {@code localName} and namespace/revision of this");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* module.");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @param localName local name");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @return A QName");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @throws NullPointerException if {@code localName} is {@code null}");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @throws IllegalArgumentException if {@code localName} is not a valid YANG identifier");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public static @NonNull QName ");
        _builder.append("qnameOf", "    ");
        _builder.append("(final String localName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("return QName.create(NAME, localName).intern();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        if (this.hasYangData) {
            _builder.newLine();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Create an interned {@link YangDataName} with specified {@code templateName} and namespace/revision of");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* this module.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param templateName template name");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @return A YangDataName");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @throws NullPointerException if {@code templateName} is {@code null}");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @throws IllegalArgumentException if {@code templateName} is empty");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("public static @NonNull YangDataName ");
            _builder.append("yangDataNameOf");
            _builder.append("(final String templateName) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return new YangDataName(NAME.getModule(), templateName).intern();");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("    ");
        CharSequence _classBody = this.classBody((ModuleLike)this.module, "YangModuleInfoImpl", submodules);
        _builder.append((Object)_classBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        String body = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("package ");
        _builder_1.append(this.packageName);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.newLine();
        _builder_1.append(this.importedTypes);
        _builder_1.newLineIfNotEmpty();
        if (this.hasYangData) {
            _builder_1.append("import org.opendaylight.yangtools.yang.common.YangDataName;");
            _builder_1.newLine();
        }
        _builder_1.newLine();
        _builder_1.append(body);
        _builder_1.newLineIfNotEmpty();
        return _builder_1.toString();
    }

    public String generateModelProvider() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(this.packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.lang.Override;");
        _builder.newLine();
        _builder.append("import java.util.ServiceLoader;");
        _builder.newLine();
        _builder.append("import org.opendaylight.yangtools.yang.binding.YangModelBindingProvider;");
        _builder.newLine();
        _builder.append("import org.opendaylight.yangtools.yang.binding.YangModuleInfo;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The {@link YangModelBindingProvider} for {@code ");
        String _name = this.module.getName();
        _builder.append(_name, " ");
        _builder.append("} module. This class should not be used");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* directly, but rather through {@link ServiceLoader}.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@");
        _builder.append((Object)JavaFileTemplate.GENERATED);
        _builder.append("(\"mdsal-binding-generator\")");
        _builder.newLineIfNotEmpty();
        _builder.append("public final class ");
        _builder.append("YangModelBindingProviderImpl");
        _builder.append(" implements YangModelBindingProvider {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Construct a new provider.");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public ");
        _builder.append("YangModelBindingProviderImpl", "    ");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("// No-op");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public YangModuleInfo getModuleInfo() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return ");
        _builder.append("YangModuleInfoImpl", "        ");
        _builder.append(".getInstance();");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private static void collectSubmodules(Set<Submodule> dest, ModuleLike module) {
        Collection _submodules = module.getSubmodules();
        for (Submodule submodule : _submodules) {
            boolean _add = dest.add(submodule);
            if (!_add) continue;
            YangModuleInfoTemplate.collectSubmodules(dest, (ModuleLike)submodule);
        }
    }

    private CharSequence classBody(ModuleLike m, String className, Set<Submodule> submodules) {
        boolean _isEmpty;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private ");
        _builder.append(className);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        if (!m.getImports().isEmpty() || !submodules.isEmpty()) {
            _builder.append("    ");
            this.extendImports();
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("Set<YangModuleInfo> set = new HashSet<>();");
            _builder.newLine();
        }
        boolean bl = _not = !(_isEmpty = m.getImports().isEmpty());
        if (_not) {
            Collection _imports = m.getImports();
            for (ModuleImport imp : _imports) {
                _builder.append("    ");
                String name = imp.getModuleName().getLocalName();
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                Optional rev = imp.getRevision();
                _builder.newLineIfNotEmpty();
                boolean _isEmpty_1 = rev.isEmpty();
                if (_isEmpty_1) {
                    _builder.append("    ");
                    TreeMap<Optional<Revision>, Module> sorted = new TreeMap<Optional<Revision>, Module>(REVISION_COMPARATOR);
                    _builder.newLineIfNotEmpty();
                    Collection _modules = this.ctx.getModules();
                    for (Module module : _modules) {
                        boolean _equals = name.equals(module.getName());
                        if (!_equals) continue;
                        _builder.append("    ");
                        Module _put = sorted.put(module.getRevision(), module);
                        _builder.append((Object)_put, "    ");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("    ");
                    _builder.append("set.add(");
                    String _servicePackageName = Naming.getServicePackageName((QNameModule)((Module)sorted.lastEntry().getValue()).getQNameModule());
                    _builder.append(_servicePackageName, "    ");
                    _builder.append(".");
                    _builder.append("YangModuleInfoImpl", "    ");
                    _builder.append(".getInstance());");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("    ");
                _builder.append("set.add(");
                String _servicePackageName_1 = Naming.getServicePackageName((QNameModule)((Module)this.ctx.findModule(name, rev).orElseThrow()).getQNameModule());
                _builder.append(_servicePackageName_1, "    ");
                _builder.append(".");
                _builder.append("YangModuleInfoImpl", "    ");
                _builder.append(".getInstance());");
                _builder.newLineIfNotEmpty();
            }
        }
        for (Submodule submodule : submodules) {
            _builder.append("    ");
            _builder.append("set.add(");
            String _className = Naming.getClassName((String)submodule.getName());
            _builder.append(_className, "    ");
            _builder.append("Info.getInstance());");
            _builder.newLineIfNotEmpty();
        }
        if (m.getImports().isEmpty() && submodules.isEmpty()) {
            _builder.append("    ");
            _builder.append("importedModules = ImmutableSet.of();");
            _builder.newLine();
        } else {
            _builder.append("    ");
            _builder.append("importedModules = ImmutableSet.copyOf(set);");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public QName getName() {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return NAME;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("protected String resourceName() {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return \"");
        String _sourcePath = this.sourcePath(m);
        _builder.append(_sourcePath, "    ");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public ImmutableSet<YangModuleInfo> getImportedModules() {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return importedModules;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        CharSequence _generateSubInfo = this.generateSubInfo(submodules);
        _builder.append((Object)_generateSubInfo);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private void extendImports() {
        this.importedTypes = EXT_IMPORT_STR;
    }

    private String sourcePath(ModuleLike module) {
        Optional<String> opt = this.moduleFilePathResolver.apply(module);
        Preconditions.checkState((boolean)opt.isPresent(), (String)"Module %s does not have a file path", (Object)module);
        return opt.orElseThrow();
    }

    private CharSequence generateSubInfo(Set<Submodule> submodules) {
        StringConcatenation _builder = new StringConcatenation();
        for (Submodule submodule : submodules) {
            String className = Naming.getClassName((String)submodule.getName());
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("private static final class ");
            _builder.append(className);
            _builder.append("Info extends ResourceYangModuleInfo {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            Optional rev = submodule.getRevision();
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("private final @NonNull QName NAME = QName.create(\"");
            String _string = submodule.getQNameModule().namespace().toString();
            _builder.append(_string, "    ");
            _builder.append("\", ");
            boolean _isPresent = rev.isPresent();
            if (_isPresent) {
                _builder.append("\"");
                String _string_1 = ((Revision)rev.orElseThrow()).toString();
                _builder.append(_string_1, "    ");
                _builder.append("\", ");
            }
            _builder.append("\"");
            String _name = submodule.getName();
            _builder.append(_name, "    ");
            _builder.append("\").intern();");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("private static final @NonNull YangModuleInfo INSTANCE = new ");
            _builder.append(className, "    ");
            _builder.append("Info();");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("private final @NonNull ImmutableSet<YangModuleInfo> importedModules;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("public static @NonNull YangModuleInfo getInstance() {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("return INSTANCE;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("    ");
            CharSequence _classBody = this.classBody((ModuleLike)submodule, className + "Info", (Set<Submodule>)ImmutableSet.of());
            _builder.append((Object)_classBody, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    @Pure
    public String getPackageName() {
        return this.packageName;
    }

    @Pure
    public String getModelBindingProviderName() {
        return this.modelBindingProviderName;
    }
}

