/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;

public class StatementSourceException
extends RuntimeException {
    private static final long serialVersionUID = 2L;
    private final @NonNull StatementSourceReference sourceRef;

    public StatementSourceException(StatementSourceReference sourceRef, String message) {
        super(StatementSourceException.createMessage(sourceRef, message));
        this.sourceRef = Objects.requireNonNull(sourceRef);
    }

    public StatementSourceException(StatementSourceReference sourceRef, String message, Throwable cause) {
        super(StatementSourceException.createMessage(sourceRef, message), cause);
        this.sourceRef = Objects.requireNonNull(sourceRef);
    }

    public StatementSourceException(StatementSourceReference sourceRef, String format, Object ... args) {
        this(sourceRef, format.formatted(args));
    }

    public StatementSourceException(StatementSourceReference sourceRef, Throwable cause, String format, Object ... args) {
        this(sourceRef, format.formatted(args), cause);
    }

    private static String createMessage(StatementSourceReference sourceRef, String message) {
        return Objects.requireNonNull(message) + " [at " + Objects.requireNonNull(sourceRef) + "]";
    }

    public final @NonNull StatementSourceReference sourceRef() {
        return this.sourceRef;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.throwNSE();
    }

    protected final void throwNSE() throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }
}

