/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.source;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record SourceIdentifier(// Could not load outer class - annotation placement on inner may be incorrect
 @NonNull UnresolvedQName.Unqualified name, @Nullable Revision revision) implements Identifier
{
    private static final long serialVersionUID = 3L;
    private static final Logger LOG = LoggerFactory.getLogger(SourceIdentifier.class);

    public SourceIdentifier(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull UnresolvedQName.Unqualified name, @Nullable Revision revision) {
        Objects.requireNonNull(name);
    }

    public SourceIdentifier(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull UnresolvedQName.Unqualified name) {
        this(name, null);
    }

    public SourceIdentifier(@NonNull String name) {
        this(UnresolvedQName.Unqualified.of((String)name));
    }

    public SourceIdentifier(@NonNull String name, @Nullable Revision revision) {
        this(UnresolvedQName.Unqualified.of((String)name), revision);
    }

    public SourceIdentifier(@NonNull String name, @Nullable String revision) {
        this(name, revision != null ? Revision.of((String)revision) : null);
    }

    public static @NonNull SourceIdentifier ofYinFileName(String fileName) {
        if (fileName.endsWith(".yin")) {
            return SourceIdentifier.ofFileName(fileName.substring(0, fileName.length() - ".yin".length()));
        }
        throw new IllegalArgumentException("Filename " + fileName + " does not end with '.yin'");
    }

    public static @NonNull SourceIdentifier ofYangFileName(String fileName) {
        if (fileName.endsWith(".yang")) {
            return SourceIdentifier.ofFileName(fileName.substring(0, fileName.length() - ".yang".length()));
        }
        throw new IllegalArgumentException("Filename '" + fileName + "' does not end with '.yang'");
    }

    private static @NonNull SourceIdentifier ofFileName(String fileName) {
        Map.Entry parsed = YangNames.parseFilename((String)fileName);
        return new SourceIdentifier((String)parsed.getKey(), (String)parsed.getValue());
    }

    public @NonNull String toYangFilename() {
        return SourceIdentifier.toYangFileName(this.name.getLocalName(), this.revision);
    }

    public @NonNull String toYinFilename() {
        return SourceIdentifier.toYinFileName(this.name.getLocalName(), this.revision);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SourceIdentifier [").append(this.name.getLocalName());
        if (this.revision != null) {
            sb.append('@').append(this.revision);
        }
        return sb.append(']').toString();
    }

    public static @NonNull String toYangFileName(@NonNull String moduleName, @Nullable Revision revision) {
        return SourceIdentifier.toFileName(moduleName, revision, ".yang");
    }

    public static @NonNull String toYinFileName(@NonNull String moduleName, @Nullable Revision revision) {
        return SourceIdentifier.toFileName(moduleName, revision, ".yin");
    }

    private static @NonNull String toFileName(@NonNull String moduleName, @Nullable Revision revision, @NonNull String extension) {
        StringBuilder sb = new StringBuilder(moduleName);
        if (revision != null) {
            sb.append('@').append(revision);
        }
        return sb.append(extension).toString();
    }
}

