/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YinTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceTransformer;
import org.opendaylight.yangtools.yang.model.spi.source.YinDomSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.StatementSourceReferenceHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Beta
public final class YinTextToDomTransformer
extends SchemaSourceTransformer<YinTextSource, YinDomSource> {
    private YinTextToDomTransformer(SchemaRepository provider, SchemaSourceRegistry consumer) {
        super(provider, YinTextSource.class, consumer, YinDomSource.class, input -> Futures.immediateFuture((Object)YinTextToDomTransformer.transformSource(input)));
    }

    public static YinTextToDomTransformer create(SchemaRepository provider, SchemaSourceRegistry consumer) {
        return new YinTextToDomTransformer(provider, consumer);
    }

    public static YinDomSource transformSource(YinTextSource source) throws SAXException, IOException {
        Document doc = UntrustedXML.newDocumentBuilder().newDocument();
        SAXParser parser = UntrustedXML.newSAXParser();
        StatementSourceReferenceHandler handler = new StatementSourceReferenceHandler(doc, null);
        parser.parse(source.openStream(), (DefaultHandler)handler);
        return YinDomSource.create((SourceIdentifier)source.sourceId(), (DOMSource)new DOMSource(doc), (String)source.symbolicName());
    }
}

