/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.DeviateKind;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviateEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviateStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.YangValidationBundles;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDeviateStatementSupport
extends AbstractStatementSupport<DeviateKind, DeviateStatement, DeviateEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDeviateStatementSupport.class);
    private static final SubstatementValidator DEVIATE_NOT_SUPPORTED_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).build();
    private static final SubstatementValidator DEVIATE_ADD_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addAny((StatementDefinition)YangStmtMapping.MUST).addAny((StatementDefinition)YangStmtMapping.UNIQUE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    private static final SubstatementValidator DEVIATE_REPLACE_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    private static final SubstatementValidator DEVIATE_DELETE_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addAny((StatementDefinition)YangStmtMapping.MUST).addAny((StatementDefinition)YangStmtMapping.UNIQUE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    private static final ImmutableSet<YangStmtMapping> SINGLETON_STATEMENTS = ImmutableSet.of((Object)YangStmtMapping.UNITS, (Object)YangStmtMapping.CONFIG, (Object)YangStmtMapping.MANDATORY, (Object)YangStmtMapping.MIN_ELEMENTS, (Object)YangStmtMapping.MAX_ELEMENTS);
    private static final ImmutableSet<YangStmtMapping> IMPLICIT_STATEMENTS = ImmutableSet.of((Object)YangStmtMapping.CONFIG, (Object)YangStmtMapping.MANDATORY, (Object)YangStmtMapping.MAX_ELEMENTS, (Object)YangStmtMapping.MIN_ELEMENTS);

    AbstractDeviateStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.DEVIATE, StatementSupport.StatementPolicy.contextIndependent(), config, null);
    }

    public final DeviateKind parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return (DeviateKind)SourceException.throwIfNull((Object)DeviateKind.forArgument((String)value), ctx, (String)"String '%s' is not valid deviate argument", (Object[])new Object[]{value});
    }

    public final void onFullDefinitionDeclared(final StmtContext.Mutable<DeviateKind, DeviateStatement, DeviateEffectiveStatement> deviateStmtCtx) {
        final DeviateKind deviateKind = (DeviateKind)deviateStmtCtx.argument();
        this.getSubstatementValidatorForDeviate(deviateKind).validate(deviateStmtCtx);
        final SchemaNodeIdentifier deviationTarget = (SchemaNodeIdentifier)deviateStmtCtx.coerceParentContext().argument();
        if (!AbstractDeviateStatementSupport.isDeviationSupported(deviateStmtCtx, deviationTarget)) {
            return;
        }
        ModelActionBuilder deviateAction = deviateStmtCtx.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite sourceCtxPrerequisite = deviateAction.requiresCtx(deviateStmtCtx, ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite targetCtxPrerequisite = deviateAction.mutatesEffectiveCtxPath((StmtContext)deviateStmtCtx.getRoot(), ParserNamespaces.schemaTree(), (Iterable)deviationTarget.getNodeIdentifiers());
        deviateAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                if (!deviateStmtCtx.isSupportedToBuildEffective()) {
                    return;
                }
                StmtContext sourceNodeStmtCtx = (StmtContext)sourceCtxPrerequisite.resolve(ctx);
                StmtContext.Mutable targetNodeStmtCtx = (StmtContext.Mutable)targetCtxPrerequisite.resolve(ctx);
                switch (deviateKind) {
                    case NOT_SUPPORTED: {
                        targetNodeStmtCtx.setUnsupported();
                        break;
                    }
                    case ADD: {
                        AbstractDeviateStatementSupport.performDeviateAdd(sourceNodeStmtCtx, targetNodeStmtCtx);
                        break;
                    }
                    case REPLACE: {
                        AbstractDeviateStatementSupport.performDeviateReplace(sourceNodeStmtCtx, targetNodeStmtCtx);
                        break;
                    }
                    case DELETE: {
                        AbstractDeviateStatementSupport.performDeviateDelete(sourceNodeStmtCtx, targetNodeStmtCtx);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported deviate " + deviateKind);
                    }
                }
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                throw new InferenceException((CommonStmtCtx)deviateStmtCtx.coerceParentContext(), "Deviation target '%s' not found.", new Object[]{deviationTarget});
            }

            public void prerequisiteUnavailable(ModelActionBuilder.Prerequisite<?> unavail) {
                if (targetCtxPrerequisite.equals(unavail)) {
                    deviateStmtCtx.setUnsupported();
                } else {
                    this.prerequisiteFailed(List.of(unavail));
                }
            }
        });
    }

    public String internArgument(String rawArgument) {
        if ("add".equals(rawArgument)) {
            return "add";
        }
        if ("delete".equals(rawArgument)) {
            return "delete";
        }
        if ("replace".equals(rawArgument)) {
            return "replace";
        }
        if ("not-supported".equals(rawArgument)) {
            return "not-supported";
        }
        return rawArgument;
    }

    protected final DeviateStatement createDeclared(BoundStmtCtx<DeviateKind> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createDeviate((DeviateKind)((DeviateKind)ctx.getArgument()), substatements);
    }

    protected final DeviateStatement attachDeclarationReference(DeviateStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateDeviate((DeviateStatement)stmt, (DeclarationReference)reference);
    }

    protected final DeviateEffectiveStatement createEffective(EffectiveStmtCtx.Current<DeviateKind, DeviateStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createDeviate((DeviateStatement)((DeviateStatement)stmt.declared()), substatements);
    }

    protected SubstatementValidator getSubstatementValidatorForDeviate(DeviateKind deviateKind) {
        return switch (deviateKind) {
            default -> throw new IncompatibleClassChangeError();
            case DeviateKind.NOT_SUPPORTED -> DEVIATE_NOT_SUPPORTED_SUBSTATEMENT_VALIDATOR;
            case DeviateKind.ADD -> DEVIATE_ADD_SUBSTATEMENT_VALIDATOR;
            case DeviateKind.REPLACE -> DEVIATE_REPLACE_SUBSTATEMENT_VALIDATOR;
            case DeviateKind.DELETE -> DEVIATE_DELETE_SUBSTATEMENT_VALIDATOR;
        };
    }

    private static boolean isDeviationSupported(StmtContext.Mutable<DeviateKind, DeviateStatement, DeviateEffectiveStatement> deviateStmtCtx, SchemaNodeIdentifier deviationTarget) {
        SetMultimap modulesDeviatedByModules = (SetMultimap)deviateStmtCtx.namespaceItem(ParserNamespaces.MODULES_DEVIATED_BY, (Object)Empty.value());
        if (modulesDeviatedByModules == null) {
            return true;
        }
        QNameModule currentModule = (QNameModule)deviateStmtCtx.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, (Object)deviateStmtCtx.getRoot());
        QNameModule targetModule = ((QName)Iterables.getLast((Iterable)deviationTarget.getNodeIdentifiers())).getModule();
        Set deviationModulesSupportedByTargetModule = modulesDeviatedByModules.get((Object)targetModule);
        if (deviationModulesSupportedByTargetModule != null) {
            return deviationModulesSupportedByTargetModule.contains(currentModule);
        }
        return false;
    }

    private static void performDeviateAdd(StmtContext<?, ?, ?> deviateStmtCtx, StmtContext.Mutable<?, ?, ?> targetCtx) {
        for (StmtContext originalStmtCtx : deviateStmtCtx.declaredSubstatements()) {
            AbstractDeviateStatementSupport.validateDeviationTarget(originalStmtCtx, targetCtx);
            AbstractDeviateStatementSupport.addStatement(originalStmtCtx, targetCtx);
        }
    }

    private static void addStatement(StmtContext<?, ?, ?> stmtCtxToBeAdded, StmtContext.Mutable<?, ?, ?> targetCtx) {
        StatementDefinition stmtToBeAdded;
        if (!StmtContextUtils.isUnknownStatement(stmtCtxToBeAdded) && (SINGLETON_STATEMENTS.contains((Object)(stmtToBeAdded = stmtCtxToBeAdded.publicDefinition())) || YangStmtMapping.DEFAULT.equals((Object)stmtToBeAdded) && YangStmtMapping.LEAF.equals((Object)targetCtx.publicDefinition()))) {
            for (StmtContext targetCtxSubstatement : targetCtx.allSubstatements()) {
                InferenceException.throwIf((boolean)stmtToBeAdded.equals(targetCtxSubstatement.publicDefinition()), stmtCtxToBeAdded, (String)"Deviation cannot add substatement %s to target node %s because it is already defined in target and can appear only once.", (Object[])new Object[]{stmtToBeAdded.getStatementName(), targetCtx.argument()});
            }
        }
        AbstractDeviateStatementSupport.copyStatement(stmtCtxToBeAdded, targetCtx);
    }

    private static void performDeviateReplace(StmtContext<?, ?, ?> deviateStmtCtx, StmtContext.Mutable<?, ?, ?> targetCtx) {
        for (StmtContext originalStmtCtx : deviateStmtCtx.declaredSubstatements()) {
            AbstractDeviateStatementSupport.validateDeviationTarget(originalStmtCtx, targetCtx);
            AbstractDeviateStatementSupport.replaceStatement(originalStmtCtx, targetCtx);
        }
    }

    private static void replaceStatement(StmtContext<?, ?, ?> stmtCtxToBeReplaced, StmtContext.Mutable<?, ?, ?> targetCtx) {
        StatementDefinition stmtToBeReplaced = stmtCtxToBeReplaced.publicDefinition();
        if (YangStmtMapping.DEFAULT.equals((Object)stmtToBeReplaced) && YangStmtMapping.LEAF_LIST.equals((Object)targetCtx.publicDefinition())) {
            LOG.error("Deviation cannot replace substatement {} in target leaf-list {} because a leaf-list can have multiple default statements. At line: {}", new Object[]{stmtToBeReplaced.getStatementName(), targetCtx.argument(), stmtCtxToBeReplaced.sourceReference()});
            return;
        }
        for (StmtContext targetCtxSubstatement : targetCtx.effectiveSubstatements()) {
            if (!stmtToBeReplaced.equals(targetCtxSubstatement.publicDefinition())) continue;
            targetCtx.removeStatementFromEffectiveSubstatements(stmtToBeReplaced);
            AbstractDeviateStatementSupport.copyStatement(stmtCtxToBeReplaced, targetCtx);
            return;
        }
        for (StmtContext targetCtxSubstatement : targetCtx.mutableDeclaredSubstatements()) {
            if (!stmtToBeReplaced.equals(targetCtxSubstatement.publicDefinition())) continue;
            targetCtxSubstatement.setUnsupported();
            AbstractDeviateStatementSupport.copyStatement(stmtCtxToBeReplaced, targetCtx);
            return;
        }
        if (IMPLICIT_STATEMENTS.contains((Object)stmtToBeReplaced)) {
            AbstractDeviateStatementSupport.addStatement(stmtCtxToBeReplaced, targetCtx);
            return;
        }
        throw new InferenceException(stmtCtxToBeReplaced, "Deviation cannot replace substatement %s in target node %s because it does not exist in target node.", new Object[]{stmtToBeReplaced.getStatementName(), targetCtx.argument()});
    }

    private static void performDeviateDelete(StmtContext<?, ?, ?> deviateStmtCtx, StmtContext.Mutable<?, ?, ?> targetCtx) {
        for (StmtContext originalStmtCtx : deviateStmtCtx.declaredSubstatements()) {
            AbstractDeviateStatementSupport.validateDeviationTarget(originalStmtCtx, targetCtx);
            AbstractDeviateStatementSupport.deleteStatement(originalStmtCtx, targetCtx);
        }
    }

    private static void deleteStatement(StmtContext<?, ?, ?> stmtCtxToBeDeleted, StmtContext.Mutable<?, ?, ?> targetCtx) {
        StatementDefinition stmtToBeDeleted = stmtCtxToBeDeleted.publicDefinition();
        String stmtArgument = stmtCtxToBeDeleted.rawArgument();
        for (StmtContext.Mutable targetCtxSubstatement : targetCtx.mutableEffectiveSubstatements()) {
            if (!AbstractDeviateStatementSupport.statementsAreEqual(stmtToBeDeleted, stmtArgument, targetCtxSubstatement.publicDefinition(), targetCtxSubstatement.rawArgument())) continue;
            targetCtx.removeStatementFromEffectiveSubstatements(stmtToBeDeleted, stmtArgument);
            return;
        }
        for (StmtContext.Mutable targetCtxSubstatement : targetCtx.mutableDeclaredSubstatements()) {
            if (!AbstractDeviateStatementSupport.statementsAreEqual(stmtToBeDeleted, stmtArgument, targetCtxSubstatement.publicDefinition(), targetCtxSubstatement.rawArgument())) continue;
            targetCtxSubstatement.setUnsupported();
            return;
        }
        LOG.error("Deviation cannot delete substatement {} with argument '{}' in target node {} because it does not exist in the target node. At line: {}", new Object[]{stmtToBeDeleted.getStatementName(), stmtArgument, targetCtx.argument(), stmtCtxToBeDeleted.sourceReference()});
    }

    private static void copyStatement(StmtContext<?, ?, ?> stmtCtxToBeCopied, StmtContext.Mutable<?, ?, ?> targetCtx) {
        if (!StmtContextUtils.isUnknownStatement(stmtCtxToBeCopied)) {
            targetCtx.addEffectiveSubstatement(stmtCtxToBeCopied.replicaAsChildOf(targetCtx));
        } else {
            targetCtx.addEffectiveSubstatement(targetCtx.childCopyOf(stmtCtxToBeCopied, CopyType.ORIGINAL));
        }
    }

    private static boolean statementsAreEqual(StatementDefinition firstStmtDef, String firstStmtArg, StatementDefinition secondStmtDef, String secondStmtArg) {
        return firstStmtDef.equals(secondStmtDef) && Objects.equals(firstStmtArg, secondStmtArg);
    }

    private static void validateDeviationTarget(StmtContext<?, ?, ?> deviateSubStmtCtx, StmtContext<?, ?, ?> targetCtx) {
        InferenceException.throwIf((!AbstractDeviateStatementSupport.isSupportedDeviationTarget(deviateSubStmtCtx, targetCtx, targetCtx.yangVersion()) ? 1 : 0) != 0, deviateSubStmtCtx, (String)"%s is not a valid deviation target for substatement %s.", (Object[])new Object[]{targetCtx.argument(), deviateSubStmtCtx.publicDefinition().getStatementName()});
    }

    private static boolean isSupportedDeviationTarget(StmtContext<?, ?, ?> deviateSubstatementCtx, StmtContext<?, ?, ?> deviateTargetCtx, YangVersion yangVersion) {
        Set supportedDeviationTargets = (Set)YangValidationBundles.SUPPORTED_DEVIATION_TARGETS.get((Object)yangVersion, (Object)deviateSubstatementCtx.publicDefinition());
        if (supportedDeviationTargets == null) {
            supportedDeviationTargets = (Set)YangValidationBundles.SUPPORTED_DEVIATION_TARGETS.get((Object)YangVersion.VERSION_1, (Object)deviateSubstatementCtx.publicDefinition());
        }
        return supportedDeviationTargets == null || supportedDeviationTargets.contains(deviateTargetCtx.publicDefinition());
    }
}

