/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviate;

import com.google.common.annotations.Beta;
import org.opendaylight.yangtools.yang.model.api.DeviateKind;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviate.AbstractDeviateStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public final class DeviateStatementRFC7950Support
extends AbstractDeviateStatementSupport {
    private static final SubstatementValidator DEVIATE_ADD_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addAny((StatementDefinition)YangStmtMapping.MUST).addAny((StatementDefinition)YangStmtMapping.UNIQUE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    private static final SubstatementValidator DEVIATE_DELETE_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).addAny((StatementDefinition)YangStmtMapping.DEFAULT).addAny((StatementDefinition)YangStmtMapping.MUST).addAny((StatementDefinition)YangStmtMapping.UNIQUE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();

    public DeviateStatementRFC7950Support(YangParserConfiguration config) {
        super(config);
    }

    @Override
    protected SubstatementValidator getSubstatementValidatorForDeviate(DeviateKind deviateKind) {
        switch (deviateKind) {
            case NOT_SUPPORTED: {
                return super.getSubstatementValidatorForDeviate(deviateKind);
            }
            case ADD: {
                return DEVIATE_ADD_SUBSTATEMENT_VALIDATOR;
            }
            case REPLACE: {
                return super.getSubstatementValidatorForDeviate(deviateKind);
            }
            case DELETE: {
                return DEVIATE_DELETE_SUBSTATEMENT_VALIDATOR;
            }
        }
        throw new IllegalStateException(String.format("Substatement validator for deviate %s has not been defined.", deviateKind));
    }
}

