/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class FractionDigitsStatementSupport
extends AbstractStatementSupport<Integer, FractionDigitsStatement, FractionDigitsEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.FRACTION_DIGITS).build();
    private static final ImmutableMap<FractionDigitsStatement, FractionDigitsEffectiveStatement> EMPTY_EFF;

    public FractionDigitsStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.FRACTION_DIGITS, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public Integer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        int fractionDigits;
        try {
            fractionDigits = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException(ctx, (Throwable)e, "%s is not valid fraction-digits integer argument", new Object[]{value});
        }
        if (fractionDigits < 1 || fractionDigits > 18) {
            throw new SourceException("fraction-digits argument should be integer within [1..18]", ctx);
        }
        return fractionDigits;
    }

    protected FractionDigitsStatement createDeclared(BoundStmtCtx<Integer> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createFractionDigits((Integer)((Integer)ctx.getArgument()), substatements);
    }

    protected FractionDigitsStatement attachDeclarationReference(FractionDigitsStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateFractionDigits((FractionDigitsStatement)stmt, (DeclarationReference)reference);
    }

    protected FractionDigitsEffectiveStatement createEffective(EffectiveStmtCtx.Current<Integer, FractionDigitsStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return substatements.isEmpty() ? FractionDigitsStatementSupport.createEmptyEffective((FractionDigitsStatement)stmt.declared()) : EffectiveStatements.createFractionDigits((FractionDigitsStatement)((FractionDigitsStatement)stmt.declared()), substatements);
    }

    private static @NonNull FractionDigitsEffectiveStatement createEmptyEffective(FractionDigitsStatement declared) {
        FractionDigitsEffectiveStatement shared = (FractionDigitsEffectiveStatement)EMPTY_EFF.get((Object)declared);
        return shared != null ? shared : EffectiveStatements.createFractionDigits((FractionDigitsStatement)declared);
    }

    static {
        ImmutableMap.Builder effBuilder = ImmutableMap.builder();
        for (int i = 1; i <= 18; ++i) {
            FractionDigitsStatement decl = DeclaredStatements.createFractionDigits((int)i);
            effBuilder.put((Object)decl, (Object)EffectiveStatements.createFractionDigits((FractionDigitsStatement)decl));
        }
        EMPTY_EFF = effBuilder.build();
    }
}

