/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class NamespaceStatementSupport
extends AbstractStatementSupport<XMLNamespace, NamespaceStatement, NamespaceEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.NAMESPACE).build();

    public NamespaceStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.NAMESPACE, StatementSupport.StatementPolicy.reject(), config, SUBSTATEMENT_VALIDATOR);
    }

    public XMLNamespace parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return XMLNamespace.of((String)value).intern();
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx, (Throwable)e, "Invalid namespace \"%s\"", new Object[]{value});
        }
    }

    protected NamespaceStatement createDeclared(BoundStmtCtx<XMLNamespace> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createNamespace((XMLNamespace)((XMLNamespace)ctx.getArgument()), substatements);
    }

    protected NamespaceStatement attachDeclarationReference(NamespaceStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateNamespace((NamespaceStatement)stmt, (DeclarationReference)reference);
    }

    protected NamespaceEffectiveStatement createEffective(EffectiveStmtCtx.Current<XMLNamespace, NamespaceStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createNamespace((NamespaceStatement)((NamespaceStatement)stmt.declared()), substatements);
    }
}

