/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
public abstract class RefineStatementSupport
extends AbstractStatementSupport<SchemaNodeIdentifier.Descendant, RefineStatement, RefineEffectiveStatement> {
    private RefineStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.REFINE, StatementSupport.StatementPolicy.reject(), config, validator);
    }

    public static @NonNull RefineStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new Rfc6020(config);
    }

    public static @NonNull RefineStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new Rfc7950(config);
    }

    public final SchemaNodeIdentifier.Descendant parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return ArgumentUtils.parseDescendantSchemaNodeIdentifier(ctx, value);
    }

    protected final RefineStatement createDeclared(BoundStmtCtx<SchemaNodeIdentifier.Descendant> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createRefine((String)ctx.getRawArgument(), (SchemaNodeIdentifier.Descendant)((SchemaNodeIdentifier.Descendant)ctx.getArgument()), substatements);
    }

    protected final RefineStatement attachDeclarationReference(RefineStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateRefine((RefineStatement)stmt, (DeclarationReference)reference);
    }

    protected final RefineEffectiveStatement createEffective(EffectiveStmtCtx.Current<SchemaNodeIdentifier.Descendant, RefineStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createRefine((RefineStatement)((RefineStatement)stmt.declared()), substatements);
    }

    private static final class Rfc6020
    extends RefineStatementSupport {
        private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.REFINE).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.PRESENCE).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).build();

        Rfc6020(YangParserConfiguration config) {
            super(config, VALIDATOR);
        }
    }

    private static final class Rfc7950
    extends RefineStatementSupport {
        private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.REFINE).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.PRESENCE).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).build();

        Rfc7950(YangParserConfiguration config) {
            super(config, VALIDATOR);
        }

        public void onFullDefinitionDeclared(StmtContext.Mutable<SchemaNodeIdentifier.Descendant, RefineStatement, RefineEffectiveStatement> stmt) {
            super.onFullDefinitionDeclared(stmt);
            if (!StmtContextUtils.evaluateIfFeatures(stmt)) {
                stmt.setUnsupported();
            }
        }
    }
}

