/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Objects;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;

@Beta
public final class PotentialSchemaSource<T extends SourceRepresentation> {
    private static final Interner<PotentialSchemaSource<?>> INTERNER = Interners.newWeakInterner();
    private final Class<? extends T> representation;
    private final SourceIdentifier sourceIdentifier;
    private final int cost;

    private PotentialSchemaSource(SourceIdentifier sourceIdentifier, Class<? extends T> representation, int cost) {
        this.representation = Objects.requireNonNull(representation);
        this.sourceIdentifier = Objects.requireNonNull(sourceIdentifier);
        Preconditions.checkArgument((cost >= 0 ? 1 : 0) != 0, (Object)"cost has to be non-negative");
        this.cost = cost;
    }

    public static <T extends SourceRepresentation> PotentialSchemaSource<T> create(SourceIdentifier sourceId, Class<? extends T> representation, int cost) {
        return new PotentialSchemaSource<T>(sourceId, representation, cost);
    }

    public static <T extends SourceRepresentation> PotentialSchemaSource<T> create(SourceIdentifier sourceId, Class<? extends T> representation, Costs cost) {
        return new PotentialSchemaSource<T>(sourceId, representation, cost.getValue());
    }

    public PotentialSchemaSource<T> cachedReference() {
        return (PotentialSchemaSource)INTERNER.intern((Object)this);
    }

    public SourceIdentifier getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public Class<? extends T> getRepresentation() {
        return this.representation;
    }

    public int getCost() {
        return this.cost;
    }

    public int hashCode() {
        return Objects.hash(this.cost, this.representation, this.sourceIdentifier);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof PotentialSchemaSource)) return false;
        PotentialSchemaSource other = (PotentialSchemaSource)obj;
        if (this.cost != other.cost) return false;
        if (!this.representation.equals(other.representation)) return false;
        if (!this.sourceIdentifier.equals((Object)other.sourceIdentifier)) return false;
        return true;
    }

    public static enum Costs {
        IMMEDIATE(0),
        COMPUTATION(1),
        LOCAL_IO(4),
        REMOTE_IO(8);

        private final int value;

        private Costs(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

