/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.DeclaresType;
import org.openrewrite.java.service.ImportService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;

public final class AddMethodParameter
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find the method declarations to modify.", example="com.yourorg.A foo(int, int)")
    private final String methodPattern;
    @Option(displayName="Parameter type", description="The type of the parameter that gets added.", example="java.lang.String")
    private final String parameterType;
    @Option(displayName="Parameter name", description="The name of the parameter that gets added.", example="name")
    private final String parameterName;
    @Option(displayName="Parameter index", description="A zero-based index that indicates the position at which the parameter will be added. At the end by default.", example="0", required=false)
    private final @Nullable Integer parameterIndex;

    public String getInstanceNameSuffix() {
        return String.format("`%s %s` in methods `%s`", this.parameterType, this.parameterName, this.methodPattern);
    }

    public String getDisplayName() {
        return "Add method parameter to a method declaration";
    }

    public String getDescription() {
        return "Adds a new method parameter to an existing method declaration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        int idx = this.methodPattern.indexOf(35);
        idx = idx == -1 ? this.methodPattern.indexOf(32) : idx;
        boolean typePattern = idx != -1 && this.methodPattern.lastIndexOf(42, idx) != -1;
        return Preconditions.check((TreeVisitor)(typePattern ? new DeclaresMatchingType(this.methodPattern.substring(0, idx)) : new DeclaresType(this.methodPattern.substring(0, idx))), (TreeVisitor)new AddNullMethodArgumentVisitor(this.methodPattern));
    }

    @Generated
    public AddMethodParameter(String methodPattern, String parameterType, String parameterName, @Nullable Integer parameterIndex) {
        this.methodPattern = methodPattern;
        this.parameterType = parameterType;
        this.parameterName = parameterName;
        this.parameterIndex = parameterIndex;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public String getParameterType() {
        return this.parameterType;
    }

    @Generated
    public String getParameterName() {
        return this.parameterName;
    }

    @Generated
    public @Nullable Integer getParameterIndex() {
        return this.parameterIndex;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddMethodParameter(methodPattern=" + this.getMethodPattern() + ", parameterType=" + this.getParameterType() + ", parameterName=" + this.getParameterName() + ", parameterIndex=" + this.getParameterIndex() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMethodParameter)) {
            return false;
        }
        AddMethodParameter other = (AddMethodParameter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$parameterIndex = this.getParameterIndex();
        Integer other$parameterIndex = other.getParameterIndex();
        if (this$parameterIndex == null ? other$parameterIndex != null : !((Object)this$parameterIndex).equals(other$parameterIndex)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$parameterType = this.getParameterType();
        String other$parameterType = other.getParameterType();
        if (this$parameterType == null ? other$parameterType != null : !this$parameterType.equals(other$parameterType)) {
            return false;
        }
        String this$parameterName = this.getParameterName();
        String other$parameterName = other.getParameterName();
        return !(this$parameterName == null ? other$parameterName != null : !this$parameterName.equals(other$parameterName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddMethodParameter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $parameterIndex = this.getParameterIndex();
        result = result * 59 + ($parameterIndex == null ? 43 : ((Object)$parameterIndex).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $parameterType = this.getParameterType();
        result = result * 59 + ($parameterType == null ? 43 : $parameterType.hashCode());
        String $parameterName = this.getParameterName();
        result = result * 59 + ($parameterName == null ? 43 : $parameterName.hashCode());
        return result;
    }

    private static class DeclaresMatchingType
    extends JavaIsoVisitor<ExecutionContext> {
        private final TypeMatcher typeMatcher;

        public DeclaresMatchingType(String type) {
            this.typeMatcher = new TypeMatcher(type);
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            if (classDecl.getType() != null && this.typeMatcher.matches(classDecl.getType())) {
                return (J.ClassDeclaration)SearchResult.found((Tree)classDecl);
            }
            return super.visitClassDeclaration(classDecl, ctx);
        }
    }

    private class AddNullMethodArgumentVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        public AddNullMethodArgumentVisitor(String methodPattern) {
            this.methodMatcher = new MethodMatcher(methodPattern);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            method = super.visitMethodDeclaration((J.MethodDeclaration)method, ctx);
            J.ClassDeclaration enclosing = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
            if (enclosing != null && this.methodMatcher.matches((J.MethodDeclaration)method, enclosing)) {
                for (Statement parameter : ((J.MethodDeclaration)method).getParameters()) {
                    if (!(parameter instanceof J.VariableDeclarations) || !((J.VariableDeclarations)parameter).getVariables().get(0).getSimpleName().equals(AddMethodParameter.this.parameterName)) continue;
                    return method;
                }
                J.VariableDeclarations parameter = this.createParameter((J.MethodDeclaration)method);
                method = this.autoFormat(this.addParameter((J.MethodDeclaration)method, parameter), parameter, ctx, this.getCursor().getParentTreeCursor());
            }
            return method;
        }

        private J.MethodDeclaration addParameter(J.MethodDeclaration method, J.VariableDeclarations parameter) {
            List originalParameters = method.getParameters();
            if (method.getParameters().isEmpty() || method.getParameters().size() == 1 && method.getParameters().get(0) instanceof J.Empty) {
                originalParameters = new ArrayList<Statement>();
            } else if (AddMethodParameter.this.parameterIndex == null || AddMethodParameter.this.parameterIndex != 0) {
                parameter = parameter.withPrefix(Space.SINGLE_SPACE);
            } else {
                originalParameters = ListUtils.mapFirst(originalParameters, p -> p.getPrefix().isEmpty() ? (Statement)p.withPrefix(Space.SINGLE_SPACE) : p);
            }
            method = AddMethodParameter.this.parameterIndex == null ? method.withParameters(ListUtils.concat(originalParameters, (Object)parameter)) : method.withParameters(ListUtils.insert(originalParameters, (Object)parameter, (int)AddMethodParameter.this.parameterIndex));
            if (parameter.getTypeExpression() != null && !(parameter.getTypeExpression() instanceof J.Identifier) && !(parameter.getTypeExpression() instanceof J.Primitive)) {
                this.doAfterVisit(this.service(ImportService.class).shortenFullyQualifiedTypeReferencesIn(parameter.getTypeExpression()));
            }
            return method;
        }

        private J.VariableDeclarations createParameter(J.MethodDeclaration method) {
            TypeTree typeTree = this.createTypeTree(AddMethodParameter.this.parameterType);
            return new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), typeTree, null, Collections.singletonList(new JRightPadded<J.VariableDeclarations.NamedVariable>(new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), AddMethodParameter.this.parameterName, typeTree.getType(), new JavaType.Variable(null, 0L, AddMethodParameter.this.parameterName, (JavaType)method.getMethodType(), typeTree.getType(), null)), Collections.emptyList(), null, null), Space.EMPTY, Markers.EMPTY)));
        }

        private TypeTree createTypeTree(String typeName) {
            String javaLangType;
            int arrayIndex = typeName.lastIndexOf(91);
            if (arrayIndex != -1) {
                TypeTree elementType = this.createTypeTree(typeName.substring(0, arrayIndex));
                return new J.ArrayType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, elementType, null, JLeftPadded.build(Space.EMPTY), new JavaType.Array(null, elementType.getType(), null));
            }
            int genericsIndex = typeName.indexOf(60);
            if (genericsIndex != -1) {
                TypeTree rawType = this.createTypeTree(typeName.substring(0, genericsIndex));
                ArrayList typeParameters = new ArrayList();
                for (String typeParam : typeName.substring(genericsIndex + 1, typeName.lastIndexOf(62)).split(",")) {
                    typeParameters.add(JRightPadded.build((Expression)((Object)this.createTypeTree(typeParam.trim()))));
                }
                return new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, rawType, JContainer.build(Space.EMPTY, typeParameters, Markers.EMPTY), new JavaType.Parameterized(null, (JavaType.FullyQualified)rawType.getType(), null));
            }
            JavaType.Primitive type = JavaType.Primitive.fromKeyword(typeName);
            if (type != null) {
                return new J.Primitive(Tree.randomId(), Space.EMPTY, Markers.EMPTY, type);
            }
            if ("?".equals(typeName)) {
                return new J.Wildcard(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, null);
            }
            if (typeName.startsWith("?") && typeName.contains("extends")) {
                return new J.Wildcard(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JLeftPadded<J.Wildcard.Bound>(Space.SINGLE_SPACE, J.Wildcard.Bound.Extends, Markers.EMPTY), (NameTree)this.createTypeTree(typeName.substring(typeName.indexOf("extends") + "extends".length() + 1).trim()).withPrefix(Space.SINGLE_SPACE));
            }
            if (typeName.indexOf(46) == -1 && (javaLangType = TypeUtils.findQualifiedJavaLangTypeName(typeName)) != null) {
                return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), typeName, JavaType.buildType(javaLangType), null);
            }
            Object typeTree = TypeTree.build(typeName);
            if (typeTree instanceof J.FieldAccess) {
                typeTree = ((J.FieldAccess)typeTree).withName(((J.FieldAccess)typeTree).getName().withType(typeTree.getType()));
            } else if (typeTree.getType() == null) {
                typeTree = ((J.Identifier)typeTree).withType(JavaType.ShallowClass.build(typeName));
            }
            return typeTree;
        }
    }
}

