/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.Style;

public class TabsAndIndents
extends Recipe {
    public String getDisplayName() {
        return "Tabs and indents";
    }

    public String getDescription() {
        return "Format tabs and indents in Java code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TabsAndIndentsFromCompilationUnitStyle();
    }

    public static <J2 extends J> J2 formatTabsAndIndents(J j, Cursor cursor) {
        SourceFile cu = (SourceFile)cursor.firstEnclosingOrThrow(SourceFile.class);
        TabsAndIndentsStyle style = (TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents);
        SpacesStyle spacesStyle = Optional.ofNullable((SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cu)).orElse(IntelliJ.spaces());
        return (J2)((J)new TabsAndIndentsVisitor(style, spacesStyle).visitNonNull(j, 0, cursor));
    }

    private static class TabsAndIndentsFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private TabsAndIndentsFromCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                TabsAndIndentsStyle style = (TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents);
                SpacesStyle spacesStyle = Optional.ofNullable((SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cu)).orElse(IntelliJ.spaces());
                return new TabsAndIndentsVisitor(style, spacesStyle).visit(tree, ctx);
            }
            return (J)tree;
        }
    }
}

