/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.imports;

import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.checks.imports.AbstractImportControl;
import org.openrewrite.tools.checkstyle.checks.imports.MismatchStrategy;
import org.openrewrite.tools.checkstyle.checks.imports.PkgImportControl;

class FileImportControl
extends AbstractImportControl {
    private final String name;
    private final Pattern patternForExactMatch;
    private final boolean regex;

    FileImportControl(PkgImportControl parent, String name, boolean regex) {
        super(parent, MismatchStrategy.DELEGATE_TO_PARENT);
        this.regex = regex;
        if (regex) {
            this.name = FileImportControl.encloseInGroup(name);
            this.patternForExactMatch = FileImportControl.createPatternForExactMatch(this.name);
        } else {
            this.name = name;
            this.patternForExactMatch = null;
        }
    }

    private static String encloseInGroup(String expression) {
        return "(?:" + expression + ")";
    }

    private static Pattern createPatternForExactMatch(String expression) {
        return Pattern.compile(expression);
    }

    @Override
    public AbstractImportControl locateFinest(String forPkg, String forFileName) {
        FileImportControl finestMatch = null;
        if (this.matchesExactly(forPkg, forFileName)) {
            finestMatch = this;
        }
        return finestMatch;
    }

    @Override
    protected boolean matchesExactly(String pkg, String fileName) {
        boolean result = fileName == null ? false : (this.regex ? this.patternForExactMatch.matcher(fileName).matches() : this.name.equals(fileName));
        return result;
    }
}

