/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.differ;

import de.danielbechler.diff.access.Instances;
import de.danielbechler.diff.comparison.PrimitiveDefaultValueMode;
import de.danielbechler.diff.comparison.PrimitiveDefaultValueModeResolver;
import de.danielbechler.diff.differ.Differ;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Classes;

public final class PrimitiveDiffer
implements Differ {
    private final PrimitiveDefaultValueModeResolver primitiveDefaultValueModeResolver;

    public PrimitiveDiffer(PrimitiveDefaultValueModeResolver primitiveDefaultValueModeResolver) {
        Assert.notNull(primitiveDefaultValueModeResolver, "primitiveDefaultValueModeResolver");
        this.primitiveDefaultValueModeResolver = primitiveDefaultValueModeResolver;
    }

    @Override
    public boolean accepts(Class<?> type) {
        return Classes.isPrimitiveType(type);
    }

    @Override
    public final DiffNode compare(DiffNode parentNode, Instances instances) {
        if (!this.accepts(instances.getType())) {
            throw new IllegalArgumentException("The primitive differ can only deal with primitive types.");
        }
        DiffNode node = new DiffNode(parentNode, instances.getSourceAccessor(), instances.getType());
        if (this.shouldTreatPrimitiveDefaultsAsUnassigned(node) && instances.hasBeenAdded()) {
            node.setState(DiffNode.State.ADDED);
        } else if (this.shouldTreatPrimitiveDefaultsAsUnassigned(node) && instances.hasBeenRemoved()) {
            node.setState(DiffNode.State.REMOVED);
        } else if (!instances.areEqual()) {
            node.setState(DiffNode.State.CHANGED);
        }
        return node;
    }

    private boolean shouldTreatPrimitiveDefaultsAsUnassigned(DiffNode node) {
        return this.primitiveDefaultValueModeResolver.resolvePrimitiveDefaultValueMode(node) == PrimitiveDefaultValueMode.UNASSIGNED;
    }
}

