/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.internal.revwalk;

import org.openrewrite.jgit.lib.BitmapIndex;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevFlag;
import org.openrewrite.jgit.revwalk.RevWalk;
import org.openrewrite.jgit.revwalk.filter.RevFilter;

public class AddToBitmapFilter
extends RevFilter {
    private final BitmapIndex.BitmapBuilder bitmap;

    public AddToBitmapFilter(BitmapIndex.BitmapBuilder bitmap) {
        this.bitmap = bitmap;
    }

    @Override
    public final boolean include(RevWalk walker, RevCommit cmit) {
        if (!this.bitmap.contains(cmit)) {
            BitmapIndex.Bitmap visitedBitmap = this.bitmap.getBitmapIndex().getBitmap(cmit);
            if (visitedBitmap != null) {
                this.bitmap.or(visitedBitmap);
            } else {
                this.bitmap.addObject(cmit, 1);
                return true;
            }
        }
        for (RevCommit p : cmit.getParents()) {
            p.add(RevFlag.SEEN);
        }
        return false;
    }

    @Override
    public final RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean requiresCommitBody() {
        return false;
    }
}

