/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.ops4j.pax.url.mvn.internal.ConfigurableSettingsDecrypter;
import org.ops4j.pax.url.mvn.internal.ManualWagonProvider;
import org.ops4j.pax.url.mvn.internal.PaxUrlSecDispatcher;
import org.ops4j.pax.url.mvn.internal.config.MavenConfiguration;
import org.ops4j.pax.url.mvn.internal.config.MavenRepositoryURL;
import org.slf4j.Logger;
import shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import shaded.org.apache.maven.settings.Mirror;
import shaded.org.apache.maven.settings.Server;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import shaded.org.apache.maven.settings.crypto.SettingsDecrypter;
import shaded.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import shaded.org.eclipse.aether.RepositoryException;
import shaded.org.eclipse.aether.RepositorySystem;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.artifact.DefaultArtifact;
import shaded.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import shaded.org.eclipse.aether.impl.DefaultServiceLocator;
import shaded.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.internal.impl.Slf4jLoggerFactory;
import shaded.org.eclipse.aether.repository.Authentication;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.MirrorSelector;
import shaded.org.eclipse.aether.repository.Proxy;
import shaded.org.eclipse.aether.repository.ProxySelector;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.repository.RepositoryPolicy;
import shaded.org.eclipse.aether.resolution.ArtifactRequest;
import shaded.org.eclipse.aether.resolution.ArtifactResolutionException;
import shaded.org.eclipse.aether.resolution.VersionRangeRequest;
import shaded.org.eclipse.aether.resolution.VersionRangeResolutionException;
import shaded.org.eclipse.aether.resolution.VersionRangeResult;
import shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import shaded.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.spi.log.LoggerFactory;
import shaded.org.eclipse.aether.transport.wagon.WagonProvider;
import shaded.org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import shaded.org.eclipse.aether.util.repository.AuthenticationBuilder;
import shaded.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import shaded.org.eclipse.aether.util.repository.DefaultProxySelector;
import shaded.org.eclipse.aether.util.version.GenericVersionScheme;
import shaded.org.eclipse.aether.version.InvalidVersionSpecificationException;
import shaded.org.eclipse.aether.version.Version;
import shaded.org.eclipse.aether.version.VersionConstraint;
import shaded.org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import shaded.org.sonatype.plexus.components.cipher.PlexusCipherException;

public class AetherBasedResolver {
    private static final Logger LOG = org.slf4j.LoggerFactory.getLogger(AetherBasedResolver.class);
    private static final String LATEST_VERSION_RANGE = "(0.0,]";
    private static final String REPO_TYPE = "default";
    private final RepositorySystem m_repoSystem;
    private final MavenConfiguration m_config;
    private final MirrorSelector m_mirrorSelector;
    private final ProxySelector m_proxySelector;
    private Settings m_settings;
    private ConfigurableSettingsDecrypter decrypter;

    public AetherBasedResolver(MavenConfiguration configuration) throws MalformedURLException {
        this.m_config = configuration;
        this.m_settings = configuration.getSettings();
        this.m_repoSystem = this.newRepositorySystem();
        this.decryptSettings();
        this.m_proxySelector = this.selectProxies();
        this.m_mirrorSelector = this.selectMirrors();
    }

    private void decryptSettings() {
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(this.m_settings);
        SettingsDecryptionResult result = this.decrypter.decrypt(request);
        this.m_settings.setProxies(result.getProxies());
        this.m_settings.setServers(result.getServers());
    }

    private void assignProxyAndMirrors(List<RemoteRepository> remoteRepos) {
        HashMap map = new HashMap();
        HashMap<String, RemoteRepository> naming = new HashMap<String, RemoteRepository>();
        ArrayList<RemoteRepository> resultingRepos = new ArrayList<RemoteRepository>();
        for (RemoteRepository r : remoteRepos) {
            naming.put(r.getId(), r);
            RemoteRepository rProxy = new RemoteRepository.Builder(r).setProxy(this.m_proxySelector.getProxy(r)).build();
            resultingRepos.add(rProxy);
            RemoteRepository mirror = this.m_mirrorSelector.getMirror(r);
            if (mirror == null) continue;
            String key = mirror.getId();
            naming.put(key, mirror);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            List mirrored = (List)map.get(key);
            mirrored.add(r.getId());
        }
        for (String mirrorId : map.keySet()) {
            RemoteRepository mirror = (RemoteRepository)naming.get(mirrorId);
            ArrayList<RemoteRepository> mirroredRepos = new ArrayList<RemoteRepository>();
            for (String rep : (List)map.get(mirrorId)) {
                mirroredRepos.add((RemoteRepository)naming.get(rep));
            }
            mirror = new RemoteRepository.Builder(mirror).setMirroredRepositories(mirroredRepos).build();
            resultingRepos.removeAll(mirroredRepos);
            resultingRepos.add(0, mirror);
        }
        remoteRepos.clear();
        remoteRepos.addAll(resultingRepos);
    }

    private ProxySelector selectProxies() {
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (shaded.org.apache.maven.settings.Proxy proxy : this.m_settings.getProxies()) {
            String nonProxyHosts = proxy.getNonProxyHosts();
            Proxy proxyObj = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), this.getAuthentication(proxy));
            proxySelector.add(proxyObj, nonProxyHosts);
        }
        return proxySelector;
    }

    private MirrorSelector selectMirrors() {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror mirror : this.m_settings.getMirrors()) {
            selector.add(mirror.getName(), mirror.getUrl(), null, false, mirror.getMirrorOf(), "*");
        }
        return selector;
    }

    private List<RemoteRepository> selectRepositories() {
        ArrayList<RemoteRepository> list = new ArrayList<RemoteRepository>();
        List<Object> urls = Collections.emptyList();
        try {
            urls = this.m_config.getRepositories();
        }
        catch (MalformedURLException exc) {
            LOG.error("invalid repository URLs", (Throwable)exc);
        }
        for (MavenRepositoryURL mavenRepositoryURL : urls) {
            if (mavenRepositoryURL.isMulti()) {
                this.addSubDirs(list, mavenRepositoryURL.getFile());
                continue;
            }
            this.addRepo(list, mavenRepositoryURL);
        }
        return list;
    }

    List<LocalRepository> selectDefaultRepositories() {
        ArrayList<LocalRepository> list = new ArrayList<LocalRepository>();
        List<Object> urls = Collections.emptyList();
        try {
            urls = this.m_config.getDefaultRepositories();
        }
        catch (MalformedURLException exc) {
            LOG.error("invalid repository URLs", (Throwable)exc);
        }
        for (MavenRepositoryURL mavenRepositoryURL : urls) {
            if (mavenRepositoryURL.isMulti()) {
                this.addLocalSubDirs(list, mavenRepositoryURL.getFile());
                continue;
            }
            this.addLocalRepo(list, mavenRepositoryURL);
        }
        return list;
    }

    private void addSubDirs(List<RemoteRepository> list, File parentDir) {
        if (!parentDir.isDirectory()) {
            LOG.debug("Repository marked with @multi does not resolve to a directory: " + parentDir);
            return;
        }
        for (File repo : parentDir.listFiles()) {
            if (!repo.isDirectory()) continue;
            try {
                String repoURI = repo.toURI().toString() + "@id=" + repo.getName();
                LOG.debug("Adding repo from inside multi dir: " + repoURI);
                this.addRepo(list, new MavenRepositoryURL(repoURI));
            }
            catch (MalformedURLException e) {
                LOG.error("Error resolving repo url of a multi repo " + repo.toURI());
            }
        }
    }

    private void addRepo(List<RemoteRepository> list, MavenRepositoryURL repo) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getId(), REPO_TYPE, repo.getURL().toExternalForm());
        RepositoryPolicy releasePolicy = new RepositoryPolicy(repo.isReleasesEnabled(), "daily", null);
        builder.setReleasePolicy(releasePolicy);
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy(repo.isSnapshotsEnabled(), "daily", null);
        builder.setSnapshotPolicy(snapshotPolicy);
        Authentication authentication = this.getAuthentication(repo.getId());
        if (authentication != null) {
            builder.setAuthentication(authentication);
        }
        list.add(builder.build());
    }

    private void addLocalSubDirs(List<LocalRepository> list, File parentDir) {
        if (!parentDir.isDirectory()) {
            LOG.debug("Repository marked with @multi does not resolve to a directory: " + parentDir);
            return;
        }
        for (File repo : parentDir.listFiles()) {
            if (!repo.isDirectory()) continue;
            try {
                String repoURI = repo.toURI().toString() + "@id=" + repo.getName();
                LOG.debug("Adding repo from inside multi dir: " + repoURI);
                this.addLocalRepo(list, new MavenRepositoryURL(repoURI));
            }
            catch (MalformedURLException e) {
                LOG.error("Error resolving repo url of a multi repo " + repo.toURI());
            }
        }
    }

    private void addLocalRepo(List<LocalRepository> list, MavenRepositoryURL repo) {
        if (repo.getFile() != null) {
            LocalRepository local = new LocalRepository(repo.getFile(), "simple");
            list.add(local);
        }
    }

    public InputStream resolve(String groupId, String artifactId, String classifier, String extension, String version) throws IOException {
        File resolved = this.resolveFile(groupId, artifactId, classifier, extension, version);
        return new FileInputStream(resolved);
    }

    public File resolveFile(String groupId, String artifactId, String classifier, String extension, String version) throws IOException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        List<LocalRepository> defaultRepos = this.selectDefaultRepositories();
        List<RemoteRepository> remoteRepos = this.selectRepositories();
        this.assignProxyAndMirrors(remoteRepos);
        File resolved = this.resolve(defaultRepos, remoteRepos, artifact);
        LOG.debug("Resolved ({}) as {}", (Object)((Object)artifact).toString(), (Object)resolved.getAbsolutePath());
        return resolved;
    }

    private File resolve(List<LocalRepository> defaultRepos, List<RemoteRepository> remoteRepos, Artifact artifact) throws IOException {
        try {
            VersionConstraint vc = new GenericVersionScheme().parseVersionConstraint(artifact.getVersion());
            if (vc.getVersion() != null) {
                for (LocalRepository repo : defaultRepos) {
                    RepositorySystemSession session = this.newSession(repo);
                    try {
                        return this.m_repoSystem.resolveArtifact(session, new ArtifactRequest(artifact, null, null)).getArtifact().getFile();
                    }
                    catch (ArtifactResolutionException e) {
                    }
                }
            }
        }
        catch (InvalidVersionSpecificationException e) {
            // empty catch block
        }
        try {
            RepositorySystemSession session = this.newSession(null);
            artifact = this.resolveLatestVersionRange(session, remoteRepos, artifact);
            return this.m_repoSystem.resolveArtifact(session, new ArtifactRequest(artifact, remoteRepos, null)).getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            LOG.warn("Error resolving artifact" + artifact.toString() + ":" + e.getMessage(), (Throwable)e);
            throw new IOException("Error resolving artifact " + artifact.toString() + ": " + e.getMessage());
        }
        catch (RepositoryException e) {
            throw new IOException("Error resolving artifact " + artifact.toString(), e);
        }
    }

    private Artifact resolveLatestVersionRange(RepositorySystemSession session, List<RemoteRepository> remoteRepos, Artifact artifact) throws VersionRangeResolutionException {
        VersionRangeResult versionResult;
        if (artifact.getVersion().equals("LATEST")) {
            artifact = artifact.setVersion(LATEST_VERSION_RANGE);
        }
        if ((versionResult = this.m_repoSystem.resolveVersionRange(session, new VersionRangeRequest(artifact, remoteRepos, null))) != null) {
            Version v = versionResult.getHighestVersion();
            if (v != null) {
                artifact = artifact.setVersion(v.toString());
            } else {
                throw new VersionRangeResolutionException(versionResult, "No highest version found for " + artifact);
            }
        }
        return artifact;
    }

    private RepositorySystemSession newSession(LocalRepository repo) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        if (repo != null) {
            session.setLocalRepositoryManager(this.m_repoSystem.newLocalRepositoryManager(session, repo));
        } else {
            File local = this.m_config.getLocalRepository() != null ? this.m_config.getLocalRepository().getFile() : new File(System.getProperty("user.home"), ".m2/repository");
            LocalRepository localRepo = new LocalRepository(local);
            session.setLocalRepositoryManager(this.m_repoSystem.newLocalRepositoryManager(session, localRepo));
        }
        session.setMirrorSelector(this.m_mirrorSelector);
        session.setProxySelector(this.m_proxySelector);
        String updatePolicy = this.m_config.getGlobalUpdatePolicy();
        if (null != updatePolicy) {
            session.setUpdatePolicy(updatePolicy);
        }
        for (Server server : this.m_settings.getServers()) {
            if (server.getConfiguration() == null) continue;
            this.addServerConfig(session, server);
        }
        return session;
    }

    private void addServerConfig(DefaultRepositorySystemSession session, Server server) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        Xpp3Dom httpHeaders = configuration.getChild("httpHeaders");
        for (Xpp3Dom httpHeader : httpHeaders.getChildren("httpHeader")) {
            Xpp3Dom name = httpHeader.getChild("name");
            String headerName = name.getValue();
            Xpp3Dom value = httpHeader.getChild("value");
            String headerValue = value.getValue();
            headers.put(headerName, headerValue);
        }
        session.setConfigProperty(String.format("%s.%s", "aether.connector.http.headers", server.getId()), headers);
    }

    private Authentication getAuthentication(shaded.org.apache.maven.settings.Proxy proxy) {
        if (proxy.getUsername() != null) {
            return new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return null;
    }

    private Authentication getAuthentication(String repoId) {
        Server server = this.m_settings.getServer(repoId);
        if (server != null && server.getUsername() != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            return authBuilder.build();
        }
        return null;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.setServices(WagonProvider.class, new ManualWagonProvider(this.m_config.getTimeout()));
        locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        this.decrypter = new ConfigurableSettingsDecrypter();
        PaxUrlSecDispatcher secDispatcher = new PaxUrlSecDispatcher();
        try {
            secDispatcher.setCipher(new DefaultPlexusCipher());
        }
        catch (PlexusCipherException exc) {
            throw new IllegalStateException(exc);
        }
        secDispatcher.setConfigurationFile(this.m_config.getSecuritySettings());
        this.decrypter.setSecurityDispatcher(secDispatcher);
        locator.setServices(SettingsDecrypter.class, this.decrypter);
        locator.setService(LocalRepositoryManagerFactory.class, SimpleLocalRepositoryManagerFactory.class);
        locator.setService(LoggerFactory.class, Slf4jLoggerFactory.class);
        return locator.getService(RepositorySystem.class);
    }
}

