/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.model.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import shaded.org.apache.maven.model.Model;
import shaded.org.apache.maven.model.io.ModelWriter;
import shaded.org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import shaded.org.codehaus.plexus.component.annotations.Component;
import shaded.org.codehaus.plexus.util.IOUtil;
import shaded.org.codehaus.plexus.util.WriterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelWriter.class)
public class DefaultModelWriter
implements ModelWriter {
    @Override
    public void write(File output, Map<String, Object> options, Model model) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output file missing");
        }
        if (model == null) {
            throw new IllegalArgumentException("model missing");
        }
        output.getParentFile().mkdirs();
        this.write(WriterFactory.newXmlWriter(output), options, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer output, Map<String, Object> options, Model model) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output writer missing");
        }
        if (model == null) {
            throw new IllegalArgumentException("model missing");
        }
        try {
            MavenXpp3Writer w = new MavenXpp3Writer();
            w.write(output, model);
        }
        finally {
            IOUtil.close(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream output, Map<String, Object> options, Model model) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output stream missing");
        }
        if (model == null) {
            throw new IllegalArgumentException("model missing");
        }
        try {
            String encoding = model.getModelEncoding();
            if (encoding == null || encoding.length() <= 0) {
                encoding = "UTF-8";
            }
            this.write(new OutputStreamWriter(output, encoding), options, model);
        }
        finally {
            IOUtil.close(output);
        }
    }
}

