/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.model.plugin;

import java.util.List;
import shaded.org.apache.maven.model.Build;
import shaded.org.apache.maven.model.Model;
import shaded.org.apache.maven.model.Plugin;
import shaded.org.apache.maven.model.PluginExecution;
import shaded.org.apache.maven.model.PluginManagement;
import shaded.org.apache.maven.model.building.ModelBuildingRequest;
import shaded.org.apache.maven.model.building.ModelProblemCollector;
import shaded.org.apache.maven.model.plugin.PluginConfigurationExpander;
import shaded.org.codehaus.plexus.component.annotations.Component;
import shaded.org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginConfigurationExpander.class)
public class DefaultPluginConfigurationExpander
implements PluginConfigurationExpander {
    @Override
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Build build = model.getBuild();
        if (build != null) {
            this.expand(build.getPlugins());
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement != null) {
                this.expand(pluginManagement.getPlugins());
            }
        }
    }

    private void expand(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
            if (pluginConfiguration == null) continue;
            for (PluginExecution execution : plugin.getExecutions()) {
                Xpp3Dom executionConfiguration = (Xpp3Dom)execution.getConfiguration();
                executionConfiguration = Xpp3Dom.mergeXpp3Dom(executionConfiguration, new Xpp3Dom(pluginConfiguration));
                execution.setConfiguration(executionConfiguration);
            }
        }
    }
}

