/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import shaded.org.codehaus.plexus.util.xml.XMLWriter;
import shaded.org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class SerializerXMLWriter
implements XMLWriter {
    private final XmlSerializer serializer;
    private final String namespace;
    private final Stack elements = new Stack();
    private List exceptions;

    public SerializerXMLWriter(String namespace, XmlSerializer serializer) {
        this.serializer = serializer;
        this.namespace = namespace;
    }

    public void startElement(String name) {
        try {
            this.serializer.startTag(this.namespace, name);
            this.elements.push(name);
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    public void addAttribute(String key, String value) {
        try {
            this.serializer.attribute(this.namespace, key, value);
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    public void writeText(String text) {
        try {
            this.serializer.text(text);
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    public void writeMarkup(String text) {
        try {
            this.serializer.cdsect(text);
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    public void endElement() {
        try {
            this.serializer.endTag(this.namespace, (String)this.elements.pop());
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    private void storeException(IOException e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.add(e);
    }

    public List getExceptions() {
        return this.exceptions == null ? Collections.EMPTY_LIST : this.exceptions;
    }
}

