/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class FlagMarkingGenerator
implements RuleMethodProcessor {
    FlagMarkingGenerator() {
    }

    public boolean appliesTo(ParserClassNode classNode, RuleMethod method) {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        return method.hasSuppressNodeAnnotation() || method.hasSuppressSubnodesAnnotation() || method.hasSkipNodeAnnotation() || method.hasMemoMismatchesAnnotation();
    }

    public void process(ParserClassNode classNode, RuleMethod method) throws Exception {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        Preconditions.checkState((!method.isSuperMethod() ? 1 : 0) != 0);
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(89));
        LabelNode isNullLabel = new LabelNode();
        instructions.insertBefore(ret, (AbstractInsnNode)new JumpInsnNode(198, isNullLabel));
        if (method.hasSuppressNodeAnnotation()) {
            this.generateMarkerCall(instructions, ret, "suppressNode");
        }
        if (method.hasSuppressSubnodesAnnotation()) {
            this.generateMarkerCall(instructions, ret, "suppressSubnodes");
        }
        if (method.hasSkipNodeAnnotation()) {
            this.generateMarkerCall(instructions, ret, "skipNode");
        }
        if (method.hasMemoMismatchesAnnotation()) {
            this.generateMarkerCall(instructions, ret, "memoMismatches");
        }
        instructions.insertBefore(ret, (AbstractInsnNode)isNullLabel);
    }

    private void generateMarkerCall(InsnList instructions, AbstractInsnNode ret, String call) {
        instructions.insertBefore(ret, (AbstractInsnNode)new MethodInsnNode(185, Types.RULE.getInternalName(), call, "()" + Types.RULE.getDescriptor()));
    }
}

