/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleEqualsAndHashCode
implements EclipseAnnotationHandler<EqualsAndHashCode> {
    private static final Set<String> BUILT_IN_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("byte", "short", "int", "long", "char", "boolean", "double", "float")));

    private void checkForBogusFieldNames(EclipseNode type, AnnotationValues<EqualsAndHashCode> annotation) {
        if (annotation.isExplicit("exclude")) {
            for (int i : EclipseHandlerUtil.createListOfNonExistentFields(Arrays.asList(annotation.getInstance().exclude()), type, true, true)) {
                annotation.setWarning("exclude", "This field does not exist, or would have been excluded anyway.", i);
            }
        }
        if (annotation.isExplicit("of")) {
            for (int i : EclipseHandlerUtil.createListOfNonExistentFields(Arrays.asList(annotation.getInstance().of()), type, false, false)) {
                annotation.setWarning("of", "This field does not exist.", i);
            }
        }
    }

    public void generateEqualsAndHashCodeForType(EclipseNode typeNode, EclipseNode errorNode) {
        for (EclipseNode child : typeNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Eclipse.annotationTypeMatches(EqualsAndHashCode.class, child)) continue;
            return;
        }
        this.generateMethods(typeNode, errorNode, null, null, null, false, false);
    }

    @Override
    public boolean handle(AnnotationValues<EqualsAndHashCode> annotation, Annotation ast, EclipseNode annotationNode) {
        EqualsAndHashCode ann = annotation.getInstance();
        List<String> excludes = Arrays.asList(ann.exclude());
        List<String> includes = Arrays.asList(ann.of());
        EclipseNode typeNode = (EclipseNode)annotationNode.up();
        this.checkForBogusFieldNames(typeNode, annotation);
        Boolean callSuper = ann.callSuper();
        if (!annotation.isExplicit("callSuper")) {
            callSuper = null;
        }
        if (!annotation.isExplicit("exclude")) {
            excludes = null;
        }
        if (!annotation.isExplicit("of")) {
            includes = null;
        }
        if (excludes != null && includes != null) {
            excludes = null;
            annotation.setWarning("exclude", "exclude and of are mutually exclusive; the 'exclude' parameter will be ignored.");
        }
        return this.generateMethods(typeNode, annotationNode, excludes, includes, callSuper, true, ann.doNotUseGetters());
    }

    public boolean generateMethods(EclipseNode typeNode, EclipseNode errorNode, List<String> excludes, List<String> includes, Boolean callSuper, boolean whineIfExists, boolean useFieldsDirectly) {
        boolean implicitCallSuper;
        boolean notAClass;
        assert (excludes == null || includes == null);
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x6200) != 0;
        if (typeDecl == null || notAClass) {
            errorNode.addError("@EqualsAndHashCode is only supported on a class.");
            return false;
        }
        boolean bl2 = implicitCallSuper = callSuper == null;
        if (callSuper == null) {
            try {
                callSuper = (boolean)((Boolean)EqualsAndHashCode.class.getMethod("callSuper", new Class[0]).getDefaultValue());
            }
            catch (Exception ignore) {
                throw new InternalError("Lombok bug - this cannot happen - can't find callSuper field in EqualsAndHashCode annotation.");
            }
        }
        boolean isDirectDescendantOfObject = true;
        if (typeDecl.superclass != null) {
            String p = typeDecl.superclass.toString();
            boolean bl3 = isDirectDescendantOfObject = p.equals("Object") || p.equals("java.lang.Object");
        }
        if (isDirectDescendantOfObject && callSuper.booleanValue()) {
            errorNode.addError("Generating equals/hashCode with a supercall to java.lang.Object is pointless.");
            return true;
        }
        if (!isDirectDescendantOfObject && !callSuper.booleanValue() && implicitCallSuper) {
            errorNode.addWarning("Generating equals/hashCode implementation but without a call to superclass, even though this class does not extend java.lang.Object. If this is intentional, add '@EqualsAndHashCode(callSuper=false)' to your type.");
        }
        ArrayList<EclipseNode> nodesForEquality = new ArrayList<EclipseNode>();
        if (includes != null) {
            for (EclipseNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                FieldDeclaration fieldDecl = (FieldDeclaration)child.get();
                if (!includes.contains(new String(fieldDecl.name))) continue;
                nodesForEquality.add(child);
            }
        } else {
            for (EclipseNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                FieldDeclaration fieldDecl = (FieldDeclaration)child.get();
                if ((fieldDecl.modifiers & 8) != 0 || (fieldDecl.modifiers & 0x80) != 0 || excludes != null && excludes.contains(new String(fieldDecl.name)) || fieldDecl.name.length > 0 && fieldDecl.name[0] == '$') continue;
                nodesForEquality.add(child);
            }
        }
        switch (EclipseHandlerUtil.methodExists("equals", typeNode)) {
            case NOT_EXISTS: {
                MethodDeclaration equals = this.createEquals(typeNode, nodesForEquality, callSuper, (ASTNode)errorNode.get(), useFieldsDirectly);
                EclipseHandlerUtil.injectMethod(typeNode, (AbstractMethodDeclaration)equals);
                break;
            }
            case EXISTS_BY_LOMBOK: {
                break;
            }
            default: {
                if (!whineIfExists) break;
                errorNode.addWarning("Not generating equals(Object other): A method with that name already exists");
            }
        }
        switch (EclipseHandlerUtil.methodExists("hashCode", typeNode)) {
            case NOT_EXISTS: {
                MethodDeclaration hashCode = this.createHashCode(typeNode, nodesForEquality, callSuper, (ASTNode)errorNode.get(), useFieldsDirectly);
                EclipseHandlerUtil.injectMethod(typeNode, (AbstractMethodDeclaration)hashCode);
                break;
            }
            case EXISTS_BY_LOMBOK: {
                break;
            }
            default: {
                if (!whineIfExists) break;
                errorNode.addWarning("Not generating hashCode(): A method with that name already exists");
            }
        }
        return true;
    }

    private MethodDeclaration createHashCode(EclipseNode type, Collection<EclipseNode> fields, boolean callSuper, ASTNode source, boolean useFieldsDirectly) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration method = new MethodDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        Eclipse.setGeneratedBy((ASTNode)method, source);
        method.modifiers = EclipseHandlerUtil.toEclipseModifier(AccessLevel.PUBLIC);
        method.returnType = TypeReference.baseTypeReference((int)10, (int)0);
        Eclipse.setGeneratedBy((ASTNode)method.returnType, source);
        method.annotations = new Annotation[]{EclipseHandlerUtil.makeMarkerAnnotation(TypeConstants.JAVA_LANG_OVERRIDE, source)};
        method.selector = "hashCode".toCharArray();
        method.thrownExceptions = null;
        method.typeParameters = null;
        method.bits |= 0x800000;
        method.declarationSourceStart = method.sourceStart = source.sourceStart;
        method.bodyStart = method.sourceStart;
        method.declarationSourceEnd = method.sourceEnd = source.sourceEnd;
        method.bodyEnd = method.sourceEnd;
        method.arguments = null;
        ArrayList<Object> statements = new ArrayList<Object>();
        ArrayList<Object> intoResult = new ArrayList<Object>();
        char[] PRIME = "PRIME".toCharArray();
        char[] RESULT = "result".toCharArray();
        boolean isEmpty = fields.isEmpty();
        if (!isEmpty || callSuper) {
            LocalDeclaration primeDecl = new LocalDeclaration(PRIME, pS, pE);
            Eclipse.setGeneratedBy((ASTNode)primeDecl, source);
            primeDecl.modifiers |= 0x10;
            primeDecl.type = TypeReference.baseTypeReference((int)10, (int)0);
            primeDecl.type.sourceStart = pS;
            primeDecl.type.sourceEnd = pE;
            Eclipse.setGeneratedBy((ASTNode)primeDecl.type, source);
            primeDecl.initialization = new IntLiteral("31".toCharArray(), pS, pE);
            Eclipse.setGeneratedBy((ASTNode)primeDecl.initialization, source);
            statements.add(primeDecl);
        }
        LocalDeclaration resultDecl = new LocalDeclaration(RESULT, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)resultDecl, source);
        resultDecl.initialization = new IntLiteral("1".toCharArray(), pS, pE);
        Eclipse.setGeneratedBy((ASTNode)resultDecl.initialization, source);
        resultDecl.type = TypeReference.baseTypeReference((int)10, (int)0);
        resultDecl.type.sourceStart = pS;
        resultDecl.type.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)resultDecl.type, source);
        statements.add(resultDecl);
        if (callSuper) {
            MessageSend callToSuper = new MessageSend();
            Eclipse.setGeneratedBy((ASTNode)callToSuper, source);
            callToSuper.sourceStart = pS;
            callToSuper.sourceEnd = pE;
            callToSuper.receiver = new SuperReference(pS, pE);
            Eclipse.setGeneratedBy((ASTNode)callToSuper.receiver, source);
            callToSuper.selector = "hashCode".toCharArray();
            intoResult.add(callToSuper);
        }
        int tempCounter = 0;
        for (EclipseNode eclipseNode : fields) {
            TypeReference fType = EclipseHandlerUtil.getFieldType(eclipseNode, useFieldsDirectly);
            char[] token = fType.getLastToken();
            Expression fieldAccessor = EclipseHandlerUtil.createFieldAccessor(eclipseNode, useFieldsDirectly, source);
            if (fType.dimensions() == 0 && token != null) {
                if (Arrays.equals(TypeConstants.FLOAT, token)) {
                    MessageSend floatToIntBits = new MessageSend();
                    floatToIntBits.sourceStart = pS;
                    floatToIntBits.sourceEnd = pE;
                    Eclipse.setGeneratedBy((ASTNode)floatToIntBits, source);
                    floatToIntBits.receiver = this.generateQualifiedNameRef(source, TypeConstants.JAVA_LANG_FLOAT);
                    floatToIntBits.selector = "floatToIntBits".toCharArray();
                    floatToIntBits.arguments = new Expression[]{fieldAccessor};
                    intoResult.add(floatToIntBits);
                    continue;
                }
                if (Arrays.equals(TypeConstants.DOUBLE, token)) {
                    MessageSend doubleToLongBits = new MessageSend();
                    doubleToLongBits.sourceStart = pS;
                    doubleToLongBits.sourceEnd = pE;
                    Eclipse.setGeneratedBy((ASTNode)doubleToLongBits, source);
                    doubleToLongBits.receiver = this.generateQualifiedNameRef(source, TypeConstants.JAVA_LANG_DOUBLE);
                    doubleToLongBits.selector = "doubleToLongBits".toCharArray();
                    doubleToLongBits.arguments = new Expression[]{fieldAccessor};
                    char[] tempName = ("temp" + ++tempCounter).toCharArray();
                    LocalDeclaration tempVar = new LocalDeclaration(tempName, pS, pE);
                    Eclipse.setGeneratedBy((ASTNode)tempVar, source);
                    tempVar.initialization = doubleToLongBits;
                    tempVar.type = TypeReference.baseTypeReference((int)7, (int)0);
                    tempVar.type.sourceStart = pS;
                    tempVar.type.sourceEnd = pE;
                    Eclipse.setGeneratedBy((ASTNode)tempVar.type, source);
                    tempVar.modifiers = 16;
                    statements.add(tempVar);
                    SingleNameReference copy1 = new SingleNameReference(tempName, p);
                    Eclipse.setGeneratedBy((ASTNode)copy1, source);
                    SingleNameReference copy2 = new SingleNameReference(tempName, p);
                    Eclipse.setGeneratedBy((ASTNode)copy2, source);
                    intoResult.add(this.longToIntForHashCode((Expression)copy1, (Expression)copy2, source));
                    continue;
                }
                if (Arrays.equals(TypeConstants.BOOLEAN, token)) {
                    IntLiteral int1231 = new IntLiteral("1231".toCharArray(), pS, pE);
                    Eclipse.setGeneratedBy((ASTNode)int1231, source);
                    IntLiteral int1237 = new IntLiteral("1237".toCharArray(), pS, pE);
                    Eclipse.setGeneratedBy((ASTNode)int1237, source);
                    ConditionalExpression int1231or1237 = new ConditionalExpression(fieldAccessor, (Expression)int1231, (Expression)int1237);
                    Eclipse.setGeneratedBy((ASTNode)int1231or1237, source);
                    intoResult.add(int1231or1237);
                    continue;
                }
                if (Arrays.equals(TypeConstants.LONG, token)) {
                    intoResult.add(this.longToIntForHashCode(fieldAccessor, EclipseHandlerUtil.createFieldAccessor(eclipseNode, useFieldsDirectly, source), source));
                    continue;
                }
                if (BUILT_IN_TYPES.contains(new String(token))) {
                    intoResult.add(fieldAccessor);
                    continue;
                }
                MessageSend hashCodeCall = new MessageSend();
                hashCodeCall.sourceStart = pS;
                hashCodeCall.sourceEnd = pE;
                Eclipse.setGeneratedBy((ASTNode)hashCodeCall, source);
                hashCodeCall.receiver = EclipseHandlerUtil.createFieldAccessor(eclipseNode, useFieldsDirectly, source);
                hashCodeCall.selector = "hashCode".toCharArray();
                NullLiteral nullLiteral = new NullLiteral(pS, pE);
                Eclipse.setGeneratedBy((ASTNode)nullLiteral, source);
                EqualExpression objIsNull = new EqualExpression(fieldAccessor, (Expression)nullLiteral, 18);
                Eclipse.setGeneratedBy((ASTNode)objIsNull, source);
                IntLiteral int0 = new IntLiteral("0".toCharArray(), pS, pE);
                Eclipse.setGeneratedBy((ASTNode)int0, source);
                ConditionalExpression nullOrHashCode = new ConditionalExpression((Expression)objIsNull, (Expression)int0, (Expression)hashCodeCall);
                nullOrHashCode.sourceStart = pS;
                nullOrHashCode.sourceEnd = pE;
                Eclipse.setGeneratedBy((ASTNode)nullOrHashCode, source);
                intoResult.add(nullOrHashCode);
                continue;
            }
            if (fType.dimensions() <= 0 || token == null) continue;
            MessageSend arraysHashCodeCall = new MessageSend();
            arraysHashCodeCall.sourceStart = pS;
            arraysHashCodeCall.sourceEnd = pE;
            Eclipse.setGeneratedBy((ASTNode)arraysHashCodeCall, source);
            arraysHashCodeCall.receiver = this.generateQualifiedNameRef(source, TypeConstants.JAVA, TypeConstants.UTIL, "Arrays".toCharArray());
            arraysHashCodeCall.selector = fType.dimensions() > 1 || !BUILT_IN_TYPES.contains(new String(token)) ? "deepHashCode".toCharArray() : "hashCode".toCharArray();
            arraysHashCodeCall.arguments = new Expression[]{fieldAccessor};
            intoResult.add(arraysHashCodeCall);
        }
        for (Expression expression : intoResult) {
            SingleNameReference resultRef = new SingleNameReference(RESULT, p);
            Eclipse.setGeneratedBy((ASTNode)resultRef, source);
            SingleNameReference primeRef = new SingleNameReference(PRIME, p);
            Eclipse.setGeneratedBy((ASTNode)primeRef, source);
            BinaryExpression multiplyByPrime = new BinaryExpression((Expression)resultRef, (Expression)primeRef, 15);
            multiplyByPrime.sourceStart = pS;
            multiplyByPrime.sourceEnd = pE;
            Eclipse.setGeneratedBy((ASTNode)multiplyByPrime, source);
            BinaryExpression addItem = new BinaryExpression((Expression)multiplyByPrime, expression, 14);
            addItem.sourceStart = pS;
            addItem.sourceEnd = pE;
            Eclipse.setGeneratedBy((ASTNode)addItem, source);
            resultRef = new SingleNameReference(RESULT, p);
            Eclipse.setGeneratedBy((ASTNode)resultRef, source);
            Assignment assignment = new Assignment((Expression)resultRef, (Expression)addItem, pE);
            assignment.sourceStart = pS;
            assignment.sourceEnd = pE;
            Eclipse.setGeneratedBy((ASTNode)assignment, source);
            statements.add(assignment);
        }
        SingleNameReference resultRef = new SingleNameReference(RESULT, p);
        Eclipse.setGeneratedBy((ASTNode)resultRef, source);
        ReturnStatement returnStatement = new ReturnStatement((Expression)resultRef, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)returnStatement, source);
        statements.add(returnStatement);
        method.statements = statements.toArray(new Statement[statements.size()]);
        return method;
    }

    private MethodDeclaration createEquals(EclipseNode type, Collection<EclipseNode> fields, boolean callSuper, ASTNode source, boolean useFieldsDirectly) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration method = new MethodDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        Eclipse.setGeneratedBy((ASTNode)method, source);
        method.modifiers = EclipseHandlerUtil.toEclipseModifier(AccessLevel.PUBLIC);
        method.returnType = TypeReference.baseTypeReference((int)5, (int)0);
        method.returnType.sourceStart = pS;
        method.returnType.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)method.returnType, source);
        method.annotations = new Annotation[]{EclipseHandlerUtil.makeMarkerAnnotation(TypeConstants.JAVA_LANG_OVERRIDE, source)};
        method.selector = "equals".toCharArray();
        method.thrownExceptions = null;
        method.typeParameters = null;
        method.bits |= 0x800000;
        method.declarationSourceStart = method.sourceStart = source.sourceStart;
        method.bodyStart = method.sourceStart;
        method.declarationSourceEnd = method.sourceEnd = source.sourceEnd;
        method.bodyEnd = method.sourceEnd;
        QualifiedTypeReference objectRef = new QualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT, new long[]{p, p, p});
        Eclipse.setGeneratedBy((ASTNode)objectRef, source);
        method.arguments = new Argument[]{new Argument(new char[]{'o'}, 0L, (TypeReference)objectRef, 16)};
        method.arguments[0].sourceStart = pS;
        method.arguments[0].sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)method.arguments[0], source);
        ArrayList<Object> statements = new ArrayList<Object>();
        SingleNameReference oRef = new SingleNameReference(new char[]{'o'}, p);
        Eclipse.setGeneratedBy((ASTNode)oRef, source);
        ThisReference thisRef = new ThisReference(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)thisRef, source);
        EqualExpression otherEqualsThis = new EqualExpression((Expression)oRef, (Expression)thisRef, 18);
        Eclipse.setGeneratedBy((ASTNode)otherEqualsThis, source);
        TrueLiteral trueLiteral = new TrueLiteral(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)trueLiteral, source);
        ReturnStatement returnTrue = new ReturnStatement((Expression)trueLiteral, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)returnTrue, source);
        IfStatement ifOtherEqualsThis = new IfStatement((Expression)otherEqualsThis, (Statement)returnTrue, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)ifOtherEqualsThis, source);
        statements.add(ifOtherEqualsThis);
        oRef = new SingleNameReference(new char[]{'o'}, p);
        Eclipse.setGeneratedBy((ASTNode)oRef, source);
        NullLiteral nullLiteral = new NullLiteral(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)nullLiteral, source);
        EqualExpression otherEqualsNull = new EqualExpression((Expression)oRef, (Expression)nullLiteral, 18);
        Eclipse.setGeneratedBy((ASTNode)otherEqualsNull, source);
        FalseLiteral falseLiteral = new FalseLiteral(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)falseLiteral, source);
        ReturnStatement returnFalse = new ReturnStatement((Expression)falseLiteral, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)returnFalse, source);
        IfStatement ifOtherEqualsNull = new IfStatement((Expression)otherEqualsNull, (Statement)returnFalse, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)ifOtherEqualsNull, source);
        statements.add(ifOtherEqualsNull);
        MessageSend otherGetClass = new MessageSend();
        otherGetClass.sourceStart = pS;
        otherGetClass.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)otherGetClass, source);
        otherGetClass.receiver = new SingleNameReference(new char[]{'o'}, p);
        Eclipse.setGeneratedBy((ASTNode)otherGetClass.receiver, source);
        otherGetClass.selector = "getClass".toCharArray();
        MessageSend thisGetClass = new MessageSend();
        thisGetClass.sourceStart = pS;
        thisGetClass.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)thisGetClass, source);
        thisGetClass.receiver = new ThisReference(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)thisGetClass.receiver, source);
        thisGetClass.selector = "getClass".toCharArray();
        EqualExpression classesNotEqual = new EqualExpression((Expression)otherGetClass, (Expression)thisGetClass, 29);
        Eclipse.setGeneratedBy((ASTNode)classesNotEqual, source);
        falseLiteral = new FalseLiteral(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)falseLiteral, source);
        returnFalse = new ReturnStatement((Expression)falseLiteral, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)returnFalse, source);
        IfStatement ifClassesNotEqual = new IfStatement((Expression)classesNotEqual, (Statement)returnFalse, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)ifClassesNotEqual, source);
        statements.add(ifClassesNotEqual);
        char[] otherN = "other".toCharArray();
        if (callSuper) {
            MessageSend callToSuper = new MessageSend();
            callToSuper.sourceStart = pS;
            callToSuper.sourceEnd = pE;
            Eclipse.setGeneratedBy((ASTNode)callToSuper, source);
            callToSuper.receiver = new SuperReference(pS, pE);
            Eclipse.setGeneratedBy((ASTNode)callToSuper.receiver, source);
            callToSuper.selector = "equals".toCharArray();
            SingleNameReference oRef2 = new SingleNameReference(new char[]{'o'}, p);
            Eclipse.setGeneratedBy((ASTNode)oRef2, source);
            callToSuper.arguments = new Expression[]{oRef2};
            UnaryExpression superNotEqual = new UnaryExpression((Expression)callToSuper, 11);
            Eclipse.setGeneratedBy((ASTNode)superNotEqual, source);
            FalseLiteral falseLiteral2 = new FalseLiteral(pS, pE);
            Eclipse.setGeneratedBy((ASTNode)falseLiteral2, source);
            ReturnStatement returnFalse2 = new ReturnStatement((Expression)falseLiteral2, pS, pE);
            Eclipse.setGeneratedBy((ASTNode)returnFalse2, source);
            IfStatement ifSuperEquals = new IfStatement((Expression)superNotEqual, (Statement)returnFalse2, pS, pE);
            Eclipse.setGeneratedBy((ASTNode)ifSuperEquals, source);
            statements.add(ifSuperEquals);
        }
        TypeDeclaration typeDecl = (TypeDeclaration)type.get();
        if (!fields.isEmpty()) {
            SingleNameReference targetType;
            LocalDeclaration other = new LocalDeclaration(otherN, pS, pE);
            other.modifiers |= 0x10;
            Eclipse.setGeneratedBy((ASTNode)other, source);
            char[] typeName = typeDecl.name;
            if (typeDecl.typeParameters == null || typeDecl.typeParameters.length == 0) {
                targetType = new SingleNameReference(((TypeDeclaration)type.get()).name, p);
                Eclipse.setGeneratedBy((ASTNode)targetType, source);
                other.type = new SingleTypeReference(typeName, p);
                Eclipse.setGeneratedBy((ASTNode)other.type, source);
            } else {
                TypeReference[] typeArgs = new TypeReference[typeDecl.typeParameters.length];
                for (int i = 0; i < typeArgs.length; ++i) {
                    typeArgs[i] = new Wildcard(0);
                    typeArgs[i].sourceStart = pS;
                    typeArgs[i].sourceEnd = pE;
                    Eclipse.setGeneratedBy((ASTNode)typeArgs[i], source);
                }
                targetType = new ParameterizedSingleTypeReference(typeName, typeArgs, 0, p);
                Eclipse.setGeneratedBy((ASTNode)targetType, source);
                other.type = new ParameterizedSingleTypeReference(typeName, Eclipse.copyTypes(typeArgs, source), 0, p);
                Eclipse.setGeneratedBy((ASTNode)other.type, source);
            }
            SingleNameReference oRef3 = new SingleNameReference(new char[]{'o'}, p);
            Eclipse.setGeneratedBy((ASTNode)oRef3, source);
            other.initialization = new CastExpression((Expression)oRef3, (Expression)targetType);
            Eclipse.setGeneratedBy((ASTNode)other.initialization, source);
            statements.add(other);
        }
        for (EclipseNode field : fields) {
            TypeReference fType = EclipseHandlerUtil.getFieldType(field, useFieldsDirectly);
            char[] token = fType.getLastToken();
            Expression thisFieldAccessor = EclipseHandlerUtil.createFieldAccessor(field, useFieldsDirectly, source);
            Expression otherFieldAccessor = EclipseHandlerUtil.createFieldAccessor(field, useFieldsDirectly, source, otherN);
            if (fType.dimensions() == 0 && token != null) {
                if (Arrays.equals(TypeConstants.FLOAT, token)) {
                    statements.add(this.generateCompareFloatOrDouble(thisFieldAccessor, otherFieldAccessor, "Float".toCharArray(), source));
                    continue;
                }
                if (Arrays.equals(TypeConstants.DOUBLE, token)) {
                    statements.add(this.generateCompareFloatOrDouble(thisFieldAccessor, otherFieldAccessor, "Double".toCharArray(), source));
                    continue;
                }
                if (BUILT_IN_TYPES.contains(new String(token))) {
                    EqualExpression fieldsNotEqual = new EqualExpression(thisFieldAccessor, otherFieldAccessor, 29);
                    Eclipse.setGeneratedBy((ASTNode)fieldsNotEqual, source);
                    FalseLiteral falseLiteral3 = new FalseLiteral(pS, pE);
                    Eclipse.setGeneratedBy((ASTNode)falseLiteral3, source);
                    ReturnStatement returnStatement = new ReturnStatement((Expression)falseLiteral3, pS, pE);
                    Eclipse.setGeneratedBy((ASTNode)returnStatement, source);
                    IfStatement ifStatement = new IfStatement((Expression)fieldsNotEqual, (Statement)returnStatement, pS, pE);
                    Eclipse.setGeneratedBy((ASTNode)ifStatement, source);
                    statements.add(ifStatement);
                    continue;
                }
                NullLiteral nullLiteral2 = new NullLiteral(pS, pE);
                Eclipse.setGeneratedBy((ASTNode)nullLiteral2, source);
                EqualExpression fieldIsNull = new EqualExpression(thisFieldAccessor, (Expression)nullLiteral2, 18);
                nullLiteral2 = new NullLiteral(pS, pE);
                Eclipse.setGeneratedBy((ASTNode)nullLiteral2, source);
                EqualExpression otherFieldIsntNull = new EqualExpression(otherFieldAccessor, (Expression)nullLiteral2, 29);
                MessageSend equalsCall = new MessageSend();
                equalsCall.sourceStart = pS;
                equalsCall.sourceEnd = pE;
                Eclipse.setGeneratedBy((ASTNode)equalsCall, source);
                equalsCall.receiver = EclipseHandlerUtil.createFieldAccessor(field, useFieldsDirectly, source);
                equalsCall.selector = "equals".toCharArray();
                equalsCall.arguments = new Expression[]{EclipseHandlerUtil.createFieldAccessor(field, useFieldsDirectly, source, otherN)};
                UnaryExpression fieldsNotEqual = new UnaryExpression((Expression)equalsCall, 11);
                fieldsNotEqual.sourceStart = pS;
                fieldsNotEqual.sourceEnd = pE;
                Eclipse.setGeneratedBy((ASTNode)fieldsNotEqual, source);
                ConditionalExpression fullEquals = new ConditionalExpression((Expression)fieldIsNull, (Expression)otherFieldIsntNull, (Expression)fieldsNotEqual);
                fullEquals.sourceStart = pS;
                fullEquals.sourceEnd = pE;
                Eclipse.setGeneratedBy((ASTNode)fullEquals, source);
                FalseLiteral falseLiteral4 = new FalseLiteral(pS, pE);
                Eclipse.setGeneratedBy((ASTNode)falseLiteral4, source);
                ReturnStatement returnStatement = new ReturnStatement((Expression)falseLiteral4, pS, pE);
                Eclipse.setGeneratedBy((ASTNode)returnStatement, source);
                IfStatement ifStatement = new IfStatement((Expression)fullEquals, (Statement)returnStatement, pS, pE);
                Eclipse.setGeneratedBy((ASTNode)ifStatement, source);
                statements.add(ifStatement);
                continue;
            }
            if (fType.dimensions() <= 0 || token == null) continue;
            MessageSend arraysEqualCall = new MessageSend();
            arraysEqualCall.sourceStart = pS;
            arraysEqualCall.sourceEnd = pE;
            Eclipse.setGeneratedBy((ASTNode)arraysEqualCall, source);
            arraysEqualCall.receiver = this.generateQualifiedNameRef(source, TypeConstants.JAVA, TypeConstants.UTIL, "Arrays".toCharArray());
            arraysEqualCall.selector = fType.dimensions() > 1 || !BUILT_IN_TYPES.contains(new String(token)) ? "deepEquals".toCharArray() : "equals".toCharArray();
            arraysEqualCall.arguments = new Expression[]{thisFieldAccessor, otherFieldAccessor};
            UnaryExpression arraysNotEqual = new UnaryExpression((Expression)arraysEqualCall, 11);
            arraysNotEqual.sourceStart = pS;
            arraysNotEqual.sourceEnd = pE;
            Eclipse.setGeneratedBy((ASTNode)arraysNotEqual, source);
            FalseLiteral falseLiteral5 = new FalseLiteral(pS, pE);
            Eclipse.setGeneratedBy((ASTNode)falseLiteral5, source);
            ReturnStatement returnStatement = new ReturnStatement((Expression)falseLiteral5, pS, pE);
            Eclipse.setGeneratedBy((ASTNode)returnStatement, source);
            IfStatement ifStatement = new IfStatement((Expression)arraysNotEqual, (Statement)returnStatement, pS, pE);
            Eclipse.setGeneratedBy((ASTNode)ifStatement, source);
            statements.add(ifStatement);
        }
        TrueLiteral trueLiteral2 = new TrueLiteral(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)trueLiteral2, source);
        ReturnStatement returnStatement = new ReturnStatement((Expression)trueLiteral2, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)returnStatement, source);
        statements.add(returnStatement);
        method.statements = statements.toArray(new Statement[statements.size()]);
        return method;
    }

    private IfStatement generateCompareFloatOrDouble(Expression thisRef, Expression otherRef, char[] floatOrDouble, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        MessageSend floatCompare = new MessageSend();
        floatCompare.sourceStart = pS;
        floatCompare.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)floatCompare, source);
        floatCompare.receiver = this.generateQualifiedNameRef(source, TypeConstants.JAVA, TypeConstants.LANG, floatOrDouble);
        floatCompare.selector = "compare".toCharArray();
        floatCompare.arguments = new Expression[]{thisRef, otherRef};
        IntLiteral int0 = new IntLiteral(new char[]{'0'}, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)int0, source);
        EqualExpression ifFloatCompareIsNot0 = new EqualExpression((Expression)floatCompare, (Expression)int0, 29);
        ifFloatCompareIsNot0.sourceStart = pS;
        ifFloatCompareIsNot0.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)ifFloatCompareIsNot0, source);
        FalseLiteral falseLiteral = new FalseLiteral(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)falseLiteral, source);
        ReturnStatement returnFalse = new ReturnStatement((Expression)falseLiteral, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)returnFalse, source);
        IfStatement ifStatement = new IfStatement((Expression)ifFloatCompareIsNot0, (Statement)returnFalse, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)ifStatement, source);
        return ifStatement;
    }

    private Expression longToIntForHashCode(Expression ref1, Expression ref2, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        IntLiteral int32 = new IntLiteral("32".toCharArray(), pS, pE);
        Eclipse.setGeneratedBy((ASTNode)int32, source);
        BinaryExpression higherBits = new BinaryExpression(ref1, (Expression)int32, 19);
        Eclipse.setGeneratedBy((ASTNode)higherBits, source);
        BinaryExpression xorParts = new BinaryExpression(ref2, (Expression)higherBits, 8);
        Eclipse.setGeneratedBy((ASTNode)xorParts, source);
        TypeReference intRef = TypeReference.baseTypeReference((int)10, (int)0);
        intRef.sourceStart = pS;
        intRef.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)intRef, source);
        CastExpression expr = new CastExpression((Expression)xorParts, (Expression)intRef);
        expr.sourceStart = pS;
        expr.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)expr, source);
        return expr;
    }

    private NameReference generateQualifiedNameRef(ASTNode source, char[] ... varNames) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        Object ref = varNames.length > 1 ? new QualifiedNameReference(varNames, new long[varNames.length], pS, pE) : new SingleNameReference(varNames[0], p);
        Eclipse.setGeneratedBy((ASTNode)ref, source);
        return ref;
    }
}

