/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.apt;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import lombok.javac.JavacTransformer;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class Processor
extends AbstractProcessor {
    private JavacProcessingEnvironment processingEnv;
    private JavacTransformer transformer;
    private Trees trees;

    @Override
    public void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.processingEnv = (JavacProcessingEnvironment)procEnv;
        this.transformer = new JavacTransformer(procEnv.getMessager());
        this.trees = Trees.instance(procEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        IdentityHashMap units = new IdentityHashMap();
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit unit = this.toUnit(element);
            if (unit == null) continue;
            units.put(unit, null);
        }
        this.transformer.transform(this.processingEnv.getContext(), units.keySet());
        return false;
    }

    private JCTree.JCCompilationUnit toUnit(Element element) {
        TreePath path;
        TreePath treePath = path = this.trees == null ? null : this.trees.getPath(element);
        if (path == null) {
            return null;
        }
        return (JCTree.JCCompilationUnit)path.getCompilationUnit();
    }
}

