/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import lombok.Synchronized;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleSynchronized
implements JavacAnnotationHandler<Synchronized> {
    private static final String INSTANCE_LOCK_NAME = "$lock";
    private static final String STATIC_LOCK_NAME = "$LOCK";

    @Override
    public boolean handle(AnnotationValues<Synchronized> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.markAnnotationAsProcessed(annotationNode, Synchronized.class);
        JavacNode methodNode = (JavacNode)annotationNode.up();
        if (methodNode == null || methodNode.getKind() != AST.Kind.METHOD || !(methodNode.get() instanceof JCTree.JCMethodDecl)) {
            annotationNode.addError("@Synchronized is legal only on methods.");
            return true;
        }
        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)methodNode.get();
        if ((method.mods.flags & 0x400L) != 0L) {
            annotationNode.addError("@Synchronized is legal only on concrete methods.");
            return true;
        }
        boolean isStatic = (method.mods.flags & 8L) != 0L;
        String lockName = annotation.getInstance().value();
        boolean autoMake = false;
        if (lockName.length() == 0) {
            autoMake = true;
            lockName = isStatic ? STATIC_LOCK_NAME : INSTANCE_LOCK_NAME;
        }
        TreeMaker maker = methodNode.getTreeMaker();
        if (JavacHandlerUtil.fieldExists(lockName, methodNode) == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            if (!autoMake) {
                annotationNode.addError("The field " + lockName + " does not exist.");
                return true;
            }
            JCTree.JCExpression objectType = JavacHandlerUtil.chainDots(maker, methodNode, "java", "lang", "Object");
            JCTree.JCNewArray newObjectArray = maker.NewArray(JavacHandlerUtil.chainDots(maker, methodNode, "java", "lang", "Object"), List.of(maker.Literal(4, 0)), null);
            JCTree.JCVariableDecl fieldDecl = maker.VarDef(maker.Modifiers(0x12 | (isStatic ? 8 : 0)), methodNode.toName(lockName), objectType, newObjectArray);
            JavacHandlerUtil.injectField((JavacNode)methodNode.up(), fieldDecl);
        }
        if (method.body == null) {
            return false;
        }
        JCTree.JCExpression lockNode = isStatic ? JavacHandlerUtil.chainDots(maker, methodNode, ((JavacNode)methodNode.up()).getName(), lockName) : maker.Select((JCTree.JCExpression)maker.Ident(methodNode.toName("this")), methodNode.toName(lockName));
        method.body = maker.Block(0L, List.of(maker.Synchronized(lockNode, method.body)));
        methodNode.rebuild();
        return true;
    }
}

