/*
 * Decompiled with CFR 0.152.
 */
package lombok.netbeans.agent;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.lang.model.element.Element;
import lombok.Lombok;
import lombok.patcher.inject.LiveInjector;
import org.netbeans.Module;
import org.netbeans.ProxyClassLoader;
import org.netbeans.api.java.source.ClasspathInfo;

public class PatchFixes {
    public static boolean loadClass_decision(ClassLoader loader, String name) throws Exception {
        return name.startsWith("lombok.");
    }

    public static Class<?> loadClass_value(ClassLoader loader, String name) throws Exception {
        int last = name.lastIndexOf(46);
        String pkg = last >= 0 ? name.substring(0, last) : "";
        Method m = ProxyClassLoader.class.getDeclaredMethod("selfLoadClass", String.class, String.class);
        m.setAccessible(true);
        return (Class)m.invoke((Object)loader, pkg, name);
    }

    public static boolean getResource_decision(ClassLoader loader, String name) throws Exception {
        return name.startsWith("META-INF/services/lombok.");
    }

    public static URL getResource_value(ClassLoader loader, String name) throws Exception {
        Method m = ProxyClassLoader.class.getDeclaredMethod("findResource", String.class);
        m.setAccessible(true);
        return (URL)m.invoke((Object)loader, name);
    }

    public static boolean getResources_decision(ClassLoader loader, String name) throws Exception {
        return name.startsWith("META-INF/services/lombok.");
    }

    public static Enumeration<?> getResources_value(ClassLoader loader, String name) throws Exception {
        Method m = ProxyClassLoader.class.getDeclaredMethod("findResources", String.class);
        m.setAccessible(true);
        return (Enumeration)m.invoke((Object)loader, name);
    }

    public static void addSelfToClassLoader(Module module, List<File> classPath) {
        if (module.getJarFile().getName().equals("org-netbeans-libs-javacimpl.jar")) {
            String lombokJarLoc = LiveInjector.findPathJar(Lombok.class);
            classPath.add(new File(lombokJarLoc));
        }
    }

    public static void fixContentOnSetTaskListener(JavacTaskImpl that, TaskListener taskListener) throws Throwable {
        Context context = that.getContext();
        if (context.get(TaskListener.class) != null) {
            context.put(TaskListener.class, (TaskListener)null);
        }
        if (taskListener != null) {
            try {
                Method m = JavacTaskImpl.class.getDeclaredMethod("wrap", TaskListener.class);
                try {
                    m.setAccessible(true);
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
                TaskListener w = (TaskListener)m.invoke((Object)that, taskListener);
                context.put(TaskListener.class, w);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    public static Tree returnNullForGeneratedNode(Trees trees, Element element, Object o) throws Throwable {
        try {
            Tree tree = trees.getTree(element);
            if (tree == null) {
                return null;
            }
            CompilationUnitTree unit = (CompilationUnitTree)o.getClass().getMethod("getCompilationUnit", new Class[0]).invoke(o, new Object[0]);
            int startPos = (int)trees.getSourcePositions().getStartPosition(unit, tree);
            if (startPos == -1) {
                return null;
            }
            return tree;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static long returnMinus1ForGeneratedNode(SourcePositions that, CompilationUnitTree cu, Tree tree) {
        int start = (int)that.getStartPosition(cu, tree);
        if (start < 0) {
            return -1L;
        }
        return that.getEndPosition(cu, tree);
    }

    public static void addTaskListenerWhenCallingJavac(JavacTaskImpl task, ClasspathInfo cpInfo) throws Exception {
        if (task == null) {
            return;
        }
        Class<?> entryPoint = JavacTaskImpl.class.getClassLoader().loadClass("lombok.netbeans.agent.NetbeansEntryPoint");
        if (entryPoint == null) {
            System.err.println("[LOMBOK] ClassLoader not patched correctly.");
        } else {
            task.setTaskListener((TaskListener)entryPoint.getConstructor(Context.class).newInstance(task.getContext()));
        }
    }

    public static Iterator<JCTree> filterGenerated(final Iterator<JCTree> it) {
        return new Iterator<JCTree>(){
            private JCTree next;
            private boolean hasNext;
            {
                this.calc();
            }

            private void calc() {
                while (it.hasNext()) {
                    JCTree n = (JCTree)it.next();
                    if (n.pos == -1) continue;
                    this.hasNext = true;
                    this.next = n;
                    return;
                }
                this.hasNext = false;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public JCTree next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                JCTree n = this.next;
                this.calc();
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

