/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.DrawableNode;
import org.robolectric.res.OverlayResourceIndex;
import org.robolectric.res.PackageResourceLoader;
import org.robolectric.res.Plural;
import org.robolectric.res.PreferenceNode;
import org.robolectric.res.ResName;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XResourceLoader;
import org.robolectric.res.builder.XmlBlock;

public class OverlayResourceLoader
extends XResourceLoader {
    private static final int MAX_PARALLELISM = OverlayResourceLoader.calculateMaxParallelism();
    private final String packageName;
    private final List<PackageResourceLoader> subResourceLoaders;

    public OverlayResourceLoader(String packageName, List<PackageResourceLoader> subResourceLoaders) {
        super(new OverlayResourceIndex(packageName, subResourceLoaders));
        this.packageName = packageName;
        this.subResourceLoaders = subResourceLoaders;
    }

    @Override
    void doInitialize() {
        this.initialiseResourceLoaders();
        this.mergeResources();
    }

    private static int calculateMaxParallelism() {
        int threadsToUse = Math.min(4, Runtime.getRuntime().availableProcessors() / 2);
        return Math.max(1, threadsToUse);
    }

    private void initialiseResourceLoaders() {
        ArrayList<Callable<Void>> initialiseTasks = new ArrayList<Callable<Void>>(this.subResourceLoaders.size());
        for (final PackageResourceLoader subResourceLoader : this.subResourceLoaders) {
            initialiseTasks.add(new Callable<Void>(){

                @Override
                public Void call() {
                    subResourceLoader.initialize();
                    return null;
                }
            });
        }
        this.runTasksInExecutor(initialiseTasks);
    }

    private void mergeResources() {
        ArrayList<Callable<Void>> mergeTasks = new ArrayList<Callable<Void>>(7);
        mergeTasks.add(new Callable<Void>(){

            @Override
            public Void call() {
                for (PackageResourceLoader subResourceLoader : OverlayResourceLoader.this.subResourceLoaders) {
                    OverlayResourceLoader.this.pluralsData.mergeLibraryStyle(subResourceLoader.pluralsData, OverlayResourceLoader.this.packageName);
                }
                return null;
            }
        });
        mergeTasks.add(new Callable<Void>(){

            @Override
            public Void call() {
                for (PackageResourceLoader subResourceLoader : OverlayResourceLoader.this.subResourceLoaders) {
                    OverlayResourceLoader.this.stringData.mergeLibraryStyle(subResourceLoader.stringData, OverlayResourceLoader.this.packageName);
                }
                return null;
            }
        });
        mergeTasks.add(new Callable<Void>(){

            @Override
            public Void call() {
                for (PackageResourceLoader subResourceLoader : OverlayResourceLoader.this.subResourceLoaders) {
                    OverlayResourceLoader.this.drawableData.mergeLibraryStyle(subResourceLoader.drawableData, OverlayResourceLoader.this.packageName);
                }
                return null;
            }
        });
        mergeTasks.add(new Callable<Void>(){

            @Override
            public Void call() {
                for (PackageResourceLoader subResourceLoader : OverlayResourceLoader.this.subResourceLoaders) {
                    OverlayResourceLoader.this.preferenceData.mergeLibraryStyle(subResourceLoader.preferenceData, OverlayResourceLoader.this.packageName);
                }
                return null;
            }
        });
        mergeTasks.add(new Callable<Void>(){

            @Override
            public Void call() {
                for (PackageResourceLoader subResourceLoader : OverlayResourceLoader.this.subResourceLoaders) {
                    OverlayResourceLoader.this.xmlDocuments.mergeLibraryStyle(subResourceLoader.xmlDocuments, OverlayResourceLoader.this.packageName);
                }
                return null;
            }
        });
        mergeTasks.add(new Callable<Void>(){

            @Override
            public Void call() {
                for (PackageResourceLoader subResourceLoader : OverlayResourceLoader.this.subResourceLoaders) {
                    OverlayResourceLoader.this.rawResources.mergeLibraryStyle(subResourceLoader.rawResources, OverlayResourceLoader.this.packageName);
                }
                return null;
            }
        });
        mergeTasks.add(new Callable<Void>(){

            @Override
            public Void call() {
                for (PackageResourceLoader subResourceLoader : OverlayResourceLoader.this.subResourceLoaders) {
                    OverlayResourceLoader.this.data.mergeLibraryStyle(subResourceLoader.data, OverlayResourceLoader.this.packageName);
                }
                return null;
            }
        });
        this.runTasksInExecutor(mergeTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasksInExecutor(List<Callable<Void>> tasks) {
        ForkJoinPool executorService = new ForkJoinPool(MAX_PARALLELISM);
        try {
            executorService.invokeAll(tasks);
        }
        finally {
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new RuntimeException("Xml parsing for subdirectories of " + this.packageName + " took longer than 5 minutes");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public DrawableNode getDrawableNode(ResName resName, String qualifiers) {
        return super.getDrawableNode(resName.withPackageName(this.packageName), qualifiers);
    }

    @Override
    public Plural getPlural(ResName resName, int quantity, String qualifiers) {
        return super.getPlural(resName.withPackageName(this.packageName), quantity, qualifiers);
    }

    @Override
    public PreferenceNode getPreferenceNode(ResName resName, String qualifiers) {
        return super.getPreferenceNode(resName.withPackageName(this.packageName), qualifiers);
    }

    @Override
    public InputStream getRawValue(ResName resName) {
        return super.getRawValue(resName.withPackageName(this.packageName));
    }

    @Override
    public TypedResource getValue(@NotNull ResName resName, String qualifiers) {
        return super.getValue(resName.withPackageName(this.packageName), qualifiers);
    }

    @Override
    public XmlBlock getXml(ResName resName, String qualifiers) {
        return super.getXml(resName.withPackageName(this.packageName), qualifiers);
    }

    @Override
    public boolean providesFor(String namespace) {
        for (PackageResourceLoader subResourceLoader : this.subResourceLoaders) {
            if (!subResourceLoader.providesFor(namespace)) continue;
            return true;
        }
        return false;
    }
}

