/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.res.ResName;
import org.robolectric.res.XmlLoader;

public class ResBundle<T> {
    private static final Pattern VERSION_QUALIFIER_PATTERN = Pattern.compile("(v)([0-9]+)$");
    private static final Pattern SIZE_QUALIFIER_PATTERN = Pattern.compile("(s?[wh])([0-9]+)dp$");
    private final ResMap<T> valuesMap = new ResMap();
    private final ResMap<List<T>> valuesArrayMap = new ResMap();
    private String overrideNamespace;

    public void put(String attrType, String name, T value, XmlLoader.XmlContext xmlContext) {
        ResName resName = new ResName(this.maybeOverride(xmlContext.packageName), attrType, name);
        List<Value<T>> values = this.valuesMap.find(resName);
        values.add(new Value<T>(xmlContext.getQualifiers(), value));
        Collections.sort(values);
    }

    public T get(ResName resName, String qualifiers) {
        Value<T> value = this.getValue(resName, qualifiers);
        return (T)(value == null ? null : ((Value)value).value);
    }

    public Value<T> getValue(ResName resName, String qualifiers) {
        List<Value<T>> values = this.valuesMap.find(this.maybeOverride(resName));
        return values != null ? ResBundle.pick(values, qualifiers) : null;
    }

    public static int getVersionQualifierApiLevel(String qualifiers) {
        Matcher m = VERSION_QUALIFIER_PATTERN.matcher(qualifiers);
        if (m.find()) {
            return Integer.parseInt(m.group(2));
        }
        return -1;
    }

    public static <T> Value<T> pick(List<Value<T>> values, String qualifiersStr) {
        int count = values.size();
        if (count == 0) {
            return null;
        }
        Qualifiers toMatch = Qualifiers.parse(qualifiersStr);
        Qualifiers bestMatchQualifiers = null;
        Value<T> bestMatch = null;
        for (int i = 0; i < count; ++i) {
            Value<T> value = values.get(i);
            Qualifiers qualifiers = Qualifiers.parse(((Value)value).qualifiers);
            if (!qualifiers.matches(toMatch) || bestMatchQualifiers != null && !qualifiers.isBetterThan(bestMatchQualifiers, toMatch)) continue;
            bestMatchQualifiers = qualifiers;
            bestMatch = value;
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        return values.get(0);
    }

    public int size() {
        return this.valuesMap.size() + this.valuesArrayMap.size();
    }

    public void makeImmutable() {
        this.valuesMap.makeImmutable();
        this.valuesArrayMap.makeImmutable();
    }

    public void overrideNamespace(String overrideNamespace) {
        this.overrideNamespace = overrideNamespace;
        if (this.size() > 0) {
            throw new RuntimeException();
        }
    }

    String maybeOverride(String namespace) {
        return this.overrideNamespace == null ? namespace : this.overrideNamespace;
    }

    ResName maybeOverride(ResName resName) {
        return this.overrideNamespace == null ? resName : new ResName(this.overrideNamespace, resName.type, resName.name);
    }

    public void mergeLibraryStyle(ResBundle<T> fromResBundle, String packageName) {
        ((ResMap)this.valuesMap).merge(packageName, (ResMap)fromResBundle.valuesMap);
        ((ResMap)this.valuesArrayMap).merge(packageName, (ResMap)fromResBundle.valuesArrayMap);
    }

    private static class Qualifiers {
        private static final int ORDER_VERSION = 0;
        private static final List<String> INT_QUALIFIERS = Arrays.asList("v", "h", "w", "sh", "sw");
        private static final int TOTAL_ORDER_COUNT = INT_QUALIFIERS.size();
        private static Map<String, Qualifiers> sQualifiersCache = new HashMap<String, Qualifiers>();
        private final int[] mWeights = new int[TOTAL_ORDER_COUNT];
        private final List<String> mDefaults = new ArrayList<String>();

        private Qualifiers() {
        }

        public boolean matches(Qualifiers other) {
            for (int i = 0; i < TOTAL_ORDER_COUNT; ++i) {
                if (other.mWeights[i] == -1 || this.mWeights[i] == -1 || other.mWeights[i] >= this.mWeights[i]) continue;
                return false;
            }
            return other.mDefaults.containsAll(this.mDefaults);
        }

        public boolean isBetterThan(Qualifiers other, Qualifiers context) {
            for (String qualifier : context.mDefaults) {
                if (!(other.mDefaults.contains(qualifier) ^ this.mDefaults.contains(qualifier))) continue;
                return this.mDefaults.contains(qualifier);
            }
            for (int i = TOTAL_ORDER_COUNT - 1; i > 0; --i) {
                if (other.mWeights[i] == this.mWeights[i]) continue;
                return this.mWeights[i] > other.mWeights[i];
            }
            if (context.mWeights[0] != -1 && other.mWeights[0] != this.mWeights[0]) {
                return this.mWeights[0] > other.mWeights[0];
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Qualifiers parse(String qualifiersStr) {
            Map<String, Qualifiers> map = sQualifiersCache;
            synchronized (map) {
                Qualifiers result = sQualifiersCache.get(qualifiersStr);
                if (result != null) {
                    return result;
                }
                StringTokenizer st = new StringTokenizer(qualifiersStr, "-");
                result = new Qualifiers();
                result.mWeights[0] = -1;
                while (st.hasMoreTokens()) {
                    String qualifier = st.nextToken();
                    if (qualifier.isEmpty()) continue;
                    Matcher m = VERSION_QUALIFIER_PATTERN.matcher(qualifier);
                    if (!m.find() && !(m = SIZE_QUALIFIER_PATTERN.matcher(qualifier)).find()) {
                        m = null;
                    }
                    if (m != null) {
                        int order = INT_QUALIFIERS.indexOf(m.group(1));
                        if (order == 0 && result.mWeights[0] != -1) {
                            throw new IllegalStateException("A resource file was found that had two API level qualifiers: " + qualifiersStr);
                        }
                        result.mWeights[order] = Integer.parseInt(m.group(2));
                        continue;
                    }
                    result.mDefaults.add(qualifier);
                }
                sQualifiersCache.put(qualifiersStr, result);
                return result;
            }
        }
    }

    private static class ResMap<T> {
        private final Map<ResName, List<Value<T>>> map = new HashMap<ResName, List<Value<T>>>();
        private boolean immutable;

        private ResMap() {
        }

        public List<Value<T>> find(ResName resName) {
            List<Value<T>> values = this.map.get(resName);
            if (values == null) {
                values = new ArrayList<Value<T>>();
                this.map.put(resName, values);
            }
            return values;
        }

        private void merge(String packageName, ResMap<T> sourceMap) {
            if (this.immutable) {
                throw new IllegalStateException("immutable!");
            }
            for (Map.Entry<ResName, List<Value<T>>> entry : sourceMap.map.entrySet()) {
                ResName resName = entry.getKey().withPackageName(packageName);
                this.find(resName).addAll((Collection)entry.getValue());
            }
        }

        public int size() {
            return this.map.size();
        }

        public void makeImmutable() {
            this.immutable = true;
        }
    }

    public static class Value<T>
    implements Comparable<Value<T>> {
        private final String qualifiers;
        private final T value;

        Value(String qualifiers, T value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.qualifiers = qualifiers == null ? "--" : "-" + qualifiers + "-";
            this.value = value;
        }

        public String getQualifiers() {
            return this.qualifiers;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Value<T> o) {
            return this.qualifiers.compareTo(o.qualifiers);
        }

        public String toString() {
            return "Value{qualifiers='" + this.qualifiers + '\'' + ", value=" + this.value + '}';
        }
    }
}

