/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.DrawableNode;
import org.robolectric.res.FsFile;
import org.robolectric.res.Plural;
import org.robolectric.res.PluralResourceLoader;
import org.robolectric.res.PreferenceNode;
import org.robolectric.res.ResBunch;
import org.robolectric.res.ResBundle;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.TypedResource;
import org.robolectric.res.builder.XmlBlock;

abstract class XResourceLoader
implements ResourceLoader {
    final ResBunch data = new ResBunch();
    final ResBundle<PluralResourceLoader.PluralRules> pluralsData = new ResBundle();
    final ResBundle<String> stringData = new ResBundle();
    final ResBundle<DrawableNode> drawableData = new ResBundle();
    final ResBundle<PreferenceNode> preferenceData = new ResBundle();
    final ResBundle<XmlBlock> xmlDocuments = new ResBundle();
    final ResBundle<FsFile> rawResources = new ResBundle();
    private final ResourceIndex resourceIndex;
    boolean isInitialized = false;

    protected XResourceLoader(ResourceIndex resourceIndex) {
        this.resourceIndex = resourceIndex;
    }

    abstract void doInitialize();

    synchronized void initialize() {
        if (this.isInitialized) {
            return;
        }
        this.doInitialize();
        this.isInitialized = true;
        this.makeImmutable();
    }

    protected void makeImmutable() {
        this.data.makeImmutable();
        this.pluralsData.makeImmutable();
        this.stringData.makeImmutable();
        this.drawableData.makeImmutable();
        this.preferenceData.makeImmutable();
        this.xmlDocuments.makeImmutable();
        this.rawResources.makeImmutable();
    }

    @Override
    public String getNameForId(int id) {
        return this.resourceIndex.getResourceName(id);
    }

    @Override
    public TypedResource getValue(@NotNull ResName resName, String qualifiers) {
        this.initialize();
        ResBundle.Value<TypedResource> value = this.data.getValue(resName, qualifiers);
        return value == null ? null : value.getValue();
    }

    @Override
    public Plural getPlural(ResName resName, int quantity, String qualifiers) {
        this.initialize();
        PluralResourceLoader.PluralRules pluralRules = this.pluralsData.get(resName, qualifiers);
        if (pluralRules == null) {
            return null;
        }
        return pluralRules.find(quantity);
    }

    @Override
    public XmlBlock getXml(ResName resName, String qualifiers) {
        this.initialize();
        return this.xmlDocuments.get(resName, qualifiers);
    }

    @Override
    public DrawableNode getDrawableNode(ResName resName, String qualifiers) {
        return this.drawableData.get(resName, qualifiers);
    }

    @Override
    public InputStream getRawValue(ResName resName) {
        this.initialize();
        FsFile file = this.rawResources.get(resName, "");
        try {
            return file == null ? null : file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PreferenceNode getPreferenceNode(ResName resName, String qualifiers) {
        this.initialize();
        return this.preferenceData.get(resName, qualifiers);
    }

    @Override
    public ResourceIndex getResourceIndex() {
        return this.resourceIndex;
    }
}

