/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.List;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.Plural;
import org.robolectric.res.ResType;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlContext;
import org.robolectric.res.XpathResourceXmlLoader;

public class PluralResourceLoader
extends XpathResourceXmlLoader {
    private PackageResourceTable resourceTable;

    public PluralResourceLoader(PackageResourceTable resourceTable) {
        super("/resources/plurals");
        this.resourceTable = resourceTable;
    }

    @Override
    protected void processNode(String name, XpathResourceXmlLoader.XmlNode xmlNode, XmlContext xmlContext) {
        ArrayList<Plural> rules = new ArrayList<Plural>();
        for (XpathResourceXmlLoader.XmlNode item : xmlNode.selectElements("item")) {
            String value = item.getTextContent();
            String quantity = item.getAttrValue("quantity");
            rules.add(new Plural(quantity, value));
        }
        this.resourceTable.addResource("plurals", name, new PluralRules((List<Plural>)rules, ResType.CHAR_SEQUENCE, xmlContext));
    }

    public static class PluralRules
    extends TypedResource<List<Plural>> {
        public PluralRules(List<Plural> data, ResType resType, XmlContext xmlContext) {
            super(data, resType, xmlContext);
        }

        public Plural find(int quantity) {
            for (Plural p : (List)this.getData()) {
                if (p.num != quantity) continue;
                return p;
            }
            for (Plural p : (List)this.getData()) {
                if (p.num != -1) continue;
                return p;
            }
            return null;
        }
    }
}

