/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.robolectric.res.AttrResourceLoader;
import org.robolectric.res.ColorResourceLoader;
import org.robolectric.res.DocumentLoader;
import org.robolectric.res.DrawableResourceLoader;
import org.robolectric.res.OpaqueFileLoader;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.PluralResourceLoader;
import org.robolectric.res.RawResourceLoader;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.StyleResourceLoader;
import org.robolectric.res.ValueResourceLoader;
import org.robolectric.util.Logger;

public class ResourceTableFactory {
    public static PackageResourceTable newFrameworkResourceTable(ResourcePath resourcePath) {
        PackageResourceTable resourceTable = new PackageResourceTable("android");
        if (resourcePath.getRClass() != null) {
            ResourceTableFactory.addRClassValues(resourceTable, resourcePath.getRClass());
            ResourceTableFactory.addMissingStyleableAttributes(resourceTable, resourcePath.getRClass());
        }
        if (resourcePath.getInternalRClass() != null) {
            ResourceTableFactory.addRClassValues(resourceTable, resourcePath.getInternalRClass());
            ResourceTableFactory.addMissingStyleableAttributes(resourceTable, resourcePath.getInternalRClass());
        }
        ResourceTableFactory.parseResourceFiles(resourcePath, resourceTable);
        return resourceTable;
    }

    public static PackageResourceTable newResourceTable(String packageName, ResourcePath ... resourcePaths) {
        PackageResourceTable resourceTable = new PackageResourceTable(packageName);
        for (ResourcePath resourcePath : resourcePaths) {
            if (resourcePath.getRClass() == null) continue;
            ResourceTableFactory.addRClassValues(resourceTable, resourcePath.getRClass());
        }
        for (ResourcePath resourcePath : resourcePaths) {
            ResourceTableFactory.parseResourceFiles(resourcePath, resourceTable);
        }
        return resourceTable;
    }

    private static void addRClassValues(PackageResourceTable resourceTable, Class<?> rClass) {
        for (Class<?> innerClass : rClass.getClasses()) {
            String resourceType = innerClass.getSimpleName();
            if (resourceType.equals("styleable")) continue;
            for (Field field : innerClass.getDeclaredFields()) {
                int id;
                if (!field.getType().equals(Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
                try {
                    id = field.getInt(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                String resourceName = field.getName();
                resourceTable.addResource(id, resourceType, resourceName);
            }
        }
    }

    private static void addMissingStyleableAttributes(PackageResourceTable resourceTable, Class<?> rClass) {
        for (Class<?> innerClass : rClass.getClasses()) {
            if (!innerClass.getSimpleName().equals("styleable")) continue;
            String styleableName = null;
            int[] styleableArray = null;
            for (Field field : innerClass.getDeclaredFields()) {
                if (field.getType().equals(int[].class) && Modifier.isStatic(field.getModifiers())) {
                    styleableName = field.getName();
                    try {
                        styleableArray = (int[])field.get(null);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!field.getType().equals(Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
                String attributeName = field.getName().substring(styleableName.length() + 1);
                try {
                    int styleableIndex = field.getInt(null);
                    int attributeResId = styleableArray[styleableIndex];
                    resourceTable.addResource(attributeResId, "attr", attributeName);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void parseResourceFiles(ResourcePath resourcePath, PackageResourceTable resourceTable) {
        if (!resourcePath.hasResources()) {
            Logger.debug((String)"No resources for %s", (Object[])new Object[]{resourceTable.getPackageName()});
            return;
        }
        Logger.debug((String)"Loading resources for %s from %s...", (Object[])new Object[]{resourceTable.getPackageName(), resourcePath.getResourceBase()});
        DocumentLoader documentLoader = new DocumentLoader(resourceTable.getPackageName(), resourcePath);
        try {
            documentLoader.load("values", new ValueResourceLoader(resourceTable, "/resources/bool", "bool", ResType.BOOLEAN), new ValueResourceLoader(resourceTable, "/resources/item[@type='bool']", "bool", ResType.BOOLEAN), new ValueResourceLoader(resourceTable, "/resources/color", "color", ResType.COLOR), new ValueResourceLoader(resourceTable, "/resources/drawable", "drawable", ResType.DRAWABLE), new ValueResourceLoader(resourceTable, "/resources/item[@type='color']", "color", ResType.COLOR), new ValueResourceLoader(resourceTable, "/resources/item[@type='drawable']", "drawable", ResType.DRAWABLE), new ValueResourceLoader(resourceTable, "/resources/dimen", "dimen", ResType.DIMEN), new ValueResourceLoader(resourceTable, "/resources/item[@type='dimen']", "dimen", ResType.DIMEN), new ValueResourceLoader(resourceTable, "/resources/integer", "integer", ResType.INTEGER), new ValueResourceLoader(resourceTable, "/resources/item[@type='integer']", "integer", ResType.INTEGER), new ValueResourceLoader(resourceTable, "/resources/integer-array", "array", ResType.INTEGER_ARRAY), new ValueResourceLoader(resourceTable, "/resources/fraction", "fraction", ResType.FRACTION), new ValueResourceLoader(resourceTable, "/resources/item[@type='fraction']", "fraction", ResType.FRACTION), new ValueResourceLoader(resourceTable, "/resources/item[@type='layout']", "layout", ResType.LAYOUT), new PluralResourceLoader(resourceTable), new ValueResourceLoader(resourceTable, "/resources/string", "string", ResType.CHAR_SEQUENCE), new ValueResourceLoader(resourceTable, "/resources/item[@type='string']", "string", ResType.CHAR_SEQUENCE), new ValueResourceLoader(resourceTable, "/resources/string-array", "array", ResType.CHAR_SEQUENCE_ARRAY), new ValueResourceLoader(resourceTable, "/resources/array", "array", ResType.TYPED_ARRAY), new ValueResourceLoader(resourceTable, "/resources/id", "id", ResType.CHAR_SEQUENCE), new ValueResourceLoader(resourceTable, "/resources/item[@type='id']", "id", ResType.CHAR_SEQUENCE), new AttrResourceLoader(resourceTable), new StyleResourceLoader(resourceTable));
            documentLoader.load("layout", new OpaqueFileLoader(resourceTable, "layout"));
            documentLoader.load("menu", new OpaqueFileLoader(resourceTable, "menu"));
            documentLoader.load("drawable", new OpaqueFileLoader(resourceTable, "drawable", ResType.DRAWABLE));
            documentLoader.load("anim", new OpaqueFileLoader(resourceTable, "anim"));
            documentLoader.load("animator", new OpaqueFileLoader(resourceTable, "animator"));
            documentLoader.load("color", new ColorResourceLoader(resourceTable));
            documentLoader.load("xml", new OpaqueFileLoader(resourceTable, "xml"));
            documentLoader.load("transition", new OpaqueFileLoader(resourceTable, "transition"));
            documentLoader.load("interpolator", new OpaqueFileLoader(resourceTable, "interpolator"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        new DrawableResourceLoader(resourceTable).findDrawableResources(resourcePath);
        new RawResourceLoader(resourcePath).loadTo(resourceTable);
    }
}

