/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.XmlContext;
import org.robolectric.res.XmlLoader;

public abstract class XpathResourceXmlLoader
implements XmlLoader {
    private final String expression;

    public XpathResourceXmlLoader(String expression) {
        this.expression = expression;
    }

    @Override
    public void processResourceXml(XmlNode xmlNode, XmlContext xmlContext) {
        try {
            for (XmlNode node : xmlNode.selectByXpath(this.expression)) {
                String name = node.getAttrValue("name");
                this.processNode(name, node, xmlContext);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing " + xmlContext.getXmlFile(), e);
        }
    }

    protected abstract void processNode(String var1, XmlNode var2, XmlContext var3);

    public static class XmlNode {
        private final VTDNav vtdNav;

        public XmlNode(VTDNav vtdNav) {
            this.vtdNav = vtdNav;
        }

        public String getElementName() {
            try {
                return this.vtdNav.toString(this.vtdNav.getCurrentIndex());
            }
            catch (NavException e) {
                throw new RuntimeException(e);
            }
        }

        public XmlNode getFirstChild() {
            try {
                VTDNav cloneVtdNav = this.vtdNav.cloneNav();
                if (!cloneVtdNav.toElement(2)) {
                    return null;
                }
                return new XmlNode(cloneVtdNav);
            }
            catch (NavException e) {
                throw new RuntimeException(e);
            }
        }

        public String getTextContent() {
            try {
                return this.vtdNav.getXPathStringVal();
            }
            catch (NavException e) {
                throw new RuntimeException(e);
            }
        }

        public Iterable<XmlNode> selectByXpath(String expr) throws XPathParseException {
            VTDNav cloneVtdNav = this.vtdNav.cloneNav();
            final AutoPilot ap = new AutoPilot(cloneVtdNav);
            ap.selectXPath(expr);
            return this.returnIterable(new Iterator(ap, cloneVtdNav){

                @Override
                boolean doHasNext() throws XPathEvalException, NavException {
                    int result = ap.evalXPath();
                    if (result == -1) {
                        ap.resetXPath();
                    }
                    return result != -1;
                }
            });
        }

        public Iterable<XmlNode> selectElements(String name) {
            VTDNav cloneVtdNav = this.vtdNav.cloneNav();
            final AutoPilot ap = new AutoPilot(cloneVtdNav);
            ap.selectElement(name);
            return this.returnIterable(new Iterator(ap, cloneVtdNav){

                @Override
                boolean doHasNext() throws XPathEvalException, NavException {
                    return ap.iterate();
                }
            });
        }

        private Iterable<XmlNode> returnIterable(final Iterator iterator) {
            return new Iterable<XmlNode>(){

                @Override
                @NotNull
                public java.util.Iterator<XmlNode> iterator() {
                    return iterator;
                }
            };
        }

        public String getAttrValue(String attrName) {
            try {
                int nameIndex = this.vtdNav.getAttrVal(attrName);
                return nameIndex == -1 ? null : this.vtdNav.toNormalizedString(nameIndex);
            }
            catch (NavException e) {
                throw new RuntimeException(e);
            }
        }

        public void pushLocation() {
            this.vtdNav.push();
        }

        public void popLocation() {
            this.vtdNav.pop();
        }

        public boolean moveToParent() {
            try {
                return this.vtdNav.toElement(1);
            }
            catch (NavException e) {
                throw new RuntimeException(e);
            }
        }

        private abstract class Iterator
        implements java.util.Iterator<XmlNode> {
            private final AutoPilot ap;
            private final VTDNav vtdNav;

            public Iterator(AutoPilot ap, VTDNav vtdNav) {
                this.ap = ap;
                this.vtdNav = vtdNav;
            }

            @Override
            public boolean hasNext() {
                try {
                    return this.doHasNext();
                }
                catch (NavException | XPathEvalException e) {
                    throw new RuntimeException(e);
                }
            }

            abstract boolean doHasNext() throws XPathEvalException, NavException;

            @Override
            public XmlNode next() {
                return new XmlNode(this.vtdNav);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

