/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.FileTypedResource;
import org.robolectric.res.FsFile;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.StartsWithFilter;
import org.robolectric.res.XmlContext;

public class RawResourceLoader {
    private final ResourcePath resourcePath;

    public RawResourceLoader(ResourcePath resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void loadTo(PackageResourceTable resourceTable) {
        this.load(resourceTable, "raw");
        this.load(resourceTable, "drawable");
    }

    public void load(PackageResourceTable resourceTable, String folderBaseName) {
        FsFile resourceBase = this.resourcePath.getResourceBase();
        FsFile[] files = resourceBase.listFiles(new StartsWithFilter(folderBaseName));
        if (files == null) {
            throw new RuntimeException(resourceBase.join(folderBaseName) + " is not a directory");
        }
        for (FsFile dir : files) {
            this.loadRawFiles(resourceTable, folderBaseName, dir);
        }
    }

    private void loadRawFiles(PackageResourceTable resourceTable, String resourceType, FsFile rawDir) {
        FsFile[] files = rawDir.listFiles();
        if (files != null) {
            for (FsFile file : files) {
                String fileBaseName = file.getBaseName();
                resourceTable.addResource(resourceType, fileBaseName, new FileTypedResource(file, ResType.FILE, new XmlContext(resourceTable.getPackageName(), file)));
            }
        }
    }
}

