/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.builder;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.Nullable;
import org.robolectric.res.FsFile;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlBlock {
    private static DocumentBuilder documentBuilder;
    private final Document document;
    private final String filename;
    private final String packageName;

    private static synchronized Document parse(FsFile xmlFile) {
        InputStream inputStream = null;
        try {
            Object documentBuilderFactory;
            if (documentBuilder == null) {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)documentBuilderFactory).setNamespaceAware(true);
                ((DocumentBuilderFactory)documentBuilderFactory).setIgnoringComments(true);
                ((DocumentBuilderFactory)documentBuilderFactory).setIgnoringElementContentWhitespace(true);
                documentBuilder = ((DocumentBuilderFactory)documentBuilderFactory).newDocumentBuilder();
            }
            inputStream = xmlFile.getInputStream();
            documentBuilderFactory = documentBuilder.parse(inputStream);
            return documentBuilderFactory;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Nullable
    public static XmlBlock create(FsFile fsFile, String packageName) {
        Document document = XmlBlock.parse(fsFile);
        return document == null ? null : new XmlBlock(document, fsFile.getPath(), packageName);
    }

    private XmlBlock(Document document, String filename, String packageName) {
        this.document = document;
        this.filename = filename;
        this.packageName = packageName;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

