/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool.locks;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import scala.actors.threadpool.TimeUnit;
import scala.actors.threadpool.helpers.Utils;
import scala.actors.threadpool.locks.Condition;
import scala.actors.threadpool.locks.Lock;

class CondVar
implements Condition,
Serializable {
    private static final long serialVersionUID = -5009898475638427940L;
    protected final ExclusiveLock lock;

    CondVar(ExclusiveLock exclusiveLock) {
        this.lock = exclusiveLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitUninterruptibly() {
        int n = this.lock.getHoldCount();
        if (n == 0) {
            throw new IllegalMonitorStateException();
        }
        boolean bl = Thread.interrupted();
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = n; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
        }
        finally {
            for (int i = n; i > 0; --i) {
                this.lock.lock();
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        int n = this.lock.getHoldCount();
        if (n == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = n; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            for (int i = n; i > 0; --i) {
                this.lock.lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
        int n = this.lock.getHoldCount();
        if (n == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long l2 = timeUnit.toNanos(l);
        boolean bl = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = n; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    if (l2 > 0L) {
                        long l3 = Utils.nanoTime();
                        TimeUnit.NANOSECONDS.timedWait(this, l2);
                        bl = Utils.nanoTime() - l3 < l2;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            for (int i = n; i > 0; --i) {
                this.lock.lock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitUntil(Date date) throws InterruptedException {
        if (date == null) {
            throw new NullPointerException();
        }
        int n = this.lock.getHoldCount();
        if (n == 0) {
            throw new IllegalMonitorStateException();
        }
        long l = date.getTime();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean bl = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = n; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    long l2 = System.currentTimeMillis();
                    long l3 = l - l2;
                    if (l3 > 0L) {
                        this.wait(l3);
                        bl = System.currentTimeMillis() - l2 < l3;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            for (int i = n; i > 0; --i) {
                this.lock.lock();
            }
        }
        return bl;
    }

    @Override
    public synchronized void signal() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notify();
    }

    @Override
    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    protected ExclusiveLock getLock() {
        return this.lock;
    }

    protected boolean hasWaiters() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected int getWaitQueueLength() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected Collection getWaitingThreads() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    static interface ExclusiveLock
    extends Lock {
        public boolean isHeldByCurrentThread();

        public int getHoldCount();
    }
}

