/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.FilteringDependencyNodeVisitor;
import org.codehaus.plexus.util.StringUtils;
import org_scala_tools_maven.BasicArtifact;
import org_scala_tools_maven.VersionNumber;
import org_scala_tools_maven_dependency.CheckScalaVersionVisitor;
import org_scala_tools_maven_dependency.ScalaDistroArtifactFilter;
import org_scala_tools_maven_executions.JavaMainCaller;
import org_scala_tools_maven_executions.JavaMainCallerByFork;
import org_scala_tools_maven_executions.JavaMainCallerInProcess;
import org_scala_tools_maven_executions.JavaMainCallerSupport;
import org_scala_tools_maven_executions.MainHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScalaMojoSupport
extends AbstractMojo {
    public static final String SCALA_GROUPID = "org.scala-lang";
    public static final String SCALA_LIBRARY_ARTIFACTID = "scala-library";
    protected MavenProject project;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected ArtifactRepository localRepo;
    protected List<?> remoteRepos;
    protected BasicArtifact[] dependencies;
    protected BasicArtifact[] compilerPlugins;
    protected String[] jvmArgs;
    protected String[] args;
    protected String scalaClassName;
    protected String scalaVersion;
    public boolean displayCmd;
    protected boolean fork = true;
    protected boolean forceUseArgFile = false;
    protected boolean checkMultipleScalaVersions;
    protected boolean failOnMultipleScalaVersions = false;
    protected MavenProjectBuilder mavenProjectBuilder;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;

    protected Set<Artifact> resolveDependencyArtifacts(MavenProject theProject) throws Exception {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new ScopeArtifactFilter("test"));
        filter.add(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !artifact.isOptional();
            }
        });
        Set artifacts = theProject.createArtifacts(this.factory, "runtime", (ArtifactFilter)filter);
        for (Artifact artifact : artifacts) {
            this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        }
        return artifacts;
    }

    protected Set<Artifact> resolveArtifactDependencies(Artifact artifact) throws Exception {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepos, this.localRepo);
        return this.resolveDependencyArtifacts(pomProject);
    }

    public void addToClasspath(String groupId, String artifactId, String version, Set<String> classpath) throws Exception {
        this.addToClasspath(groupId, artifactId, version, classpath, true);
    }

    public void addToClasspath(String groupId, String artifactId, String version, Set<String> classpath, boolean addDependencies) throws Exception {
        this.addToClasspath(this.factory.createArtifact(groupId, artifactId, version, "runtime", "jar"), classpath, addDependencies);
    }

    protected void addToClasspath(Artifact artifact, Set<String> classpath, boolean addDependencies) throws Exception {
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        classpath.add(artifact.getFile().getCanonicalPath());
        if (addDependencies) {
            for (Artifact dep : this.resolveArtifactDependencies(artifact)) {
                this.addToClasspath(dep, classpath, addDependencies);
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String oldWay = System.getProperty("maven.scala.version");
            if (oldWay != null) {
                this.getLog().warn((CharSequence)"using 'maven.scala.version' is deprecated, use 'scala.version' instead");
                if (this.scalaVersion != null) {
                    this.scalaVersion = oldWay;
                }
            }
            if ((oldWay = System.getProperty("maven.scala.displayCmd")) != null) {
                this.getLog().warn((CharSequence)"using 'maven.scala.displayCmd' is deprecated, use 'displayCmd' instead");
                this.displayCmd = this.displayCmd || Boolean.parseBoolean(oldWay);
            }
            this.checkScalaVersion();
            this.doExecute();
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (MojoFailureException exc) {
            throw exc;
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException("wrap: " + exc, exc);
        }
    }

    protected List<Dependency> getDependencies() {
        return this.project.getCompileDependencies();
    }

    protected void checkScalaVersion() throws Exception {
        String detectedScalaVersion = null;
        for (Dependency dep : this.getDependencies()) {
            if (!SCALA_GROUPID.equals(dep.getGroupId()) || !SCALA_LIBRARY_ARTIFACTID.equals(dep.getArtifactId())) continue;
            detectedScalaVersion = dep.getVersion();
        }
        if (StringUtils.isEmpty(detectedScalaVersion)) {
            ArrayList deps = new ArrayList();
            deps.addAll(this.project.getModel().getDependencies());
            if (this.project.getModel().getDependencyManagement() != null) {
                deps.addAll(this.project.getModel().getDependencyManagement().getDependencies());
            }
            for (Dependency dep : deps) {
                if (!SCALA_GROUPID.equals(dep.getGroupId()) || !SCALA_LIBRARY_ARTIFACTID.equals(dep.getArtifactId())) continue;
                detectedScalaVersion = dep.getVersion();
            }
        }
        if (StringUtils.isEmpty(detectedScalaVersion)) {
            if (!"pom".equals(this.project.getPackaging().toLowerCase())) {
                this.getLog().warn((CharSequence)"you don't define org.scala-lang:scala-library as a dependency of the project");
            }
        } else {
            boolean isSnapshot = ArtifactUtils.isSnapshot(detectedScalaVersion);
            if (isSnapshot && !detectedScalaVersion.endsWith("-SNAPSHOT")) {
                detectedScalaVersion = detectedScalaVersion.substring(0, detectedScalaVersion.lastIndexOf(45, detectedScalaVersion.lastIndexOf(45) - 1)) + "-SNAPSHOT";
            }
            if (StringUtils.isNotEmpty((String)this.scalaVersion)) {
                if (!this.scalaVersion.equals(detectedScalaVersion)) {
                    this.getLog().warn((CharSequence)"scala library version define in dependencies doesn't match the scalaVersion of the plugin");
                }
            } else {
                this.scalaVersion = detectedScalaVersion;
            }
        }
        if (StringUtils.isEmpty((String)this.scalaVersion)) {
            throw new MojoFailureException("no scalaVersion detected or set");
        }
        if (this.checkMultipleScalaVersions) {
            this.checkCorrectVersionsOfScalaLibrary();
        }
    }

    private void checkCorrectVersionsOfScalaLibrary() throws Exception {
        this.getLog().info((CharSequence)"Checking for multiple versions of scala");
        this.checkArtifactForScalaVersion(this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector));
    }

    private void checkArtifactForScalaVersion(DependencyNode rootNode) throws Exception {
        CheckScalaVersionVisitor visitor = new CheckScalaVersionVisitor(this.scalaVersion, this.getLog());
        CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
        FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, this.createScalaDistroDependencyFilter());
        rootNode.accept((DependencyNodeVisitor)firstPassVisitor);
        AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
        FilteringDependencyNodeVisitor filteredVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)visitor, (DependencyNodeFilter)secondPassFilter);
        rootNode.accept((DependencyNodeVisitor)filteredVisitor);
        if (visitor.isFailed()) {
            visitor.logScalaDependents();
            if (this.failOnMultipleScalaVersions) {
                this.getLog().error((CharSequence)"Multiple versions of scala libraries detected!");
                throw new MojoFailureException("Multiple versions of scala libraries detected!");
            }
            this.getLog().warn((CharSequence)"Multiple versions of scala libraries detected!");
        }
    }

    private DependencyNodeFilter createScalaDistroDependencyFilter() {
        ArrayList<ScalaDistroArtifactFilter> filters = new ArrayList<ScalaDistroArtifactFilter>();
        filters.add(new ScalaDistroArtifactFilter());
        return new AndDependencyNodeFilter(filters);
    }

    protected abstract void doExecute() throws Exception;

    protected JavaMainCaller getScalaCommand() throws Exception {
        JavaMainCaller cmd = this.getEmptyScalaCommand(this.scalaClassName);
        cmd.addArgs(this.args);
        this.addCompilerPluginOptions(cmd);
        cmd.addJvmArgs(this.jvmArgs);
        return cmd;
    }

    protected JavaMainCaller getEmptyScalaCommand(String mainClass) throws Exception {
        JavaMainCallerSupport cmd;
        if (this.fork) {
            this.getLog().debug((CharSequence)("use java command with args in file forced : " + this.forceUseArgFile));
            cmd = new JavaMainCallerByFork(this, mainClass, this.getToolClasspath(), null, null, this.forceUseArgFile);
        } else {
            cmd = new JavaMainCallerInProcess(this, mainClass, this.getToolClasspath(), null, null);
        }
        cmd.addJvmArgs("-Xbootclasspath/a:" + this.getBootClasspath());
        return cmd;
    }

    private String getToolClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath(SCALA_GROUPID, "scala-compiler", this.scalaVersion, classpath);
        if (this.dependencies != null) {
            for (BasicArtifact artifact : this.dependencies) {
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, classpath);
            }
        }
        return MainHelper.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }

    private String getBootClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID, this.scalaVersion, classpath);
        return MainHelper.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }

    protected boolean isJavaSupportedByCompiler() {
        return new VersionNumber(this.scalaVersion).compareTo(new VersionNumber("2.7.2")) >= 0;
    }

    protected void addCompilerPluginOptions(JavaMainCaller scalac) throws Exception {
        for (String plugin : this.getCompilerPlugins()) {
            scalac.addArgs("-Xplugin:" + plugin);
        }
    }

    private Set<String> getCompilerPlugins() throws Exception {
        HashSet<String> plugins = new HashSet<String>();
        if (this.compilerPlugins != null) {
            HashSet<String> ignoreClasspath = new HashSet<String>();
            this.addToClasspath(SCALA_GROUPID, "scala-compiler", this.scalaVersion, ignoreClasspath);
            this.addToClasspath(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID, this.scalaVersion, ignoreClasspath);
            for (BasicArtifact artifact : this.compilerPlugins) {
                this.getLog().info((CharSequence)("compiler plugin: " + artifact.toString()));
                HashSet<String> pluginClassPath = new HashSet<String>();
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, pluginClassPath, false);
                pluginClassPath.removeAll(ignoreClasspath);
                plugins.addAll(pluginClassPath);
            }
        }
        return plugins;
    }
}

