/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.browser.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PermissionDescriptor {
    private final String name;
    private final Optional<Boolean> sysex;
    private final Optional<Boolean> userVisibleOnly;
    private final Optional<Boolean> allowWithoutSanitization;
    private final Optional<Boolean> panTiltZoom;

    public PermissionDescriptor(String name, Optional<Boolean> sysex, Optional<Boolean> userVisibleOnly, Optional<Boolean> allowWithoutSanitization, Optional<Boolean> panTiltZoom) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.sysex = sysex;
        this.userVisibleOnly = userVisibleOnly;
        this.allowWithoutSanitization = allowWithoutSanitization;
        this.panTiltZoom = panTiltZoom;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Boolean> getSysex() {
        return this.sysex;
    }

    public Optional<Boolean> getUserVisibleOnly() {
        return this.userVisibleOnly;
    }

    public Optional<Boolean> getAllowWithoutSanitization() {
        return this.allowWithoutSanitization;
    }

    public Optional<Boolean> getPanTiltZoom() {
        return this.panTiltZoom;
    }

    private static PermissionDescriptor fromJson(JsonInput input) {
        String name = null;
        Optional<Boolean> sysex = Optional.empty();
        Optional<Boolean> userVisibleOnly = Optional.empty();
        Optional<Boolean> allowWithoutSanitization = Optional.empty();
        Optional<Boolean> panTiltZoom = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block14;
                }
                case "sysex": {
                    sysex = Optional.ofNullable(input.nextBoolean());
                    continue block14;
                }
                case "userVisibleOnly": {
                    userVisibleOnly = Optional.ofNullable(input.nextBoolean());
                    continue block14;
                }
                case "allowWithoutSanitization": {
                    allowWithoutSanitization = Optional.ofNullable(input.nextBoolean());
                    continue block14;
                }
                case "panTiltZoom": {
                    panTiltZoom = Optional.ofNullable(input.nextBoolean());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PermissionDescriptor(name, sysex, userVisibleOnly, allowWithoutSanitization, panTiltZoom);
    }
}

