/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.Expose;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.DefaultCapabilityMatcher;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;

public class GridHubConfiguration
extends GridConfiguration {
    public static final String DEFAULT_HUB_CONFIG_FILE = "org/openqa/grid/common/defaults/DefaultHub.json";
    static final String DEFAULT_ROLE = "hub";
    static final Integer DEFAULT_PORT = 4444;
    static final Integer DEFAULT_CLEANUP_CYCLE = 5000;
    static final Integer DEFAULT_NEW_SESSION_WAIT_TIMEOUT = -1;
    static final Boolean DEFAULT_THROW_ON_CAPABILITY_NOT_PRESENT_TOGGLE = true;
    static final String DEFAULT_HUB_REGISTRY_CLASS = "org.openqa.grid.internal.DefaultGridRegistry";
    public String hubConfig;
    @Expose
    public CapabilityMatcher capabilityMatcher = new DefaultCapabilityMatcher();
    @Expose
    public Integer newSessionWaitTimeout = DEFAULT_NEW_SESSION_WAIT_TIMEOUT;
    @Expose
    public Prioritizer prioritizer;
    @Expose
    public Boolean throwOnCapabilityNotPresent = DEFAULT_THROW_ON_CAPABILITY_NOT_PRESENT_TOGGLE;
    @Expose
    public String registry = "org.openqa.grid.internal.DefaultGridRegistry";

    public GridHubConfiguration() {
        this.role = DEFAULT_ROLE;
        this.port = DEFAULT_PORT;
        this.cleanUpCycle = DEFAULT_CLEANUP_CYCLE;
    }

    public static GridHubConfiguration loadFromJSON(String filePath) {
        return GridHubConfiguration.loadFromJSON(GridHubConfiguration.loadJSONFromResourceOrFile(filePath));
    }

    public static GridHubConfiguration loadFromJSON(JsonObject json) {
        try {
            GsonBuilder builder = new GsonBuilder();
            GridHubConfiguration.staticAddJsonTypeAdapter(builder);
            return (GridHubConfiguration)builder.excludeFieldsWithoutExposeAnnotation().create().fromJson((JsonElement)json, GridHubConfiguration.class);
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public void merge(GridNodeConfiguration other) {
        super.merge(other);
    }

    public void merge(GridHubConfiguration other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        if (this.isMergeAble(other.capabilityMatcher, this.capabilityMatcher)) {
            this.capabilityMatcher = other.capabilityMatcher;
        }
        if (this.isMergeAble(other.newSessionWaitTimeout, this.newSessionWaitTimeout)) {
            this.newSessionWaitTimeout = other.newSessionWaitTimeout;
        }
        if (this.isMergeAble(other.prioritizer, this.prioritizer)) {
            this.prioritizer = other.prioritizer;
        }
        if (this.isMergeAble(other.throwOnCapabilityNotPresent, this.throwOnCapabilityNotPresent)) {
            this.throwOnCapabilityNotPresent = other.throwOnCapabilityNotPresent;
        }
        if (this.isMergeAble(other.registry, this.registry)) {
            this.registry = other.registry;
        }
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "hubConfig", this.hubConfig));
        sb.append((CharSequence)this.toString(format, "capabilityMatcher", this.capabilityMatcher.getClass().getCanonicalName()));
        sb.append((CharSequence)this.toString(format, "newSessionWaitTimeout", this.newSessionWaitTimeout));
        sb.append((CharSequence)this.toString(format, "prioritizer", this.prioritizer != null ? this.prioritizer.getClass().getCanonicalName() : null));
        sb.append((CharSequence)this.toString(format, "throwOnCapabilityNotPresent", this.throwOnCapabilityNotPresent));
        sb.append((CharSequence)this.toString(format, "registry", this.registry));
        return sb.toString();
    }

    @Override
    protected void addJsonTypeAdapter(GsonBuilder builder) {
        super.addJsonTypeAdapter(builder);
        GridHubConfiguration.staticAddJsonTypeAdapter(builder);
    }

    protected static void staticAddJsonTypeAdapter(GsonBuilder builder) {
        builder.registerTypeAdapter(CapabilityMatcher.class, (Object)new CapabilityMatcherAdapter().nullSafe());
        builder.registerTypeAdapter(Prioritizer.class, (Object)new PrioritizerAdapter().nullSafe());
    }

    protected static class PrioritizerAdapter
    extends SimpleClassNameAdapter<Prioritizer> {
        protected PrioritizerAdapter() {
        }
    }

    protected static class CapabilityMatcherAdapter
    extends SimpleClassNameAdapter<CapabilityMatcher> {
        protected CapabilityMatcherAdapter() {
        }
    }

    protected static class SimpleClassNameAdapter<T>
    extends TypeAdapter<T> {
        protected SimpleClassNameAdapter() {
        }

        public void write(JsonWriter out, T value) throws IOException {
            out.value(value.getClass().getCanonicalName());
        }

        public T read(JsonReader in) throws IOException {
            String value = in.nextString();
            try {
                return (T)Class.forName(value).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("String %s could not be coerced to class: %s", value, Class.class.getName()), e);
            }
        }
    }
}

