/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openqa.grid.common.exception.GridConfigurationException;

public class StandaloneConfiguration {
    public static final String DEFAULT_STANDALONE_CONFIG_FILE = "org/openqa/grid/common/defaults/DefaultStandalone.json";
    @VisibleForTesting
    static final Integer DEFAULT_TIMEOUT = 1800;
    @VisibleForTesting
    static final Integer DEFAULT_BROWSER_TIMEOUT = 0;
    @VisibleForTesting
    static final String DEFAULT_ROLE = "standalone";
    @VisibleForTesting
    static final Integer DEFAULT_PORT = 4444;
    @VisibleForTesting
    static final Boolean DEFAULT_DEBUG_TOGGLE = false;
    @Expose(serialize=false)
    private boolean avoidProxy;
    @Expose(serialize=false)
    private boolean browserSideLog;
    @Expose(serialize=false)
    private boolean captureLogsOnQuit;
    @Expose
    public Integer browserTimeout = DEFAULT_BROWSER_TIMEOUT;
    @Expose
    public Boolean debug = DEFAULT_DEBUG_TOGGLE;
    @Expose
    public Integer jettyMaxThreads;
    @Expose
    public String log;
    @Expose
    public Integer port = DEFAULT_PORT;
    @Expose
    public String role = "standalone";
    @Expose
    public Integer timeout = DEFAULT_TIMEOUT;

    public static StandaloneConfiguration loadFromJSON(String filePath) {
        return StandaloneConfiguration.loadFromJSON(StandaloneConfiguration.loadJSONFromResourceOrFile(filePath));
    }

    public static StandaloneConfiguration loadFromJSON(JsonObject json) {
        try {
            GsonBuilder builder = new GsonBuilder();
            StandaloneConfiguration config = (StandaloneConfiguration)builder.excludeFieldsWithoutExposeAnnotation().create().fromJson((JsonElement)json, StandaloneConfiguration.class);
            return config;
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public void merge(StandaloneConfiguration other) {
        if (other == null) {
            return;
        }
        if (this.isMergeAble(other.browserTimeout, this.browserTimeout)) {
            this.browserTimeout = other.browserTimeout;
        }
        if (this.isMergeAble(other.jettyMaxThreads, this.jettyMaxThreads)) {
            this.jettyMaxThreads = other.jettyMaxThreads;
        }
        if (this.isMergeAble(other.timeout, this.timeout)) {
            this.timeout = other.timeout;
        }
    }

    protected boolean isMergeAble(Object other, Object target) {
        if (other == null) {
            return false;
        }
        if (target == null) {
            return true;
        }
        if (!target.getClass().getSuperclass().getTypeName().equals(other.getClass().getSuperclass().getTypeName())) {
            return false;
        }
        if (target instanceof Collection) {
            return !((Collection)other).isEmpty();
        }
        if (target instanceof Map) {
            return !((Map)other).isEmpty();
        }
        return true;
    }

    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.toString(format, "browserTimeout", this.browserTimeout));
        sb.append((CharSequence)this.toString(format, "debug", this.debug));
        sb.append((CharSequence)this.toString(format, "jettyMaxThreads", this.jettyMaxThreads));
        sb.append((CharSequence)this.toString(format, "log", this.log));
        sb.append((CharSequence)this.toString(format, "port", this.port));
        sb.append((CharSequence)this.toString(format, "role", this.role));
        sb.append((CharSequence)this.toString(format, "timeout", this.timeout));
        return sb.toString();
    }

    public String toString() {
        return this.toString(" -%1$s %2$s");
    }

    public StringBuilder toString(String format, String name, Object value) {
        StringBuilder sb = new StringBuilder();
        List<Object> iterator = value instanceof List ? (List<Object>)value : Arrays.asList(value);
        for (Object e : iterator) {
            if (e == null || e instanceof Map && ((Map)e).isEmpty() || e instanceof Collection && ((Collection)e).isEmpty()) continue;
            sb.append(String.format(format, name, e));
        }
        return sb;
    }

    public JsonElement toJson() {
        GsonBuilder builder = new GsonBuilder();
        this.addJsonTypeAdapter(builder);
        return builder.excludeFieldsWithoutExposeAnnotation().create().toJsonTree((Object)this);
    }

    protected void addJsonTypeAdapter(GsonBuilder builder) {
    }

    protected static JsonObject loadJSONFromResourceOrFile(String resource) {
        try {
            return new JsonParser().parse(StandaloneConfiguration.readFileOrResource(resource)).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            throw new GridConfigurationException("Wrong format for the JSON input : " + e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    private static String readFileOrResource(String resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ RuntimeException lambda$readFileOrResource$4(String resource) {
        return new RuntimeException(resource + " is not a valid resource.");
    }

    private static /* synthetic */ InputStream lambda$readFileOrResource$3(String resource, Function supplier) {
        return (InputStream)supplier.apply(resource);
    }

    private static /* synthetic */ InputStream lambda$readFileOrResource$2(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    private static /* synthetic */ InputStream lambda$readFileOrResource$1(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("org/openqa/grid/common/" + path);
    }

    private static /* synthetic */ InputStream lambda$readFileOrResource$0(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

