/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.util.Random;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.helpers.BasicMarker;
import org.slf4j.helpers.NOPLogger;

public class NoBindingTest
extends TestCase {
    int diff = new Random().nextInt(10000);

    public void testLogger() {
        Logger logger = LoggerFactory.getLogger(NoBindingTest.class);
        logger.debug("hello" + this.diff);
        NoBindingTest.assertTrue((boolean)(logger instanceof NOPLogger));
    }

    public void testMDC() {
        MDC.put((String)("k" + this.diff), (String)"v");
        NoBindingTest.assertNull((Object)MDC.get((String)"k"));
    }

    public void testMarker() {
        Marker m = MarkerFactory.getMarker((String)("a" + this.diff));
        NoBindingTest.assertTrue((boolean)(m instanceof BasicMarker));
    }
}

