/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.NameAndSourceAttributes;

public class ClassAttributes
extends NameAndSourceAttributes {
    public static final String INTERFACE = "interface";
    public static final String ABSTRACT_CLASS = "abstract class";
    public static final String CLASS = "class";
    public static final String UNKNOWN = "unknown external class";
    private final String _type;
    private final boolean _innerClass;
    private final int _size;

    public ClassAttributes(String string, String string2, String string3, int n) {
        super(string);
        if (string2 != null) {
            this.addSource(string2);
        }
        this._type = string3;
        this._innerClass = string != null && string.indexOf(36) > 0;
        this._size = n;
    }

    public static ClassAttributes createInterface(String string, String string2, int n) {
        return new ClassAttributes(string, string2, INTERFACE, n);
    }

    public static ClassAttributes createAbstractClass(String string, String string2, int n) {
        return new ClassAttributes(string, string2, ABSTRACT_CLASS, n);
    }

    public static ClassAttributes createClass(String string, String string2, int n) {
        return new ClassAttributes(string, string2, CLASS, n);
    }

    public static ClassAttributes createUnknownClass(String string, int n) {
        return new ClassAttributes(string, null, UNKNOWN, n);
    }

    public String getType() {
        return this._type;
    }

    public boolean isInnerClass() {
        return this._innerClass;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(this._innerClass ? "inner " : "");
        stringBuffer.append(this._type).append(' ').append(this.getName());
        if (this._size > 0) {
            stringBuffer.append(" (").append(this._size).append(" bytes)");
        }
        if ((string = this.getSources()).length() > 0) {
            stringBuffer.append(" sources: ").append(string);
        }
        return new String(stringBuffer);
    }
}

