/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.ClassAttributes;
import classycle.PackageVertex;
import classycle.graph.AtomicVertex;
import classycle.graph.GraphProcessor;
import classycle.graph.Vertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PackageProcessor
extends GraphProcessor {
    private final HashMap _packageVertices = new HashMap();
    private final List _arcs = new ArrayList();
    private AtomicVertex[] _packageGraph;

    public AtomicVertex[] getGraph() {
        return this._packageGraph;
    }

    @Override
    protected void initializeProcessing(Vertex[] vertexArray) {
        this._packageVertices.clear();
    }

    @Override
    protected void processBefore(Vertex vertex) {
    }

    @Override
    protected void processArc(Vertex vertex, Vertex vertex2) {
        PackageVertex packageVertex = this.getPackageVertex(vertex);
        PackageVertex packageVertex2 = this.getPackageVertex(vertex2);
        boolean bl = ((AtomicVertex)vertex2).isGraphVertex();
        this._arcs.add(new Arc(packageVertex, packageVertex2, bl));
    }

    private PackageVertex getPackageVertex(Vertex vertex) {
        ClassAttributes classAttributes = (ClassAttributes)vertex.getAttributes();
        String string = classAttributes.getName();
        int n = string.lastIndexOf(46);
        String string2 = n < 0 ? "(default package)" : string.substring(0, n);
        PackageVertex packageVertex = (PackageVertex)this._packageVertices.get(string2);
        if (packageVertex == null) {
            packageVertex = new PackageVertex(string2);
            this._packageVertices.put(string2, packageVertex);
        }
        if (this.isVertexFromGraph(vertex)) {
            packageVertex.reset();
        }
        packageVertex.addClass(classAttributes);
        return packageVertex;
    }

    private boolean isVertexFromGraph(Vertex vertex) {
        return vertex instanceof AtomicVertex && ((AtomicVertex)vertex).isGraphVertex();
    }

    @Override
    protected void processAfter(Vertex vertex) {
    }

    @Override
    protected void finishProcessing(Vertex[] vertexArray) {
        for (int i = 0; i < this._arcs.size(); ++i) {
            ((Arc)this._arcs.get(i)).create();
        }
        Iterator iterator = this._packageVertices.values().iterator();
        ArrayList<AtomicVertex> arrayList = new ArrayList<AtomicVertex>();
        while (iterator.hasNext()) {
            AtomicVertex atomicVertex = (AtomicVertex)iterator.next();
            if (!atomicVertex.isGraphVertex()) continue;
            arrayList.add(atomicVertex);
        }
        this._packageGraph = arrayList.toArray(new AtomicVertex[arrayList.size()]);
    }

    private static final class Arc {
        final AtomicVertex tail;
        final AtomicVertex head;
        final boolean internalHeadClass;

        Arc(AtomicVertex atomicVertex, AtomicVertex atomicVertex2, boolean bl) {
            this.tail = atomicVertex;
            this.head = atomicVertex2;
            this.internalHeadClass = bl;
        }

        void create() {
            if (this.internalHeadClass || !this.head.isGraphVertex()) {
                this.tail.addOutgoingArcTo(this.head);
            }
        }
    }
}

