/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.ClassAttributes;
import classycle.ClassNameExtractor;
import classycle.GraphBuilder;
import classycle.UnresolvedNode;
import classycle.classfile.ClassConstant;
import classycle.classfile.Constant;
import classycle.classfile.StringConstant;
import classycle.classfile.UTF8Constant;
import classycle.graph.AtomicVertex;
import classycle.util.StringPattern;
import classycle.util.TrueStringPattern;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Parser {
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private static final String[] ZIP_FILE_TYPES = new String[]{".zip", ".jar", ".war", ".ear"};

    private Parser() {
    }

    public static AtomicVertex[] readClassFiles(String[] stringArray) throws IOException {
        return Parser.readClassFiles(stringArray, new TrueStringPattern(), null, false);
    }

    public static AtomicVertex[] readClassFiles(String[] stringArray, StringPattern stringPattern, StringPattern stringPattern2, boolean bl) throws IOException {
        File[] fileArray;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file = new File(string);
            if (file.isDirectory()) {
                Parser.analyseClassFile(file, string, arrayList, stringPattern2);
                fileArray = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return Parser.isZipFile(file);
                    }
                });
                for (int j = 0; j < fileArray.length; ++j) {
                    String string2 = Parser.createSourceName(string, fileArray[j].getName());
                    Parser.analyseClassFiles(new ZipFile(fileArray[j].getAbsoluteFile()), string2, arrayList, stringPattern2);
                }
                continue;
            }
            if (file.getName().endsWith(".class")) {
                Parser.analyseClassFile(file, null, arrayList, stringPattern2);
                continue;
            }
            if (Parser.isZipFile(file)) {
                Parser.analyseClassFiles(new ZipFile(file.getAbsoluteFile()), string, arrayList, stringPattern2);
                continue;
            }
            throw new IOException(string + " is an invalid file.");
        }
        ArrayList<File[]> arrayList2 = new ArrayList<File[]>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            fileArray = (File[])arrayList.get(i);
            if (!fileArray.isMatchedBy(stringPattern)) continue;
            arrayList2.add(fileArray);
        }
        UnresolvedNode[] unresolvedNodeArray = new UnresolvedNode[arrayList2.size()];
        unresolvedNodeArray = arrayList2.toArray(unresolvedNodeArray);
        return GraphBuilder.createGraph(unresolvedNodeArray, bl);
    }

    private static String createSourceName(String string, String string2) {
        return string + (string.endsWith(File.separator) ? string2 : File.separatorChar + string2);
    }

    private static boolean isZipFile(File file) {
        boolean bl = false;
        String string = file.getName();
        for (int i = 0; i < ZIP_FILE_TYPES.length; ++i) {
            if (!string.endsWith(ZIP_FILE_TYPES[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static void analyseClassFile(File file, String string, ArrayList arrayList, StringPattern stringPattern) throws IOException {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!file2.isDirectory() && !stringArray[i].endsWith(".class")) continue;
                Parser.analyseClassFile(file2, string, arrayList, stringPattern);
            }
        } else {
            arrayList.add(Parser.extractNode(file, string, stringPattern));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UnresolvedNode extractNode(File file, String string, StringPattern stringPattern) throws IOException {
        FileInputStream fileInputStream = null;
        UnresolvedNode unresolvedNode = null;
        try {
            fileInputStream = new FileInputStream(file);
            unresolvedNode = Parser.createNode(fileInputStream, string, (int)file.length(), stringPattern);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return unresolvedNode;
    }

    private static void analyseClassFiles(ZipFile zipFile, String string, ArrayList arrayList, StringPattern stringPattern) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class")) continue;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            int n = (int)zipEntry.getSize();
            arrayList.add(Parser.createNode(inputStream, string, n, stringPattern));
        }
    }

    private static UnresolvedNode createNode(InputStream inputStream, String string, int n, StringPattern stringPattern) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        Constant[] constantArray = Constant.extractConstantPool(dataInputStream);
        int n2 = dataInputStream.readUnsignedShort();
        String string2 = ((ClassConstant)constantArray[dataInputStream.readUnsignedShort()]).getName();
        ClassAttributes classAttributes = null;
        classAttributes = (n2 & 0x200) != 0 ? ClassAttributes.createInterface(string2, string, n) : ((n2 & 0x400) != 0 ? ClassAttributes.createAbstractClass(string2, string, n) : ClassAttributes.createClass(string2, string, n));
        UnresolvedNode unresolvedNode = new UnresolvedNode();
        unresolvedNode.setAttributes(classAttributes);
        for (int i = 0; i < constantArray.length; ++i) {
            Object object;
            Constant constant = constantArray[i];
            if (constant instanceof ClassConstant) {
                object = (ClassConstant)constant;
                if (((ClassConstant)object).getName().startsWith("[") || ((ClassConstant)object).getName().equals(string2)) continue;
                unresolvedNode.addLinkTo(((ClassConstant)object).getName());
                continue;
            }
            if (constant instanceof UTF8Constant) {
                Parser.parseUTF8Constant((UTF8Constant)constant, unresolvedNode, string2);
                continue;
            }
            if (stringPattern == null || !(constant instanceof StringConstant) || !ClassNameExtractor.isValid((String)(object = ((StringConstant)constant).getString())) || !stringPattern.matches((String)object)) continue;
            unresolvedNode.addLinkTo((String)object);
        }
        return unresolvedNode;
    }

    static void parseUTF8Constant(UTF8Constant uTF8Constant, UnresolvedNode unresolvedNode, String string) {
        Set set = new ClassNameExtractor(uTF8Constant).extract();
        for (String string2 : set) {
            if (string.equals(string2)) continue;
            unresolvedNode.addLinkTo(string2);
        }
    }
}

